// The Vue build version to load with the `import` command
// (runtime-only or standalone) has been set in webpack.base.conf with an alias.

import '@fortawesome/fontawesome-free/css/all.css'
import 'material-design-icons-iconfont/dist/material-design-icons.css'

import "babel-polyfill";

import Vue from 'vue'

import Vuex from 'vuex';
Vue.use(Vuex);
import store from '@/store';
store.install(Vuex);


import ElementUI from 'element-ui';
import 'element-ui/lib/theme-chalk/index.css'
Vue.use(ElementUI)

import App from './App'
import router from './router'

Vue.config.productionTip = false


// 导入 crypto-js 包 
import cryptoJS from 'crypto-js/crypto-js'
//把AES加密vue原型里
Vue.prototype.$cryptoJS = cryptoJS;

/* eslint-disable no-new */
import api from './request/api'
Vue.prototype.$api = api;
new Vue({
  el: '#app',
  router,
  components: { App },
  template: '<App/>'
})
