import axios from '@/request/http'; // 导入http中创建的axios实例
import qs from 'qs'; // 根据需求是否导入qs模块

const general = {
    login(params) {
        return axios.post(`/iam/api/login`, params);
    },
    validateUser(params) {
        return axios.get(`/apaas/backmgt/user/checkUserId?user_id=${params.value}`);
    },
    register(params) {
        return axios.post(`/apaas/backmgt/user/register`, params);
    },
    getOrganizations() {
        return axios.get(`/apaas/backmgt/department/list`);
    },

    // user info
    getNowUser() {
        return axios.get(`/iam/api/getCurUser`);
    },

    // 获取验证码
    getrandomCode() {
        return axios.get(`/iam/api/getCaptcha?width=240&height=60`);
    },
    // 校验验证码
    validateRandomCode(id, value) {
        return axios.get(`/iam/api/verifyCaptcha?id=${id}&value=${value}`);
    }
}

export default general;
