package handler

import (
	"fmt"
	"github.com/gin-gonic/gin"
	"github.com/sirupsen/logrus"
	"gitlab.wodcloud.com/apaas/apaas-meshproxy/src/client"
	"net/http"

	"github.com/vulcand/oxy/forward"
	"github.com/vulcand/oxy/testutils"
	"gitlab.wodcloud.com/apaas/apaas-meshproxy/src/config"
)

var fwd *forward.Forwarder

func init() {
	fwd, _ = forward.New(forward.PassHostHeader(true))
}

func Proxy(c *gin.Context) {
	if err := count(); err != nil {
		fmt.Println(err.Error())
		c.String(200, "缓存计数失败!")
		return
	}
	req := c.Request
	baseUrl := "http://" + req.Host + req.URL.Path
	req.URL = testutils.ParseURI(getProxyURL(req))
	req.RequestURI = getRequestURI(req)
	req.Host = req.URL.Host
	logrus.Info("************************************")
	logrus.Info("* 调用地址：", baseUrl)
	logrus.Info("* 转发地址：", req.URL)
	logrus.Info("************************************")
	fwd.ServeHTTP(c.Writer, req)
}

func getProxyURL(req *http.Request) string {
	// 获取转发地址
	result := config.ProxyConf.Url
	//path := req.URL.Path
	//path = strings.Replace(req.URL.Path, config.Prefix+"/proxy", config.ProxyPath, 1)
	//rawQuery := req.URL.RawQuery
	//var result = ""
	//if rawQuery == "" {
	//	result = fmt.Sprintf("http://%s%s", config.ProxyHost, path)
	//} else {
	//	result = fmt.Sprintf("http://%s%s?%s", config.ProxyHost, path, rawQuery)
	//}
	//if strings.Contains(result, "?") {
	//	if strings.HasSuffix(result, "/") {
	//		result = strings.TrimRight(result, "/")
	//	}
	//}
	return result
}

func getRequestURI(req *http.Request) string {
	path := req.URL.Path
	rawQuery := req.URL.RawQuery
	var result = ""
	if rawQuery == "" {
		result = path
	} else {
		result = path + "?" + rawQuery
	}
	return result
}

/**
计数
*/
func count() error {
	redis, err := client.GetRedisClient()
	if err != nil {
		return err
	}
	ic, err := redis.Incr("bgproxy" + config.ProxyConf.UUID)
	_, err = ic.Result()
	return err
}
