package handler

import (
	"fmt"
	"net/http"

	"gitlab.wodcloud.com/apaas/apaas-meshproxy/src/client"
	"gitlab.wodcloud.com/apaas/apaas-meshproxy/src/config"
)

// CountHandler , a proxy handler
type CountHandler struct {
}

// CreateCountHandler , a proxy handler
func CreateCountHandler() (*CountHandler, error) {
	handler := new(CountHandler)
	return handler, nil
}

func (handler *CountHandler) ServeHTTP(w http.ResponseWriter, req *http.Request) {
	redis, err := client.GetRedisClient()
	if err != nil {
		w.Write([]byte(err.Error()))
	}
	ic, err := redis.Get(fmt.Sprintf("%s%s", config.ProxyHost, config.ProxyPath))
	w.Write([]byte(ic))
}
