package model

import "time"

type ProxyData struct {
	ApplyId          int64     `json:"apply_id"`
	ReqUrl           string    `json:"req_url"`
	RequestCount     int64     `json:"request_count"`
	Duration         int64     `json:"duration"`
	DurationUnit     int64     `json:"duration_unit"`
	SpcsType         int       `json:"spcs_type"`
	SpcsCount        int64     `json:"spcs_count"`
	ResFields        string    `json:"res_fields"`
	DataServiceType1 int64     `json:"data_service_type1"`
	DataServiceType2 int64     `json:"data_service_type2"`
	DataServiceType3 int64     `json:"data_service_type3"`
	SecondLevel      int64     `json:"second_level"`
	ServiceEndTime   time.Time `json:"service_end_time"`
	ReqName          string    `json:"req_name"`
	ServiceState     int64     `json:"service_state"`
	PayStatus        int64     `json:"pay_status"`
	ApplyUserId      string    `json:"apply_user_id"`
	ServiceUserId    string    `json:"service_user_id"`
	ServiceOid       string    `json:"service_oid"`
	ApplyOid         string    `json:"apply_oid"`
	SensituveWord    string    `json:"sensituve_word"`
	SensitiveCount   int64     `json:"sensitive_count"`
	ServiceId        int64     `json:"service_id"`
	ApiId            int64     `json:"api_id"` //接口ID
}

type WebRes struct {
	Success int         `json:"success"`
	ErrMsg  string      `json:"errMsg,omitempty"`
	Data    interface{} `json:"data,omitempty"`
}
