/*
@Time : 2020/4/23 18:19
@Author : gaoshiyao
@File : user
@Software: GoLand
@Des:
*/
package tables

import "time"

type User struct {
	UserId      string    `json:"user_id" xorm:"not null pk VARCHAR(50)"`
	UserName    string    `json:"user_name" xorm:"VARCHAR(100)"`
	Password    string    `json:"password" xorm:"VARCHAR(100)"`
	Phone       string    `json:"phone" xorm:"VARCHAR(11)"`
	Email       string    `json:"email" xorm:"VARCHAR(30)"`
	Oid         string    `json:"oid" xorm:"VARCHAR(50)"`
	CreateUser  string    `json:"create_user" xorm:"VARCHAR(50)"`
	CreateDate  time.Time `json:"create_date" xorm:"DATETIME"`
	IsAdmin     int       `json:"is_admin" xorm:"SMALLINT"`
	State       int       `json:"state" xorm:"SMALLINT"`
	Position    string    `json:"position" xorm:"VARCHAR(100)"`
	Description string    `json:"description" xorm:"VARCHAR(100)"`
	Wechat      string    `json:"wechat" xorm:"VARCHAR(50)"`
	Qq          string    `json:"qq" xorm:"VARCHAR(50)"`
	PicturePath string    `json:"picture_path" xorm:"VARCHAR(500)"`
}

func (*User) TableName() string {
	return "bg_user"
}

//简洁的用户信息
type BriefUserInfo struct {
	UserName       string `json:"user_name"`
	Phone          string `json:"phone"`
	Oid            string `json:"oid"`             //组织ID
	DepartmentName string `json:"department_name"` //组织名称
}
