// Copyright 2018 Drone.IO Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package router

import (
	"fmt"
	"github.com/gin-gonic/gin"
	"gitlab.wodcloud.com/apaas/apaas-meshproxy/src/config"
	"gitlab.wodcloud.com/apaas/apaas-meshproxy/src/handler"
	"gitlab.wodcloud.com/apaas/apaas-meshproxy/src/router/middleware/header"
	"net/http"
)

// Load loads the router
func Load(middleware ...gin.HandlerFunc) http.Handler {
	e := gin.Default()
	e.Use(header.NoCache)
	e.Use(header.Options)
	e.Use(header.Secure)
	e.Use(middleware...)
	root := e.Group(fmt.Sprintf("%s/%s", config.Prefix, config.MeshId))
	{
		//root.GET("/health", handler.HealthCheck)
		root.GET("/health/:apiid/*any", handler.HealthCheck)
		//root.Any("/service/:applyId", handler.Proxy)
		root.Any("/service/:applyId/:apiid", handler.Proxy)
		root.Any("/service/:applyId/:apiid/*any", handler.Proxy)
		//root.GET("/static/*any", handler.StaticProxy)
	}
	return e
}
