package handler

import (
	"bytes"
	"compress/gzip"
	"encoding/json"
	"errors"
	"github.com/gin-gonic/gin"
	"github.com/vulcand/oxy/forward"
	"github.com/vulcand/oxy/testutils"
	"gitlab.wodcloud.com/apaas/apaas-meshproxy/src/model"
	"gitlab.wodcloud.com/apaas/apaas-meshproxy/src/service"
	"io/ioutil"
	"net/http"
	"strconv"
	"strings"
)

//var Resp *http.Response

func Proxy(c *gin.Context) {
	applyId := c.Param("applyId")
	if applyId == "" {
		res := model.WebRes{}
		res.Data = "applyId不能为空"
		c.JSON(200, res)
		return
	}
	//获取服务相关信息
	proxyData, err := service.GetRealPath(applyId)

	if err != nil {
		c.Error(err)
		return
	}
	if proxyData.Second_level != 1 {
		res := model.WebRes{}
		res.ErrMsg = `服务申请未通过审批，请联系组织管理员或超管审批`
		c.JSON(200, res)
		return
	}
	f, _ := forward.New(forward.PassHostHeader(true), forward.ResponseModifier(func(resp *http.Response) error {
		//Resp = resp
		//判断是否超过调用次数是否可以调用
		callflag, sensitiveflag, err := service.QueryCallsCount(proxyData)
		if err != nil {
			return nil
		}
		if callflag == false {
			err = errors.New(`调用达到当日限定次数`)
			Return(nil, err, resp)
			return nil
		}
		respbody, _ := ioutil.ReadAll(resp.Body)
		var res interface{}
		res = respbody
		//是否需要过滤字段
		if proxyData.ResFields != "" {
			res = service.FiledFilter(proxyData, respbody)
		}
		//是否需要屏蔽敏感字段
		if sensitiveflag == false {
			res = service.SensitiveFilter(proxyData, res)
		}
		//计次
		go service.CallCounts(proxyData)
		//err = service.CallCounts(proxyData)
		//if err != nil {
		//	Return(nil, err, resp)
		//	return nil
		//}

		////个人申请调用计次
		//err = service.ApplyCallCounts(proxyData)
		//if err != nil {
		//	Return(nil, err, resp)
		//	return nil
		//}
		Return(res, nil, resp)
		return nil
	}))
	c.Request.URL = testutils.ParseURI(getProxyURL(proxyData, c.Request))
	c.Request.RequestURI = getRequestURI(c.Request)
	c.Request.Host = getHost(proxyData.RealUrl)
	f.ServeHTTP(c.Writer, c.Request)
}

func getProxyURL(proxyData model.ProxyData, req *http.Request) string {
	realPath := proxyData.RealUrl
	rawQuery := req.URL.RawQuery
	var result = ""
	if rawQuery == "" {
		if proxyData.Name == "时空服务" {
			result = realPath + "?f=json"
		} else {
			result = realPath
		}
	} else {
		result = realPath + "?" + rawQuery
		if proxyData.Name == "时空服务" && !strings.Contains(rawQuery, "f=json") {
			result = result + "&f=json"
		}
	}
	return result
}

func getRequestURI(req *http.Request) string {
	path := req.URL.Path
	rawQuery := req.URL.RawQuery
	var result = ""
	if rawQuery == "" {
		result = path
	} else {
		result = path + "?" + rawQuery
	}
	return result
}

func Return(res interface{}, err error, Resp *http.Response) {
	var b []byte
	if err == nil {
		switch res.(type) {
		case []byte:
			b = res.([]byte)
		case interface{}:
			b, _ = json.Marshal(res)

		}
	} else {
		if Resp.Header.Get("Content-Encoding") == "gzip" {
			b = []byte(err.Error())
			b = gzipCompress(&b)
		}
	}
	Resp.Header.Set("X-Log-By", "Apaas")
	Resp.Header.Set("Content-Length", strconv.Itoa(len(b)))
	Resp.Body = ioutil.NopCloser(bytes.NewBuffer(b))
}

func gzipCompress(content *[]byte) []byte {
	var compressData bytes.Buffer
	gzipWriter := gzip.NewWriter(&compressData)
	defer gzipWriter.Close()
	gzipWriter.Write(*content)
	gzipWriter.Flush()
	return compressData.Bytes()
}

// 获取域名
func getHost(url string) (path string) {
	if strings.Contains(url, "//") {
		path = strings.Split(url, "//")[1]
		if strings.Contains(path, "/") {
			path = strings.Split(path, "/")[0]
		}
	}
	return
}
