package tools

import (
	"bytes"
	"crypto/md5"
	"encoding/json"
	"fmt"
	"github.com/Chain-Zhang/pinyin"
	"github.com/gin-gonic/gin"
	"gitlab.wodcloud.com/apaas/apaas-meshproxy/src/config"
	"gitlab.wodcloud.com/apaas/apaas-meshproxy/src/model/tables"
	"io"
	"strconv"
	"strings"
	"time"
)

// , http请求
//func ProxySend(sendType string, url string, body string, header map[string]string) (result *http.Response, err error) {
//	if err != nil {
//		return result, err
//	}
//	client := &http.Client{}
//	var reqest *http.Request
//	if sendType == "GET" || sendType == "DELETE" {
//		reqest, _ = http.NewRequest(sendType, url, nil)
//	} else if sendType == "POST" || sendType == "PUT" {
//		reqest, _ = http.NewRequest(sendType, url, strings.NewReader(body))
//	}
//	if header == nil {
//		header = make(map[string]string)
//	}
//	header["Accept"] = "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8"
//	header["Accept-Language"] = "ja,zh-CN;q=0.8,zh;q=0.6"
//	header["Connection"] = "keep-alive"
//	for k, v := range header {
//		reqest.Header.Set(k, v)
//	}
//	response, errc := client.Do(reqest)
//	return response, errc
//	//fmt.Println("StatusCode:", response.StatusCode)
//	//fmt.Println(response.Request.URL)
//	//if errc != nil {
//	//	return nil, errc
//	//} else {
//	//	defer response.Body.Close()
//	//	body, erra := ioutil.ReadAll(response.Body)
//	//	return body, erra
//	//}
//}

//ProxySend , http请求
//func ProxySendRes(sendType string, url string, body string, header map[string]string) (result []byte, err error) {
//	if err != nil {
//		return result, err
//	}
//	client := &http.Client{}
//	var reqest *http.Request
//	if sendType == "GET" || sendType == "DELETE" {
//		reqest, _ = http.NewRequest(sendType, url, nil)
//	} else if sendType == "POST" || sendType == "PUT" {
//		reqest, _ = http.NewRequest(sendType, url, strings.NewReader(body))
//	}
//	if header == nil {
//		header = make(map[string]string)
//	}
//	header["Accept"] = "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8"
//	header["Accept-Language"] = "ja,zh-CN;q=0.8,zh;q=0.6"
//	header["Connection"] = "keep-alive"
//	for k, v := range header {
//		reqest.Header.Set(k, v)
//	}
//	response, errc := client.Do(reqest)
//	if errc != nil {
//		return nil, errc
//	} else {
//		defer response.Body.Close()
//		body, erra := ioutil.ReadAll(response.Body)
//		if response.StatusCode >= 400 {
//			err = errors.New(string(body))
//			return
//		}
//		return body, erra
//	}
//}

//GetCookieStr , 获取cookie字符串
//func GetCookieStr(req *http.Request) (str string, err error) {
//	cookies := req.Cookies()
//	for _, v := range cookies {
//		str += v.Name + "=" + v.Value + ";"
//	}
//	return str, nil
//}

/**
GB单位转换
*/
func Sizeformat(bytesize float64) (float64, string) {
	arr := []string{"Bytes", "KiB", "MiB", "GiB", "TiB"}
	i := 0
	for bytesize >= 1024 {
		bytesize = bytesize / 1024
		i++
	}
	return bytesize, arr[i]
}

func FormatBytes(data string) (res int) {
	arr := []string{"T", "G", "M", "K", "Byte"}
	var flag bool
	for _, v := range arr {
		if strings.Contains(data, v) {
			flag = true
			res, _ = strconv.Atoi(strings.Split(data, v)[0])
			continue
		}
		if flag {
			fmt.Println("=========")
			res = res * 1024
		}
	}
	return
}

// float 保留两位小数
func FloatSave2(value float64) float64 {
	value, _ = strconv.ParseFloat(fmt.Sprintf("%.2f", value), 64)
	return value
}

func HasValue(arr []string, str string) bool {
	for _, v := range arr {
		if v == str {
			return true
		}
	}
	return false
}

// 生成流水号
func CreateLsh(name string, t string) string {
	// namespace-unix-class
	// 6位随机数 fmt.Sprintf("%06v", rand.New(rand.NewSource(time.Now().UnixNano())).Int31n(1000000))
	lsh := fmt.Sprintf("%s-%s-%s", name, time.Now().Format(config.TIME_FORMAT_TWO), t)
	return lsh
}

func Md5Pwd(str string) string {
	w := md5.New()
	io.WriteString(w, str)
	md5str := fmt.Sprintf("%x", w.Sum(nil))
	return md5str
}

func PyFirst(py string) string {
	if py == "" {
		return ""
	}
	py, _ = pinyin.New(py).Mode(pinyin.InitialsInCapitals).Split("").Convert()
	return strings.ToUpper(string([]rune(py)[0]))
}

//获取上下文用户信息
func GetContextUser(c *gin.Context) *tables.User {
	if value, exists := c.Get("user_info"); exists {
		if user, ok := value.(tables.User); ok {
			return &user
		}
	}
	return nil
}

//获取上线文header信息
func GetContextHeader(c *gin.Context) map[string]string {

	if value, exists := c.Get("header"); exists {
		if header, ok := value.(map[string]string); ok {
			return header
		}
	}
	return nil
}

//获取上线文 COOKIE_APAAS_NAME 内容
func GetContextApaasToken(c *gin.Context) string {
	if value, exists := c.Get(config.COOKIE_APAAS_NAME); exists {
		if apaasToken, ok := value.(string); ok {
			return apaasToken
		}
	}
	return ""
}

func ParseInt(val string, defaultVal int) int {
	if v, err := strconv.Atoi(val); err != nil {
		return defaultVal
	} else {
		return v
	}
}

func ParseInt64(val string, defaultVal int64) int64 {
	if v, err := strconv.ParseInt(val, 10, 64); err != nil {
		return defaultVal
	} else {
		return v
	}
}

func ParseFloat64(val string, defaultVal float64) float64 {
	if float, err := strconv.ParseFloat(val, 64); err != nil {
		return defaultVal
	} else {
		return float
	}
}

//格式化打印json
func FormatPrintJson(name string, jsons []byte) {
	var str bytes.Buffer
	_ = json.Indent(&str, jsons, "", "    ")
	fmt.Println("\n\n\n=======", name, "=========\n\n\n ", str.String())
}
