package tools

import (
	"gitlab.wodcloud.com/apaas/apaas-meshproxy/src/config"
	"time"
)

type JsonTime time.Time

func (j JsonTime) MarshalJSON() ([]byte, error) {
	return []byte(`"` + time.Time(j).Format(config.LocalDateTimeFormat) + `"`), nil
}

type JsonHour time.Time

func (j JsonHour) MarshalJSON() ([]byte, error) {
	return []byte(`"` + time.Time(j).Format(config.LocalTimeFormat) + `"`), nil
}

type JsonDate time.Time

func (j JsonDate) MarshalJSON() ([]byte, error) {
	return []byte(`"` + time.Time(j).Format(config.LocalDateFormat) + `"`), nil
}

//date1 小于于 date2 返回
func CompareDate(date1, date2 string) bool {
	t1time, _ := time.ParseInLocation("2006-01-02 15:04:05", date1, time.Local)
	t2time, _ := time.ParseInLocation("2006-01-02 15:04:05", date2, time.Local)
	if t1time.Before(t2time) {
		return true
	}
	return false
}
