package handler

import (
	"fmt"
	"github.com/gin-gonic/gin"
	"gitlab.wodcloud.com/apaas/apaas-meshproxy/src/client"
	"gitlab.wodcloud.com/apaas/apaas-meshproxy/src/config"
)

func GetCount(c *gin.Context) {
	redis, err := client.GetRedisClient()
	if err != nil {
		c.Error(err)
	}
	ic, err := redis.Get("bgproxy" + config.ProxyConf.MeshId)
	c.JSON(200, gin.H{
		"Key":   fmt.Sprintf("bgproxy" + config.ProxyConf.MeshId),
		"Count": ic,
	})
}
