package handler

import (
	"fmt"
	"github.com/gin-gonic/gin"
	"gitlab.wodcloud.com/apaas/apaas-meshproxy/src/client"
	"gitlab.wodcloud.com/apaas/apaas-meshproxy/src/tools"
	"net/http"
	"strings"

	"github.com/vulcand/oxy/forward"
	"gitlab.wodcloud.com/apaas/apaas-meshproxy/src/config"
)

var fwd *forward.Forwarder

func init() {
	fwd, _ = forward.New(forward.PassHostHeader(true))
}

func Proxy(c *gin.Context) {
	if err := count(); err != nil {
		fmt.Println(err.Error())
		c.String(200, "缓存计数失败!")
		return
	}
	var result []byte
	var err error
	switch strings.ToUpper(config.ProxyConf.Method) {
	case "GET":
		result, err = tools.ProxySend(c.Request, "GET", config.ProxyConf.Url, "", nil)
	}
	if err != nil {
		c.Error(err)
		return
	}
	c.Writer.Write(result)
}

func getProxyURL(req *http.Request) string {
	// 获取转发地址
	result := config.ProxyConf.Url
	//path := req.URL.Path
	//path = strings.Replace(req.URL.Path, config.Prefix+"/proxy", config.ProxyPath, 1)
	//rawQuery := req.URL.RawQuery
	//var result = ""
	//if rawQuery == "" {
	//	result = fmt.Sprintf("http://%s%s", config.ProxyHost, path)
	//} else {
	//	result = fmt.Sprintf("http://%s%s?%s", config.ProxyHost, path, rawQuery)
	//}
	//if strings.Contains(result, "?") {
	//	if strings.HasSuffix(result, "/") {
	//		result = strings.TrimRight(result, "/")
	//	}
	//}
	return result
}

func getRequestURI(req *http.Request) string {
	path := req.URL.Path
	rawQuery := req.URL.RawQuery
	var result = ""
	if rawQuery == "" {
		result = path
	} else {
		result = path + "?" + rawQuery
	}
	return result
}

/**
计数
*/
func count() error {
	redis, err := client.GetRedisClient()
	if err != nil {
		return err
	}
	ic, err := redis.Incr("bgproxy-" + config.ProxyConf.MeshId)
	_, err = ic.Result()
	return err
}
