package main

import (
	"encoding/json"
	"fmt"
	"io/ioutil"
	"net/http"
	"os"
	"time"

	"github.com/sirupsen/logrus"
	"gitlab.wodcloud.com/apaas/apaas-meshproxy/src/router"

	"gitlab.wodcloud.com/apaas/apaas-meshproxy/src/config"

	"github.com/gin-gonic/contrib/ginrus"
	"github.com/spf13/pflag"
)

var (
	argPort   = pflag.Int("port", 8088, "")
	argPrefix = pflag.String("prefix", "/bgmesh/fiddler", "")
	redisUrl  = pflag.String("redisUrl", "redis://k8s.wodcloud.com:16379", "")
	redisTag  = pflag.String("redisTag", "apaas-mesh-proxy", "")
	confPath  = pflag.String("confPath", "/app/config/proxy.json", "")
)

func main() {
	pflag.Parse()
	initEnv()
	initConfig()
	getProxyConf()
	server()
}

func server() error {
	config.Prefix = *argPrefix
	handler := router.Load(ginrus.Ginrus(logrus.StandardLogger(), time.RFC3339, true))
	fmt.Println(fmt.Sprintf(":%d", *argPort))
	return http.ListenAndServe(
		fmt.Sprintf(":%d", *argPort),
		handler,
	)
}

//注册环境变量
func initEnv() {
	if len(os.Getenv("AWE_REDIS_CONNECTION")) > 0 {
		*redisUrl = os.Getenv("AWE_REDIS_CONNECTION")
	}
}

//注册公共config参数信息
func initConfig() {
	config.RedisTag = *redisTag
	config.RedisURL = *redisUrl
	config.Prefix = *argPrefix
}

// 获取代理参数
func getProxyConf() {
	b, err := ioutil.ReadFile(*confPath)
	if err != nil {
		logrus.Error(err)
		return
	}
	json.Unmarshal(b, &config.ProxyConf)
	fmt.Println("代理参数：", config.ProxyConf)
	if len(config.ProxyConf.MeshId) > 0 {
		*argPrefix += "/" + config.ProxyConf.MeshId
	}
}
