package client

import (
	"fmt"
	"strings"
	"time"

	"gitlab.wodcloud.com/apaas/apaas-meshproxy/src/config"

	"github.com/go-redis/redis"
)

type Redis struct {
	Conn   *redis.Client
	Prefix string
}

var rs Redis

//GetRedisClient 获取connect
func GetRedisClient() (Redis, error) {
	if rs.Conn != nil {
		return rs, nil
	}
	addr := config.RedisURL
	if strings.HasPrefix(config.RedisURL, "redis://") {
		addr = strings.TrimPrefix(config.RedisURL, "redis://")
	}
	rs.Conn = redis.NewClient(&redis.Options{
		Addr:     addr,
		Password: "", // no password set
		DB:       0,  // use default DB
	})
	rs.Prefix = config.RedisTag
	flag := time.Now().Add(time.Second*5 + 1)
	for {
		_, e := rs.Conn.Ping().Result()
		if e != nil {
			fmt.Println("ping redis :" + addr)
		} else {
			fmt.Println("redis is health")
			break
		}
		now := time.Now()
		if now.After(flag) {
			fmt.Println("ping redis timeout!")
			break
		}
		time.Sleep(time.Second * 1)
	}
	return rs, nil
}

func (r Redis) Incr(key string) (ic *redis.IntCmd, err error) {
	key = fmt.Sprintf("%s-%s", strings.ToUpper(r.Prefix), strings.ToUpper(key))
	ic = r.Conn.Incr(strings.ToUpper(key))
	return
}

func (r Redis) HGet(key string, tag string) (str string, err error) {
	key = fmt.Sprintf("%s-%s", strings.ToUpper(r.Prefix), strings.ToUpper(key))
	str, err = r.Conn.HGet(strings.ToUpper(key), strings.ToUpper(tag)).Result()
	return str, err
}

func (r Redis) HSet(key string, tag string, value interface{}) error {
	key = fmt.Sprintf("%s-%s", strings.ToUpper(r.Prefix), strings.ToUpper(key))
	bmd := r.Conn.HSet(strings.ToUpper(key), strings.ToUpper(tag), value)
	return bmd.Err()
}

func (r Redis) HDel(key string, tag string) error {
	key = fmt.Sprintf("%s-%s", strings.ToUpper(r.Prefix), strings.ToUpper(key))
	bmd := r.Conn.HDel(strings.ToUpper(key), strings.ToUpper(tag))
	return bmd.Err()
}

func (r Redis) Get(key string) (str string, err error) {
	key = fmt.Sprintf("%s-%s", strings.ToUpper(r.Prefix), strings.ToUpper(key))
	str, err = r.Conn.Get(strings.ToUpper(key)).Result()
	return str, err
}

func (r Redis) Set(key string, value interface{}, time time.Duration) error {
	key = fmt.Sprintf("%s-%s", strings.ToUpper(r.Prefix), strings.ToUpper(key))
	bmd := r.Conn.Set(strings.ToUpper(key), value, time)
	return bmd.Err()
}

func (r Redis) Del(key string) error {
	key = fmt.Sprintf("%s-%s", strings.ToUpper(r.Prefix), strings.ToUpper(key))
	bmd := r.Conn.Del(strings.ToUpper(key))
	return bmd.Err()
}
