package main

import (
	"fmt"
	"github.com/sirupsen/logrus"
	"net/http"
	"os"

	"gitlab.wodcloud.com/apaas/apaas-meshproxy/src/config"

	"github.com/spf13/pflag"
	"gitlab.wodcloud.com/apaas/apaas-meshproxy/src/handler"
)

var (
	argPort   = pflag.Int("port", 8088, "")
	argPrefix = pflag.String("prefix", "/test", "")
	redisUrl  = pflag.String("redisUrl", "redis://k8s.wodcloud.com:16379", "")
	redisTag  = pflag.String("redisTag", "apaas-mesh-proxy", "")
)

func main() {
	pflag.Parse()
	initEnv()
	initConfig()
	proxyhandler, _ := handler.CreateProxyHandler()
	counthandler, _ := handler.CreateCountHandler()
	http.Handle(fmt.Sprintf("%s%s", *argPrefix, "/count"), counthandler)
	http.Handle(*argPrefix+"/", proxyhandler)
	logrus.Info("Listen Server on port :", *argPort)
	http.ListenAndServe(fmt.Sprintf(":%d", *argPort), nil)
}

//注册环境变量
func initEnv() {
	if len(os.Getenv("AWE_REDIS_CONNECTION")) > 0 {
		*redisUrl = os.Getenv("AWE_REDIS_CONNECTION")
	}
}

//注册公共config参数信息
func initConfig() {
	config.RedisTag = *redisTag
	config.RedisURL = *redisUrl
	config.Prefix = *argPrefix
}
