package logger

import (
	"github.com/natefinch/lumberjack"
	"github.com/sirupsen/logrus"
	"io"
	"os"
)

var Logger *logrus.Logger

func Init(level logrus.Level, logfile string) {
	if Logger == nil {
		Logger = logrus.New()
		Logger.Level = level
		Logger.Formatter = &logrus.JSONFormatter{}
		Logger.Out = GetWriter(logfile)
	}
}

func GetWriter(logfile string) io.Writer {
	if len(logfile) == 0 {
		return os.Stdout
	} else {
		return &lumberjack.Logger{
			Filename:   logfile,
			MaxSize:    500,
			MaxAge:     1,
			MaxBackups: 5,
			LocalTime:  true,
			Compress:   true,
		}
	}

}
