/*
 * @Descripttion:
 * @Author: Zhang YaSong
 * @version:
 * @Date: 2022-03-22 15:50:26
 * @LastEditors: Zhang YaSong
 * @LastEditTime: 2022-03-22 15:52:03
 */
package model

import "time"

type ProxyData struct {
	ApplyId          int64     `json:"apply_id"`
	ReqUrl           string    `json:"req_url"`
	RequestCount     int64     `json:"request_count"`
	Duration         int64     `json:"duration"`
	DurationUnit     int64     `json:"duration_unit"`
	SpcsType         int       `json:"spcs_type"`
	SpcsCount        int64     `json:"spcs_count"`
	ResFields        string    `json:"res_fields"`
	DataServiceType1 int64     `json:"data_service_type1"`
	DataServiceType2 int64     `json:"data_service_type2"`
	DataServiceType3 int64     `json:"data_service_type3"`
	SecondLevel      int64     `json:"second_level"`
	ServiceEndTime   time.Time `json:"service_end_time"`
	ReqName          string    `json:"req_name"`
	ServiceState     int64     `json:"service_state"`
	PayStatus        int64     `json:"pay_status"`
	ApplyUserId      string    `json:"apply_user_id"`
	ServiceUserId    string    `json:"service_user_id"`
	ServiceOid       string    `json:"service_oid"`
	ApplyOid         string    `json:"apply_oid"`
	SensituveWord    string    `json:"sensituve_word"`
	SensitiveCount   int64     `json:"sensitive_count"`
	ServiceId        int64     `json:"service_id"`
	ApiId            int64     `json:"api_id"`             //接口ID
	RequestStartTime string    `json:"request_start_time"` // 申请使用开始时间
	RequestEndTime   string    `json:"request_end_time"`   // 申请使用结束时间
	ApaasToken       string    `json:"apaas_token"`        // apaas校验token
	ReqAuthMthod     int64     `json:"req_auth_mthod"`     // 0 注册的服务无鉴权，1 注册的服务通过静态token鉴权 2 注册的服务通过动态token鉴权
	ReqAuthToken     string    `json:"req_auth_token"`
	ReqAuthTokenName string    `json:"req_auth_token_name"`
}

type WebRes struct {
	Success int         `json:"success"`
	ErrMsg  string      `json:"errMsg,omitempty"`
	Data    interface{} `json:"data,omitempty"`
}
