package dataconvertutil

import (
	"encoding/json"

	"gitlab.wodcloud.com/apaas-v3/apaas-meshproxy/src/logger"
	"gitlab.wodcloud.com/apaas-v3/apaas-meshproxy/src/model/request"
	"gitlab.wodcloud.com/apaas-v3/apaas-meshproxy/src/tools"
)

//字段结构 转json
func ConvertJson(fields []request.ServiceField) (map[string]interface{}, []interface{}) {
	m := map[string]interface{}{}
	var n []interface{}
	if fields == nil {
		return m, n
	}
	for _, field := range fields {
		if field.Selected == 1 && (field.Type == "object" || field.Type == "array") {
			mm, nn := ConvertJson(field.Children)
			if field.Name == "" {
				if len(nn) != 0 {
					n = append(n, nn)
				} else {
					n = append(n, mm)
				}
			} else {
				if len(nn) != 0 {
					m[field.Name] = nn
				} else {
					m[field.Name] = mm
				}
			}
		} else if field.Selected == 1 && (field.Type == "string" || field.Type == "file" || field.Type == "text") {
			if field.Name == "" {
				n = append(n, field.Example)
			} else {
				m[field.Name] = field.Example
			}
		} else if field.Selected == 1 && field.Type == "int" {
			if field.Name == "" {
				n = append(n, field.Example)
			} else {
				m[field.Name] = tools.ParseInt(field.Example, 0)
			}
		} else if field.Selected == 1 && field.Type == "float" {
			if field.Name == "" {
				n = append(n, field.Example)
			} else {
				m[field.Name] = tools.ParseFloat64(field.Example, 0.0)
			}
		} else if field.Selected == 1 && field.Type == "bool" {
			if field.Name == "" {
				n = append(n, field.Example)
			} else {
				m[field.Name] = true
			}
		}
	}
	return m, n
}

//字段结构 转json
func ConvertJsonAll(fields []request.ServiceField) (map[string]interface{}, []interface{}) {
	m := map[string]interface{}{}
	var n []interface{}
	if fields == nil {
		return m, n
	}
	for _, field := range fields {
		if field.Type == "object" || field.Type == "array" {
			mm, nn := ConvertJsonAll(field.Children)
			if field.Name == "" {
				if len(nn) != 0 {
					n = append(n, nn)
				} else {
					n = append(n, mm)
				}
			} else {
				if len(nn) != 0 {
					m[field.Name] = nn
				} else {
					m[field.Name] = mm
				}
			}
		} else if field.Type == "string" || field.Type == "file" || field.Type == "text" {
			if field.Name == "" {
				n = append(n, field.Example)
			} else {
				m[field.Name] = field.Example
			}
		} else if field.Type == "int" {
			if field.Name == "" {
				n = append(n, field.Example)
			} else {
				m[field.Name] = tools.ParseInt(field.Example, 0)
			}
		} else if field.Type == "float" {
			if field.Name == "" {
				n = append(n, field.Example)
			} else {
				m[field.Name] = tools.ParseFloat64(field.Example, 0.0)
			}
		} else if field.Type == "bool" {
			if field.Name == "" {
				n = append(n, field.Example)
			} else {
				m[field.Name] = true
			}
		}
	}

	return m, n
}

func GetResponseField(jsonstr string) []request.ServiceField {
	var res []request.ServiceField
	if err := json.Unmarshal([]byte(jsonstr), &res); err != nil {
		logger.Logger.Fatal(err)
	}
	return res
}
