package dao

import (
	"time"
)

type ServiceRequestRecord struct {
	Id          int64     `json:"id" xorm:"pk default nextval('service_request_record_id_pk'::regclass) autoincr BIGINT"`
	ServiceId   int64     `json:"service_id" xorm:"BIGINT"`
	ApplyId     int64     `json:"apply_id" xorm:"BIGINT"`
	UserId      string    `json:"user_id" xorm:"VARCHAR(50)"`
	RequestTime time.Time `json:"request_time" xorm:"DATETIME"`
	DateDay     int       `json:"date_day" xorm:"SMALLINT"`
	DateMonth   int       `json:"date_month" xorm:"SMALLINT"`
	DateYear    int       `json:"date_year" xorm:"SMALLINT"`
	Status      int       `json:"status" xorm:"SMALLINT"`
	Error       string    `json:"error" xorm:"TEXT"`
	ReqUrl      string    `json:"req_url" xorm:"VARCHAR"`
	ApiId       int64     `json:"api_id" xorm:"BIGINT"`
	ApplyOid    string    `json:"apply_oid" xorm:"VARCHAR"`
	ServiceOid  string    `json:"service_oid" xorm:"VARCHAR"`
}

func (s ServiceRequestRecord) TableName() string {
	return "service_request_record"
}
