package request

//服务字段
type ServiceField struct {
	Name string `json:"name" vd:"regexp('^\\w*$');msg:'字段编码格式错误'"`
	// string 字符串  object 对象  int 整数  float 浮点数 array 数组 boolean 布尔型 file 文件二进制类型
	Type        string         `json:"field_type" vd:"($=='file' || $=='string'||$=='object'||$=='int'||$=='float'||$=='array'||$=='boolean');msg:sprintf('%s字段类型有误%s',(Name)$,$)"`
	ShowType    string         `json:"show_type"`
	Label       string         `json:"label" vd:"len($)>0 ||   (Name)$ ==''  ;msg:sprintf('%s的字段名称未填写',(Name)$)"`
	Descript    string         `json:"descript"`     //vd:"len($)>0;msg:sprintf('%s的字段说明未填写',(Name)$)"
	IsSensituve int            `json:"is_sensituve"` //是否为敏感字段
	Selected    int            `json:"selected"`     //是否勾选
	Example     string         `json:"example"`      //示例值
	IsMust      int            `json:"is_must"`      //是否必须
	Children    []ServiceField `json:"children"`
}
