/*
@Time : 2020/4/23 17:44
@Author : gaoshiyao
@File : field
@Software: GoLand
@Des:
*/
package service

import (
	"errors"
	"fmt"
	"log"
	"time"

	"github.com/spf13/cast"
	"gitlab.wodcloud.com/apaas-v3/apaas-meshproxy/src/client"
	"gitlab.wodcloud.com/apaas-v3/apaas-meshproxy/src/config"
	"gitlab.wodcloud.com/apaas-v3/apaas-meshproxy/src/dao"
	"gitlab.wodcloud.com/apaas-v3/apaas-meshproxy/src/model"
	"gitlab.wodcloud.com/apaas-v3/apaas-meshproxy/src/model/request"
	"gitlab.wodcloud.com/apaas-v3/apaas-meshproxy/src/model/tables"
	"gitlab.wodcloud.com/apaas-v3/apaas-meshproxy/src/tools/dataconvertutil"
)

// 判断是否设置了敏感字段，并有敏感词
func CheckSensitiveField() bool {
	return true
}

//检测是否达到了访问量
func QueryCallsCount(filter model.ProxyData) (bool, bool, error) {
	// 计次的
	if filter.SpcsType == 1 {
		if filter.SpcsCount <= filter.RequestCount {
			return true, false, nil
		}
	}
	return false, false, nil
	////连接redis
	//redis, err := client.GetRedisClient()
	//if err != nil {
	//	return
	//}
	//date := time.Now().Format(config.LocalDateFormat)
	//key := fmt.Sprintf("%d-%s", filter.ApplyId, date)
	//countStr, err := redis.Get(key)
	//if err != nil && err.Error() != `redis: nil` {
	//	return
	//}
	//var count int64
	//call = true
	//sensitiveCall = true
	//if countStr == "" {
	//	expire := GetExpire()
	//	err = redis.Set(key, 1, expire)
	//	count = 1
	//} else {
	//	count, err = strconv.ParseInt(countStr, 10, 64)
	//	if err != nil {
	//		return
	//	}
	//	if count+1 > filter.RequestCount {
	//		call = false
	//		return
	//	}
	//	//超过允许访问敏感字段次数
	//	if count+1 > filter.SensitiveCount && filter.SensituveWord != "" {
	//		sensitiveCall = false
	//	}
	//	expire := GetExpire()
	//	err = redis.Set(key, count+1, expire)
	//}
	//return
}

//获取过期时间
func GetExpire() time.Duration {
	now := time.Now()
	timeStr := time.Now().AddDate(0, 0, 1).Format("2006-01-02")
	fmt.Println("timeStr:", timeStr)
	zero, _ := time.Parse("2006-01-02", timeStr)
	timeNumber := zero
	fmt.Println("timeNumber:", timeNumber)
	subMin := now.Sub(zero)
	//fmt.Println(subMin.Minutes(), "分钟")
	return subMin
}

//记录调用痕迹
func RecordCall(proxyData model.ProxyData, status int, res []byte) {

	db, err := client.GetConnect()
	if err != nil {
		fmt.Println(err.Error())
		return
	}
	acc := dao.ServiceRequestRecord{
		Id:          0,
		ServiceId:   proxyData.ServiceId,
		ApplyId:     proxyData.ApplyId,
		UserId:      proxyData.ApplyUserId,
		RequestTime: time.Now(),
		DateDay:     time.Now().Day(),
		DateMonth:   int(time.Now().Month()),
		DateYear:    time.Now().Year(),
		Status:      status,
		Error:       "",
		ReqUrl:      proxyData.ReqUrl,
		ApiId:       proxyData.ApiId,
		ApplyOid:    proxyData.ApplyOid,
		ServiceOid:  proxyData.ServiceOid,
	}
	//错误信息
	if status != 200 {
		acc.Error = string(res)
	}

	if _, err = db.Insert(&acc); err != nil {
		fmt.Println(err)
	}

	//b, _ := json.Marshal(acc)
	//if errs := redis.Conn.RPush(config.CallRecord, b).Err(); errs != nil {
	//	err = errs
	//	fmt.Println("rpush data to list failed:", errs.Error())
	//	return
	//}
	//fmt.Println("调用记录进入队列")
	return
}

//服务调用计次
//func CallCounts(proxyData model.ProxyData) (err error) {
//	redis, err := client.GetRedisClient()
//	if err != nil {
//		fmt.Println(err.Error())
//		return
//	}
//	date := time.Now().Format(config.LocalDateFormat)
//	aMonBefore := time.Now().AddDate(0, -1, 0).Format(config.LocalDateFormat)
//
//	str, err := redis.Get(fmt.Sprintf("%s-%d", config.SvcTag, proxyData.Service_id))
//	if err != nil && err.Error() != `redis: nil` {
//		return
//	}
//
//	dateMap := make(map[string]int)
//	if str != "" {
//		err = json.Unmarshal([]byte(str), &dateMap)
//		if err != nil {
//			return
//		}
//		if _, ok := dateMap[date]; ok {
//			dateMap[date] = dateMap[date] + 1
//		} else {
//			dateMap[date] = 1
//		}
//		for k, _ := range dateMap {
//			if tools.CompareDate(k, aMonBefore) {
//				delete(dateMap, k)
//			}
//		}
//
//	} else {
//		dateMap[date] = 1
//	}
//	content, err := json.Marshal(dateMap)
//	err = redis.Set(fmt.Sprintf("%s-%d", config.SvcTag, proxyData.Service_id), content, -1)
//	return
//}
//服务调用计次
//服务调用计次
func CallCounts(proxyData model.ProxyData) (err error) {
	//redis, err := client.GetRedisClient()
	//if err != nil {
	//	fmt.Println(err.Error())
	//	return
	//}
	//str, err := redis.Get(fmt.Sprintf("%s", config.ServiceTag))
	//if err != nil && err.Error() != `redis: nil` {
	//	return
	//}
	//dateMap := make(map[int]int)
	//if str != "" {
	//	err = json.Unmarshal([]byte(str), &dateMap)
	//	if err != nil {
	//		return
	//	}
	//	if _, ok := dateMap[proxyData.Service_id]; ok {
	//		dateMap[proxyData.Service_id] = dateMap[proxyData.Service_id] + 1
	//	} else {
	//		dateMap[proxyData.Service_id] = 1
	//	}
	//} else {
	//	dateMap[proxyData.Service_id] = 1
	//}
	//content, err := json.Marshal(dateMap)
	//err = redis.Set(fmt.Sprintf("%s", config.ServiceTag), content, -1)
	db, err := client.GetConnect()
	if err != nil {
		return
	}
	date := time.Now().Format(config.LocalDateFormat)
	session := db.NewSession()
	session.Begin()
	if proxyData.ApiId == 0 {
		sql1 := fmt.Sprintf(`
LOCK TABLE service IN SHARE ROW EXCLUSIVE MODE;
	update service set  request_count =request_count+1,req_count =req_count+1 where id = %d;
	update service_apply set  request_count =request_count+1 where id =  %d;
 `, proxyData.ServiceId, proxyData.ApplyId)
		_, err = session.SQL(sql1).Execute()
		if err != nil {
			fmt.Println("error******service、service_apply更新失败：" + err.Error())
			return
		}
	} else {
		sql1 := fmt.Sprintf(`
LOCK TABLE service IN SHARE ROW EXCLUSIVE MODE;
	update service set  request_count =request_count+1 where id = %d;
	update service_req_extend set req_count =req_count+1 where id = %d;
	update service_apply set  request_count =request_count+1 where id =  %d;
 `, proxyData.ServiceId, proxyData.ApiId, proxyData.ApplyId)
		_, err = session.SQL(sql1).Execute()
		if err != nil {
			fmt.Println("error******service、service_apply更新失败：" + err.Error())
			return
		}
	}
	session.Commit()

	session.Begin()
	sql := fmt.Sprintf(`
LOCK TABLE service_daliy_count IN SHARE ROW EXCLUSIVE MODE;
INSERT INTO service_daliy_count ( service_id,date,count) VALUES
(%d,'%s',%d) ON conflict (service_id,date) DO
UPDATE SET count=(service_daliy_count.count+1); 
`, proxyData.ServiceId, date, 1)
	_, err = session.SQL(sql).Execute()
	if err != nil {
		fmt.Println("error******service_daliy_count更新失败：" + err.Error())
		session.Rollback()
		return
	}
	session.Commit()
	session.Begin()
	sql3 := fmt.Sprintf(`
LOCK TABLE service_count_person IN SHARE ROW EXCLUSIVE MODE;
INSERT INTO service_count_person ( user_id,date,count) VALUES
('%s','%s',%d) ON conflict (user_id,date) DO
UPDATE SET count=(service_count_person.count+1); 
`, proxyData.ApplyUserId, date, 1)
	_, err = session.SQL(sql3).Execute()
	if err != nil {
		fmt.Println("error****** service_count_person 更新失败：" + err.Error())
		session.Rollback()
		return
	}
	session.Commit()
	fmt.Println("CallCounts执行完成@@@！！！！！")
	//查询service_daliy_count 表有更新没有插入
	return
}

/*
申请调用记录
*/
func ApplyCallCounts(proxyData model.ProxyData) (err error) {
	redis, err := client.GetRedisClient()
	if err != nil {
		fmt.Println(err.Error())
		return
	}
	//date := time.Now().Format(config.LocalDateTimeFormat)
	err = redis.RPush(fmt.Sprintf("%s", config.ApplyTag), proxyData.ApplyId)
	fmt.Println("rpush data to list failed:", err)
	return
}

//过滤返回字段
func FiledFilter(proxyData model.ProxyData, respbody []byte) []byte {
	return respbody

	//var fields []request.ServiceField
	//fields = dataconvertutil.GetResponseField(proxyData.ResFields)
	//_, arrmodel := dataconvertutil.ConvertJson(fields)
	//realData := make(map[string]interface{})
	//if err := json.Unmarshal(respbody, &realData); err != nil {
	//	return respbody
	//}
	//if arrmodel != nil && len(arrmodel) != 0 && len(realData) != 0 {
	//	bytes, _ := json.Marshal(Change(arrmodel[0], realData))
	//	return bytes
	//}
	//return respbody
}

//返回申请字段
func Change(model interface{}, returnData interface{}) interface{} {
	//switch t := model.(type) {
	switch model.(type) {
	case map[string]interface{}:
		//  判定值是否相等
		for k, v := range returnData.(map[string]interface{}) {
			flag := false
			for k1, v1 := range model.(map[string]interface{}) {
				if k == k1 {
					flag = true
					//Change(v, v1)
					Change(v1, v)
				}
			}
			// 删除属性
			if !flag {
				fmt.Println("删除属性：", k)
				delete(returnData.(map[string]interface{}), k)
			}
		}
		break
	case []interface{}:
		for k, v := range returnData.([]interface{}) {
			switch v.(type) {
			case map[string]interface{}:
				for _, a2 := range model.([]interface{}) {
					for k1, v1 := range v.(map[string]interface{}) {
						flag := false
						for k2, v2 := range a2.(map[string]interface{}) {
							if k1 == k2 {
								flag = true
								//Change(v1, v2)
								Change(v2, v1)
							}
						}
						// 删除属性
						if !flag {
							fmt.Println("删除属性：", k)
							delete(v.(map[string]interface{}), k1)
						}
					}
				}
				break
			case []interface{}:
				for _, v2 := range model.([]interface{}) {
					fmt.Println(v2)
					//Change(v2, v)
					Change(v, v2)
				}
				break
			default:
				//  判断old是否有这个值
				//fmt.Println("数组类型 |||||||||||||||||||||||||||||||| old=====new=====>: ", model, returnData)
			}
		}
		break
	default:
		//fmt.Println("old=====new=====>: ", model, returnData)
		//fmt.Println("类型是*******>：", t)
	}
	return returnData
}

//更新调用次数
func UpdateCallsCount(applyId string) (err error) {
	db, err := client.GetConnect()
	if err != nil {
		return
	}
	sql := `update service_apply set request_count = request_count+1  where service_apply.service_id = '?'`
	db.SQL(sql, applyId)

	return
}

//返回过滤后的敏感字段
func SensitiveFilter(proxyData model.ProxyData, res interface{}) interface{} {
	var fields []request.ServiceField
	fields = dataconvertutil.GetResponseField(proxyData.SensituveWord)
	_, arrsensituveWord := dataconvertutil.ConvertJson(fields)
	//if Sensituve_word != nil && len(Sensituve_word) != 0 {
	//	return FilterSensituveField(Sensituve_word, res)
	//} else if arrSensituve_word != nil && len(arrSensituve_word) != 0 {
	//	return FilterSensituveField(arrSensituve_word, res)
	//}
	if arrsensituveWord != nil && len(arrsensituveWord) != 0 {
		return Change(arrsensituveWord[0], res)
	}
	return res
}

// 过滤敏感字段
func FilterSensituveField(model interface{}, returnData interface{}) (body interface{}) {
	//switch t := model.(type) {
	switch model.(type) {
	case map[string]interface{}:
		//   判定值是否相等
		for k, v := range returnData.(map[string]interface{}) {
			//flag := false
			for k1, v1 := range model.(map[string]interface{}) {
				if k == k1 {
					//flag = true
					switch v.(type) {
					case float64:
						returnData.(map[string]interface{})[k] = `xxx`
					case float32:
						returnData.(map[string]interface{})[k] = `xxx`
					case int:
						returnData.(map[string]interface{})[k] = `xxx`
					case bool:
						returnData.(map[string]interface{})[k] = `xxx`
					case string:
						returnData.(map[string]interface{})[k] = `xxx`
					default:

					}
					FilterSensituveField(v, v1)
				}
			}
		}
		break
	case []interface{}:
		for _, v := range returnData.([]interface{}) {
			switch v.(type) {
			case map[string]interface{}:
				for _, a2 := range model.([]interface{}) {
					for k1, v1 := range v.(map[string]interface{}) {
						//flag := false
						for k2, v2 := range a2.(map[string]interface{}) {
							if k1 == k2 {
								//flag = true
								switch v.(map[string]interface{})[k1].(type) {
								case string:
									v.(map[string]interface{})[k1] = `xxx`
								case float64:
									v.(map[string]interface{})[k1] = `xxx`
								case float32:
									v.(map[string]interface{})[k1] = `xxx`
								case int:
									v.(map[string]interface{})[k1] = `xxx`
								case bool:
									v.(map[string]interface{})[k1] = `xxx`
								default:
								}
								FilterSensituveField(v1, v2)
							}
						}
					}
				}
				break
			case []interface{}:
				for _, v2 := range model.([]interface{}) {
					fmt.Println(v2)
					FilterSensituveField(v2, v)
				}
				break
			default:
				// TODO 判断old是否有这个值
				//fmt.Println("数组类型 |||||||||||||||||||||||||||||||| old=====new=====>: ", model, returnData)
			}
		}
		break
	default:
		//fmt.Println("old=====new=====>: ", model, returnData)
		//fmt.Println("类型是*******>：", t)
	}
	return returnData
}

// 获取真实地址和返回结构、调用限定次数
func GetRealPath(applyId, apiId string) (model.ProxyData, error) {
	db, err := client.GetConnect()
	if err != nil {
		return model.ProxyData{}, err
	}
	var res model.ProxyData
	apiid := cast.ToInt64(apiId)
	if apiid == 0 {
		has, err := db.NewSession().Select("ssc.sensituve_word,sa.service_id,sa.id as apply_id, s.req_url,sa.request_count,sa.duration,sa.duration_unit,sa.spcs_type,sa.spcs_count,sa.res_fields,s.data_service_type1,s.data_service_type2 ,s.data_service_type3,sa.second_level,sa.service_end_time,s.req_name,s.state as service_state,sa.pay_status,sa.user_id as apply_user_id,s.user_id  as service_user_id,s.organization as service_oid,sa.apply_oid,sa.request_start_time,sa.request_end_time").
			Table("service_apply").Alias("sa").Join("inner", []string{"service", "s"}, "sa.service_id=s.id").Join("left", []string{"service_safe_config", "ssc"}, "ssc.service_id=sa.service_id").Where("s.is_deleted =0 and sa.is_deleted =0  and s.state in(1,3) and sa.uuid=?", applyId).Get(&res)
		if err != nil {
			log.Println(err)
			return model.ProxyData{}, errors.New(`未找到发布的服务！`)
		} else if !has {
			return model.ProxyData{}, errors.New(`未找到发布的服务！`)
		}
	} else {
		has, err := db.NewSession().Select("ssc.sensituve_word,sre.id as api_id,sa.service_id,sa.id as apply_id,sre.req_url,sa.request_count,sa.duration,sa.duration_unit,sa.spcs_type,sa.spcs_count,sa.res_fields,s.data_service_type1,s.data_service_type2 ,s.data_service_type3,sa.second_level,sa.service_end_time,sre.req_name,s.state as service_state,sa.pay_status,sa.user_id as apply_user_id,s.user_id  as service_user_id,s.organization as service_oid,sa.apply_oid,sa.request_start_time,sa.request_end_time").
			Table("service_apply").Alias("sa").Join("inner", []string{"service", "s"}, "sa.service_id=s.id").Join("inner", []string{"service_req_extend", "sre"}, "sre.service_id = sa.service_id and sre.id =?", apiid).Join("left", []string{"service_safe_config", "ssc"}, "ssc.service_id=sa.service_id").Where("s.is_deleted =0 and sa.is_deleted =0  and s.state in(1,3) and sa.uuid=?", applyId).Get(&res)
		if err != nil {
			log.Println(err)
			return model.ProxyData{}, errors.New(`未找到发布的服务！`)
		} else if !has {
			return model.ProxyData{}, errors.New(`未找到发布的服务！`)
		}
	}
	return res, nil
}

// 获取真实地址
func GetReqPath(apiId string) (tables.Service, error) {
	db, err := client.GetConnect()
	if err != nil {
		return tables.Service{}, err
	}
	res := tables.Service{}

	apiid := cast.ToInt64(apiId)
	if apiid == 0 {
		if has, err := db.ID(config.MeshId).Get(&res); err != nil {
			return tables.Service{}, err
		} else if !has {
			return tables.Service{}, errors.New("服务不存在")
		}
	} else {
		if has, err := db.NewSession().Where("service_id=? and id=?", config.MeshId, apiid).Table("service_req_extend").Get(&res); err != nil {
			return tables.Service{}, err
		} else if !has {
			return tables.Service{}, errors.New("服务不存在")
		}
	}

	return res, nil
}
