package tools

import (
	"errors"
	"fmt"
	"io/ioutil"
	"net"
	"net/http"
	"strings"
)

//ProxySend , http请求
func ProxySend(incomingReq *http.Request, sendType string, url string, body string, header map[string]string) (result []byte, err error) {
	client := &http.Client{}
	var outgoingReq *http.Request
	if len(body) > 0 {
		outgoingReq, err = http.NewRequest(sendType, url, strings.NewReader(body))
		if err != nil {
			fmt.Println(err)
		}
	} else {
		outgoingReq, _ = http.NewRequest(sendType, url, nil)
	}
	if header == nil {
		header = make(map[string]string)
	}
	if incomingReq != nil {
		b3Headers := getForwardHeaders(incomingReq)
		for k, v := range b3Headers {
			header[k] = v
		}
	}
	for k, v := range header {
		outgoingReq.Header.Set(k, v)
	}
	resp, err := client.Do(outgoingReq)
	if err != nil {
		return nil, err
	} else {
		defer resp.Body.Close()
		body, erra := ioutil.ReadAll(resp.Body)
		return body, erra
	}
}

//ProxySend , http请求
func ProxySendRes(incomingReq *http.Request, sendType string, url string, body string, header map[string]string) (result *http.Response, err error) {
	client := &http.Client{}
	var outgoingReq *http.Request
	if len(body) > 0 {
		outgoingReq, err = http.NewRequest(sendType, url, strings.NewReader(body))
		if err != nil {
			fmt.Println(err)
		}
	} else {
		outgoingReq, _ = http.NewRequest(sendType, url, nil)
	}
	if header == nil {
		header = make(map[string]string)
	}
	if incomingReq != nil {
		b3Headers := getForwardHeaders(incomingReq)
		for k, v := range b3Headers {
			header[k] = v
		}
	}
	for k, v := range header {
		outgoingReq.Header.Set(k, v)
	}
	resp, err := client.Do(outgoingReq)
	return resp, err
}

//GetCookieStr , 获取cookie字符串
func GetCookieStr(req *http.Request) (str string, err error) {
	cookies := req.Cookies()
	_, err = req.Cookie("awetoken")
	if err != nil {
		err = errors.New("用户未登录")
		return "", err
	} else {
		for _, v := range cookies {
			str += v.Name + "=" + v.Value + ";"
		}
		return str, nil
	}
}

func getForwardHeaders(incomingReq *http.Request) map[string]string {
	headers := make(map[string]string)
	xRequestID := incomingReq.Header.Get("x-request-id")
	if len(xRequestID) > 0 {
		headers["x-request-id"] = incomingReq.Header.Get("x-request-id")
		headers["x-b3-traceid"] = incomingReq.Header.Get("x-b3-traceid")
		headers["x-b3-spanid"] = incomingReq.Header.Get("x-b3-spanid")
		if len(incomingReq.Header.Get("x-b3-parentspanid")) > 0 {
			headers["x-b3-parentspanid"] = incomingReq.Header.Get("x-b3-parentspanid")
		}
		headers["x-b3-sampled"] = incomingReq.Header.Get("x-b3-sampled")
		if len(incomingReq.Header.Get("x-b3-flags")) > 0 {
			headers["x-b3-flags"] = incomingReq.Header.Get("x-b3-flags")
		}
		if len(incomingReq.Header.Get("x-ot-span-context")) > 0 {
			headers["x-ot-span-context"] = incomingReq.Header.Get("x-ot-span-context")
		}
	}
	return headers
}

//获取ip地址
func RemoteIp(req *http.Request) string {
	remoteAddr := req.RemoteAddr
	if ip := req.Header.Get("X-Real-Ip"); ip != "" {
		remoteAddr = ip
	} else if ip = req.Header.Get("X-Forwarded-For"); ip != "" {
		remoteAddr = ip
	} else {
		remoteAddr, _, _ = net.SplitHostPort(remoteAddr)
	}

	if remoteAddr == "::1" {
		remoteAddr = "127.0.0.1"
	}
	return remoteAddr
}

//获取mac地址
func GetMac() (macAddrs string) {
	netInterfaces, err := net.Interfaces()
	if err != nil {
		fmt.Printf("fail to get net interfaces: %v", err)
		return macAddrs
	}
	for _, netInterface := range netInterfaces {
		macAddr := netInterface.HardwareAddr.String()
		if len(macAddr) == 0 {
			continue
		}
		macAddrs += macAddr + ";"
	}
	rs := []rune(macAddrs)
	macAddrs = string(rs[:len(rs)-1])
	return macAddrs
}
