package client

import (
	"fmt"
	"time"

	_ "github.com/go-sql-driver/mysql"
	_ "github.com/lib/pq"
	"github.com/sirupsen/logrus"
	"github.com/xormplus/core"
	"github.com/xormplus/xorm"
	"gitlab.wodcloud.com/apaas-v3/apaas-meshproxy/src/config"
)

var DB *xorm.Engine

func GetConnect() (xormDB *xorm.Engine, err error) {
	//if DB != nil && DB.Ping() == nil {
	if DB != nil {
		return DB, nil
	}
	xormDB, err = xorm.NewEngine(config.DriverName, config.DbURL)
	if err != nil {
		logrus.Errorf("error creating db instance to %s: %s", config.DbURL, err)
		return nil, err
	}
	if err = xormDB.Ping(); err != nil {
		logrus.Errorf("error creating db connection to %s: %s", config.DbURL, err)
		return nil, err
	}
	xormDB.SetMapper(core.SnakeMapper{})
	xormDB.ShowSQL(true)
	DB = xormDB
	DB.TZLocation, _ = time.LoadLocation("Asia/Shanghai")
	fmt.Println("connect Db success!")
	return xormDB, err
}
