package main

import (
	"fmt"
	"net/http"
	"os"
	"time"

	"github.com/sirupsen/logrus"
	"gitlab.wodcloud.com/apaas/apaas-meshproxy/src/router"

	"gitlab.wodcloud.com/apaas/apaas-meshproxy/src/config"

	"github.com/gin-gonic/contrib/ginrus"
	"github.com/spf13/pflag"
)

var (
	argPort      = pflag.Int("port", 8011, "")
	argPrefix    = pflag.String("prefix", "/bgmesh/fiddler", "")
	meshId       = pflag.String("meshId", "149", "")
	redisUrl     = pflag.String("redisUrl", "redis://apaas-redis.apaas-v3:6379", "")
	redisTag     = pflag.String("redisTag", "apaas-mesh-proxy", "")
	confPath     = pflag.String("confPath", "/app/config/proxy.json", "")
	dbURL        = pflag.String("dbURL", "host=apaas-postgis.apaas-v3 port=5432 user=postgres password=passwd123 dbname=apaas sslmode=disable", "")
	dbDriverName = pflag.String("dbDriverName", "postgres", "")
)

func main() {
	pflag.Parse()
	initEnv()
	initConfig()
	server()
}

func server() error {
	config.Prefix = *argPrefix
	handler := router.Load(ginrus.Ginrus(logrus.StandardLogger(), time.RFC3339, true))
	fmt.Println(fmt.Sprintf(":%d", *argPort))
	return http.ListenAndServe(
		fmt.Sprintf(":%d", *argPort),
		handler,
	)
}

//注册环境变量
func initEnv() {
	if len(os.Getenv("REDIS_CONNECTION")) > 0 {
		*redisUrl = os.Getenv("REDIS_CONNECTION")
	}
}

//注册公共config参数信息
func initConfig() {
	config.RedisTag = *redisTag
	config.RedisURL = *redisUrl
	config.MeshId = *meshId
	config.Prefix = *argPrefix
	config.DriverName = *dbDriverName
	config.DbURL = *dbURL
}
