import axios from '@/request/http'; // 导入http中创建的axios实例
import qs from 'qs'; // 根据需求是否导入qs模块

const user = {
    // order
    orderList(params) {
        return axios.get(`/apaas/serviceapp/v3/order/list?serviceName=${params.select}&orderStatus=${params.status}&serviceTypes=${params.types.join(',')}&Page=${params.page}&Size=${params.limit}`);
    },

    // user info
    getNowUser() {
        return axios.get(`/apaas/backmgt/user/getCurrentUser`);
    },
    getUserDetail(params) {
        return axios.get(`/apaas/backmgt/user/detail/${params.id}`);
    },
    editUserPassword(params) {
        return axios.post(`/apaas/backmgt/user/password/${params.id}`, params.form);
    },
}

export default user;
