import axios from '@/request/http'; // 导入http中创建的axios实例
import qs from 'qs'; // 根据需求是否导入qs模块

const workbench = {
    fwzcFwcs(params) {
        return axios.post(`/apaas/service/v3/service/manager/test`, params);
    },
    serviceAdd(params) {
        return axios.post(`/apaas/service/v3/service/manager`, params)
    },

    // service area
    getServiceAreaList() {
        return axios.get(`/apaas/service/v3/service/manager/servarea`)
    },

    // service type
    getServiceTypeList() {
        return axios.get(`/apaas/service/v3/service/manager/servtype`)
    },

    // get application introduction
    getAppIntroduction(params) {
        return axios.get(`/apaas/hubApi/market/app/detail/${params.app_id}?deploy_id=${params.deploy_id}`)
    },
    // get application params
    getAppParams(params) {
        return axios.get(`/apaas/hubApi/market/values/${params.app_id}`)
    },

    // get cloud resources details
    getCloudDetail(params) {
        return axios.get(`/apaas/service/v3/resource/user/apply/approvedDetail?type=${params.type}&id=${params.id}&applyid=${params.applyId}`)
    },
    // cloud resource approval
    setCloudApproval(params) {
        return axios.put(`/apaas/service/v3/resource/apply/approve?apply_id=${params.applyId}&apply_state=${params.applyState}&apply_type=${params.applyType}&cloud_id=${params.applyCloudId}&namespace=${params.namespace}`)
    },
    // cloud resource allocation
    setCloudAllocation(params) {
        return axios.put(`/apaas/service/v3/resource/apply/distribution?id=${params.id}&user_id=${params.userId}`)
    },
    // cloud resource delete
    deleteCloud(params) {
        return axios.delete(`/apaas/service/v3/resource/apply/remove?id=${params.id}&namespace=${params.namespace}&use_uid=${params.useUid}`)
    },
    // cloud resource disabled
    disabledCloud(params) {
        return axios.put(`/apaas/service/v3/resource/apply/disable?id=${params.id}&type=${params.type}`)
    },
    // get cloud's application
    getCloudApplication(params) {
        return axios.get(`/apaas/hubApi/market/deployList?page=1&limit=10000&namespaces=${params.namespace}`)
    },

    // get service topology
    getServiceTopology() {
        return axios.get(`/apaas/istio/v3/api/namespaces/graph`)
    },

    // add process
    addProcess(params) {
        return axios.post(`/apaas/serviceapp/v3/workflows/add`, params)
    },
    // edit process
    editProcess(params) {
        return axios.post(`/apaas/serviceapp/v3/workflows/update`, params)
    },
    // get process detail
    getProcessDetail(params) {
        return axios.get(`/apaas/serviceapp/v3/workflows/detail?id=${params.id}`)
    },
    // get process namespace list
    getProcessNamespaceList() {
        return axios.get(`/apaas/serviceapp/v3/workflows/searchConditions`)
    },
    // get process service list
    getProcessServiceList() {
        return axios.get(`/apaas/serviceapp/v3/workflows/wfServices`)
    },
    // release process service
    releaseProcess(params) {
        return axios.post(`/apaas/serviceapp/v3/workflows/publish`, params)
    },

    // get service running topology
    getServiceRunningTopology(params) {
        return axios.get(`/apaas/istio/service/apaas-proxy/overview/${params.namespace}`)
    },
}

export default workbench;
