var store = {
  install: function(Vuex) {
    store.namespace = new Vuex.Store({
      state: {
        userInfo: null, // 用户信息
        ssType: "全部",
        ssPrams: {
          firstId: "", // int 一级分类 0全部
          secondId: "", // int 二级分类 0全部
          type: 0, // int 0 附近 1评价
          search: "", // string 按名称搜索
          fifteen: 0
        }, // 设施列表参数 for ssHeader组件
        name: "",
        //进行相关操作和请求接口时，调用函数同步更改，页面的初始化使用state里面的值进行绑定
        selectedFacility: {
          //选中的poi，点击地图上的点或者在列表中选中时更新状态
          name: "", //poi的名称
          id: "", //poi的id
          distance: "", //poi离用户的距离
          evaluation: "", //poi的评分
          evaluation_num: "", //poi的评价次数
          address: "", //poi的详细地址
          discribe: "", //poi的描述信息
          lat: "", //poi的经纬度
          lng: "",
          type: "" ,//poi的类型
          detail_type: "" ,//poi的类型
          tertiary_type:[]//停车场的具体类型，地下1，地面2，路边3
        },
        // selectID:"",
        // selectTag: "",
        currentPosition: {
          lng: 112.546184,
          lat: 28.281588
        },
        mapState: "showAll", //"showAll","showSelectTag","showSelectedFacility",
        isPullUp: false//是否上拉，为true时，地图的浮窗将会隐藏
      },
      mutations: {
        updateSstype(state, payload) {
          state.ssType = payload;
        },
        upDateSsParams(state, payload) {
          Object.assign(state.ssPrams, payload);
        },
        change(state, name) {
          state.name = name;
          sessionStorage.setItem("name", name);
        },
        updateFullDetail(state, detail) {
          Object.assign(state.selectedFacility, detail);
        },
        updateMapState(state, payload) {
          state.mapState = payload;
        },
        updatecurrentPosition(state, payload) {
          state.currentPosition = payload;
        },
        upDateIsPullUp(state, value) {
          state.isPullUp = value;
        }
        /* updateselectTag(state, payload) {
          state.selectTag = payload;
        },
        updateselectID(state, payload) {
          state.selectID = payload;
        }, */
      }
    });
  }
};

module.exports = store;
