import Vue from "vue";
import Router from "vue-router";

import Index from "@/pages/index";
import workPlace from "@/pages/workPlace";
Vue.use(Router);

const originalPush = Router.prototype.push;
Router.prototype.push = function push(location, onResolve, onReject) {
  if (onResolve || onReject)
    return originalPush.call(this, location, onResolve, onReject);
  return originalPush.call(this, location).catch((err) => err);
};

export default new Router({
  routes: [
    {
      path: "/",
      redirect: "/index",
    },
    {
      path: "/index",
      name: "index",
      component: () => import("@/pages/index"),
      redirect: "/workplace",
      children: [
        {
          path: "/workplace",
          name: "workPlace",
          component: () => import("@/pages/workPlace"),
        },
        {
          path: "/servicedetail",
          name: "servicedetail",
          component: () => import("@/pages/serviceDetail"),
        },
        {
          path: "/fwzc", // 服务注册
          name: "fwzc",
          redirect: "/fwzc/fwcs",
          component: () => import("@/pages/fwzc_fwcs"),
          children: [
            {
              path: "/fwzc/fwcs", // 服务注册/服务测试
              name: "fwcs",
              component: () => import("@/pages/fwzc_fwcs"),
            },
          ],
        },
        {
          path: "/fwgl", // 服务管理
          name: "fwgl",
          // redirect: "/fwgl/list",
          component: () => import("@/pages/fwgl"),
          children: [
            {
              path: "/fwgl/list/:type/:name", // 服务管理/我的服务
              name: "fwglList",
              component: () => import("@/pages/fwglList"),
            },
          ],
        },
      ],
    },
    {
      path: "/example_table", // 表格实例
      name: "example_table",
      component: () => import("@/pages/example_table"),
    },
    {
      path: "/example_upload", // 表格实例
      name: "example_upload",
      component: () => import("@/pages/example_upload"),
    },
    {
      path: "/example_code", // 编辑器实例
      name: "example_code",
      component: () => import("@/pages/example_code"),
    },
    {
      path: "/example_icon", // svg 实例
      name: "example_icon",
      component: () => import("@/pages/example_icon"),
    },
    {
      path: "/example_topology", // 拓扑图实例
      name: "example_topology",
      component: () => import("@/pages/example_topology")
    },
    {
      path: "/example_commodity", // 商品详情实例
      name: "example_commodity",
      component: () => import("@/pages/example_commodity")
    },
    {
      path: "/example_com_list", // 商品列表实例
      name: "example_com_list",
      component: () => import("@/pages/example_com_list")
    }
  ]
});
