import Vue from "vue";
import Router from "vue-router";

import Index from "@/pages/index";
import workPlace from "@/pages/workPlace";
Vue.use(Router);

const originalPush = Router.prototype.push;
Router.prototype.push = function push(location, onResolve, onReject) {
  if (onResolve || onReject)
    return originalPush.call(this, location, onResolve, onReject);
  return originalPush.call(this, location).catch((err) => err);
};

export default new Router({
  routes: [
    {
      path: "/",
      redirect: "/index",
    },
    {
      path: "/index",
      name: "index",
      component: () => import("@/pages/index"),
      redirect: "/workplace",
      children: [
        {
          path: "/fwzc", // 服务注册
          name: "fwzc",
          redirect: "/fwzc/fwcs",
          component: () => import("@/pages/fwzc_fwcs"),
          children: [
            {
              path: "/fwzc/fwcs", // 服务注册/服务测试
              name: "fwcs",
              component: () => import("@/pages/fwzc_fwcs"),
            },
          ],
        },
        {
          path: "/fwgl/:level", // 服务管理 level：用户等级
          name: "fwgl",
          redirect: "/fwgl/:level/0",
          component: () => import("@/pages/fwgl"),
          children: [
            {
              path: "/fwgl/:level/:type", // 服务管理列表页
              name: "fwglList",
              component: () => import("@/pages/fwglList"),
            },
            {
              path: "/fwgl/:level/:type/servicedetail/:id",
              name: "servicedetail",
              component: () => import("@/pages/serviceDetail"),
            }, // 注册发布的服务 - 详情
            {
              path: "/fwgl/:level/:type/serviceedit/:id",
              name: "serviceedit",
              component: () => import("@/pages/serviceEdit"),
            }, // 注册发布的服务 - 编辑
            {
              path: "/fwgl/:level/:type/applyserviceedit/:id",
              name: "applyserviceedit",
              component: () => import("@/pages/apply_service_detail"),
            }, // 申请的服务 - 详情
            {
              path: "/fwgl/:level/:type/approvalserviceedit/:id",
              name: "approvalserviceedit",
              component: () => import("@/pages/approval_service_detail"),
            }, // 审批的服务 - 详情
          ],
        },
        {
          path: "/shop", // 服务超市
          name: "shop",
          redirect: "/shop/data_service_list",
          component: () => import("@/pages/shop"),
          children: [
            {
              path: "/shop/data_service_list", // 数据服务列表页
              name: "shopDataList",
              component: () => import("@/pages/shop_list_data"),
            },
            {
              path: "/shop/space_time_service_list", // 时空服务列表页
              name: "shopSpaceTimeList",
              component: () => import("@/pages/shop_list_space_time"),
            },
            {
              path: "/shop/video_service_list", // 视频服务列表页
              name: "shopVideoList",
              component: () => import("@/pages/shop_list_video"),
            },
            {
              path: "/shop/perception_service_list", // 感知服务列表页
              name: "shopPerceptionList",
              component: () => import("@/pages/shop_list_perception"),
            },
            {
              path: "/shop/comprehensive_app_list", // 综合应用列表页
              name: "shopComAppList",
              component: () => import("@/pages/shop_list_comprehensive_app"),
            },
            {
              path: "/shop/cloud", // 云资源服务
              name: "shopCloud",
              component: () => import("@/pages/shop_cloud"),
            },
            {
              path: "/shop/app_store_list", // 应用商店列表页
              name: "shopAppStoreList",
              component: () => import("@/pages/shop_list_app_store"),
            },
            {
              path: "/shop/shopping_cart", // 购物车页
              name: "shoppingCart",
              component: () => import("@/pages/shopping_cart"),
            },
          ],
        },
        {
          path: "/shop/sjfwDetail/:id",
          name: "sjfwDetail",
          component: () => import("@/pages/sjfwDetail"),
        }, // 数据服务详情
        {
          path: "/shop/skfwDetail/:id",
          name: "skfwDetail",
          component: () => import("@/pages/skfwDetail"),
        }, // 时空服务详情
        {
          path: "/shop/zhyyfwDetail/:id",
          name: "zhyyfwDetail",
          component: () => import("@/pages/zhyyfwDetail"),
        }, // 综合应用服务详情
        {
          path: "/shop/yysdDetail/:id",
          name: "yysdDetail",
          component: () => import("@/pages/yysdDetail"),
        }, // 应用详情
        {
          path: "/workplace",
          name: "workPlace",
          component: () => import("@/pages/workPlace"),
        },
        {
          path: "/user", // 个人中心
          name: "user",
          redirect: "/user/user_info",
          component: () => import("@/pages/user"),
          children: [
            {
              path: "/user/user_info", // 个人信息页
              name: "userInfo",
              component: () => import("@/pages/user_info"),
            },
            {
              path: "/user/message", // 消息管理页
              name: "message",
              component: () => import("@/pages/message"),
            },
            {
              path: "/user/order_list", // 订单管理页
              name: "orderList",
              component: () => import("@/pages/order_list"),
            },
          ],
        },
        {
          path: "/authority", // 权限管理
          name: "authority",
          redirect: "/authority/organization",
          component: () => import("@/pages/authority"),
          children: [
            {
              path: "/authority/organization", // 组织管理页
              name: "organization",
              component: () => import("@/pages/organization"),
            },
            {
              path: "/authority/users", // 用户管理页
              name: "users",
              component: () => import("@/pages/users"),
            },
            {
              path: "/authority/menu", // 菜单管理页
              name: "menu",
              component: () => import("@/pages/menu"),
            },
            {
              path: "/authority/roles", // 角色管理页
              name: "roles",
              component: () => import("@/pages/roles"),
            },
          ],
        },
      ],
    },
    {
      path: "/example_table", // 表格实例
      name: "example_table",
      component: () => import("@/pages/example_table"),
    },
    {
      path: "/example_upload", // 表格实例
      name: "example_upload",
      component: () => import("@/pages/example_upload"),
    },
    {
      path: "/example_code", // 编辑器实例
      name: "example_code",
      component: () => import("@/pages/example_code"),
    },
    {
      path: "/example_icon", // svg 实例
      name: "example_icon",
      component: () => import("@/pages/example_icon"),
    },
    {
      path: "/example_topology", // 拓扑图实例
      name: "example_topology",
      component: () => import("@/pages/example_topology"),
    },
    {
      path: "/example_commodity", // 商品详情实例
      name: "example_commodity",
      component: () => import("@/pages/example_commodity"),
    },
    {
      path: "/example_com_list", // 商品列表实例
      name: "example_com_list",
      component: () => import("@/pages/example_com_list"),
    },
  ],
});
