import axios from '@/request/http'; // 导入http中创建的axios实例
import qs from 'qs'; // 根据需求是否导入qs模块

const dataAnalysis = {
  // Data Analysis
  // service
  getServiceOverview() {
    return axios.get(`/apaas/service/v3/statistics/normal/service/basic`);
  },
  getServiceHealth() {
    return axios.get(`/apaas/service/v3/statistics/normal/service/health`);
  },
  getServiceTrend(params) {
    return axios.get(`/apaas/service/v3/statistics/normal/service/trend?type=${params.type == 0 ? 'week' : 'mon'}`);
  },
  getServiceType(params) {
    return axios.get(`/apaas/service/v3/statistics/normal/service/type/${params.type == 0 ? 'register' : 'apply'}`);
  },
  getServiceSectorse(params) {
    return axios.get(`/apaas/service/v3/statistics/normal/service/sectors/${params.type == 0 ? 'register' : 'apply'}`);
  },
  getServiceOrg() {
    return axios.get(`/apaas/service/v3/statistics/normal/service/org`);
  },
  getServiceOpenness(params) {
    return axios.get(`/apaas/service/v3/statistics/normal/service/openness/${params.type == 0 ? 'register' : 'apply'}`);
  },
  getServiceRequest(params) {
    return axios.get(`/apaas/service/v3/statistics/normal/service/request/${params.type == 0 ? 'register' : 'apply'}`);
  },
  getServiceOnlineState(params) {
    return axios.get(`/apaas/service/v3/statistics/normal/service/onlinestate/${params.type == 0 ? 'day14' : 'day30'}`);
  },
  getServiceEstimated(params) {
    return axios.get(`/apaas/service/v3/statistics/normal/service/estimated/${params.type == 0 ? 'all' : 'scoremap'}?last_id=${params.last_id}`);
  },
  getServiceHotSearch() {
    return axios.get(`/apaas/service/v3/statistics/normal/service/search`);
  },
  getServiceApprovalChanges(params) {
    return axios.get(`/apaas/service/v3/statistics/normal/service/approval/trend?type=${params.type == 0 ? 'day14' : 'day30'}`);
  },
  getServiceApprovalStatus() {
    return axios.get(`/apaas/service/v3/statistics/normal/service/approval/distribute`);
  },

  //app
  getAppOverview(){
    return axios.get(`/apaas/hubApi/analysis/overview`);
  },
  getAppUsedCount(params){
    return axios.get(`/apaas/hubApi/analysis/deployCount?day=${params.day}`);
  },
  getAppType(params){
    return axios.get(`/apaas/hubApi/analysis/typesAnalysis?style=${params.type}`);
  },
  getAppSourceOri(){
    return axios.get(`/apaas/hubApi/analysis/appSource`);
  },
  getAppUsedArea(params){
    return axios.get(`/apaas/hubApi/analysis/areasAnalysis?style=${params.type}`);
  },
  getAppCount(params){
    return axios.get(`/apaas/hubApi/analysis/numTrend?day=${params.day}`);
  },
  getAppDeployRank(params){
    return axios.get(`/apaas/hubApi/analysis/deployRank?style=${params.type}`);
  },
  getAppEvaluate(params){
    return axios.get(`/apaas/hubApi/analysis/commentScores?style=${params.type}`);
  },
  getAppOnlineState(){
    return axios.get(`/apaas/hubApi/analysis/onlineAreas`);
  },
  getAppHot(){
    return axios.get(`/apaas/hubApi/analysis/appSearch`);
  },
  getAppApproval(params) {
    return axios.get(`/apaas/hubApi/analysis/approvalChanges?day=${params.type}`);
  },
  getAppApprovalState(params) {
    return axios.get(`/apaas/hubApi/analysis/approvalStatus?style=${params.type}`);
  },
}

export default dataAnalysis;
