import axios from '@/request/http'; // 导入http中创建的axios实例
import qs from 'qs'; // 根据需求是否导入qs模块

const productType = {
  // 分类相关接口
  getClassTypeList(params) {
    return axios.get(`/apaas/service/v3/service/manager/servtypeList`,{params})
  }, // 服务分类/服务类型列表
  changeClassState(params) {
    return axios.put(`/apaas/service/v3/service/manager/servtype/state`,params)
  }, // 服务分类/服务类型状态改变
  deleteClass(id) {
    return axios.delete(`/apaas/service/v3/service/manager/servtype/${id}`)
  }, // 删除服务分类/服务类型
  addNewClass(params) {
    return axios.post(`/apaas/service/v3/service/manager/servtype`,params)
  }, // 新增服务分类/服务类型
  editClass(params) {
    return axios.put(`/apaas/service/v3/service/manager/servtype`,params)
  }, // 编辑服务分类/服务类型
  getClassDetail(id) {
    return axios.get(`/apaas/service/v3/service/manager/servtype/${id}`)
  }, // 获取服务分类/服务类型详情
  getClassTypes() {
    return axios.get(`/apaas/service/v3/service/manager/allServtypes?state=1`)
  }, // 获取所有的产品分类

  // 领域相关接口
  getDomainTypeList(params) {
    return axios.get(`/apaas/service/v3/service/manager/servareaList`,{params})
  }, // 领域分类列表
  changeDomainState(params) {
    return axios.put(`/apaas/service/v3/service/manager/servarea/state`,params)
  }, // 领域分类状态改变
  deleteDomain(id) {
    return axios.delete(`/apaas/service/v3/service/manager/servarea/${id}`)
  }, // 删除领域分类
  addNewDomain(params) {
    return axios.post(`/apaas/service/v3/service/manager/servarea`,params)
  }, // 新增领域分类
  editDomain(params) {
    return axios.put(`/apaas/service/v3/service/manager/servarea`,params)
  }, // 编辑领域分类
  getDomainDetail(id) {
    return axios.get(`/apaas/service/v3/service/manager/servarea/${id}`)
  }, // 获取领域分类详情
}

export default productType;
