import "babel-polyfill";

import store from "@/store";

import Vue from 'vue'

import mavonEditor from 'mavon-editor'
import 'mavon-editor/dist/css/index.css'
Vue.use(mavonEditor)

import { codemirror } from 'vue-codemirror'
import 'codemirror/lib/codemirror.css'
Vue.use(codemirror)


import VueResource from "vue-resource";
Vue.use(VueResource);

import ElementUI from 'element-ui';
import 'element-ui/lib/theme-chalk/index.css'
Vue.use(ElementUI)

import App from "./App";
import router from "./router";

import "@/icons"

import "./assets/css/index.css";


import ECharts from "vue-echarts/components/ECharts";
Vue.component("chart", ECharts);
// vue-echarts按需引入
import "echarts/lib/chart/line"; // 折线
import "echarts/lib/chart/pie"; // 饼状图
import "echarts/lib/chart/bar"; // 柱状图
import "echarts/lib/chart/pie"; // 柱状图
import "echarts/lib/chart/gauge"; // 仪表盘
import "echarts/lib/chart/radar"; // 雷达图
import "echarts/lib/component/tooltip"; // 提示
import "echarts/lib/component/legend"; // 图例
import "echarts/lib/component/title"; // 标题
import 'echarts/lib/component/polar'; // 极坐标系
import 'echarts/lib/chart/scatter'; // 散点图
import 'echarts/lib/component/dataZoom'

import liquidfill from 'echarts-liquidfill'
Vue.use(liquidfill)

import Sparkline from 'vue-sparklines'

Vue.use(Sparkline)

import VueI18n from 'vue-i18n'
Vue.use(VueI18n)

const i18n = new VueI18n({
  locale: 'zh',
  messages: {
    'zh': require('@/assets/i18n/language-zh')
  }
})

import SuperFlow from 'vue-super-flow'
import 'vue-super-flow/lib/index.css'
Vue.use(SuperFlow)

import api from './request/api'
Vue.prototype.$api = api;

new Vue({
  el: "#app",
  router,
  store,
  i18n,
  components: { App },
  template: "<App/>"
});
