import axios from '@/request/http'; // 导入http中创建的axios实例
import qs from 'qs'; // 根据需求是否导入qs模块

const authority = {
    // Menu
    getMenuList() {
        return axios.get(`/apaas/backmgt/menu/list`);
    },
    addMenu(params) {
        return axios.post(`/apaas/backmgt/menu`, params);
    },
    delMenu(params) {
        return axios.delete(`/apaas/backmgt/menu/id/${params.id}`);
    },
    getMenu(params) {
        return axios.get(`/apaas/backmgt/menu/id/${params.id}`);
    },
    positionMenu(params) {
        return axios.post(`/apaas/backmgt/menu/menuOrder`, params);
    },
    editMenu(params) {
        return axios.put(`/apaas/backmgt/menu`, params);
    },

    // 
}

export default authority;
