import axios from '@/request/http'; // 导入http中创建的axios实例
import qs from 'qs'; // 根据需求是否导入qs模块

const serviceShop = {

    // service list
    getServiceShopFilter(params) {
        // 5:数据   6:时空  7:视频  10:感知
        return axios.get(`/apaas/serviceapp/v3/servicemarket/profileInfo?serviceType=${params.type}`);
    },
    getServiceShopList(params) {
        return axios.get(`/apaas/serviceapp/v3/servicemarket/list?
serviceName=${params.serviceName}&serviceType1=${params.serviceType1}&
serviceType2s=${params.serviceType2s}&dataDomains=${params.dataDomains}&
organizeIds=${params.organizeIds}&orderBy=${params.orderBy}&
Page=${params.Page}&Size=${params.Size}`);
    },
    getServiceShopDetail(params) {
        return axios.get(`/apaas/serviceapp/v3/servicemarket/detail?serviceId=`)
    },
    // service list application
    getAppArea() {
        return axios.get(`/apaas/hubApi/market/businessAreas`)
    },
    getAppType() {
        return axios.get(`/apaas/hubApi/market/appTypes`)
    },
    getAppOrg() {
        return axios.get(`/apaas/hubApi/market/departments`)
    },
    getAppList(params) {
        return axios.get(`/apaas/hubApi/market/list?online_state=${params.online_state}&appTypes=${params.appTypes}&
businessArea=${params.businessArea}&developable=${params.developable}&orgSource=${params.orgSource}&order=${params.order}&page=${params.page}&limit=${params.limit}&search=${params.search}`);
    },

    // cloud
    getCloudList() {
        return axios.get(`/apaas/serviceapp/v3/resource/list`)
    },
    applicationCloud(params) {
        return axios.post(`/apaas/serviceapp/v3/resource/apply/new`, params)
    },
    updateCloud(params) {
        return axios.post(`/apaas/serviceapp/v3/resource/apply/up`, params)
    },

    // shopping cart
    addShoppingCart(params) {
        return axios.post(`/apaas/serviceapp/v3/shopcart/add`, params);
    },
    delShoppingCart(params) {
        // note: if parans is empty, it will delete all data.
        return axios.post(`/apaas/serviceapp/v3/shopcart/del`, params);
    },
    getShoppingCart() {
        return axios.get(`/apaas/serviceapp/v3/shopcart/list`);
    },
    updateShoppingCart(params) {
        return axios.post(`/apaas/serviceapp/v3/shopcart/update`, params);
    },
    getSystemList() {
        return axios.get(`/apaas/serviceapp/v3/shopcart/systems`);
    },
    submitShoppingCart() {
        return axios.post(`/apaas/serviceapp/v3/shopcart/apply`, params);
    },
}

export default serviceShop;
