import Vue from "vue";
import Router from "vue-router";

Vue.use(Router);

const originalPush = Router.prototype.push;
Router.prototype.push = function push(location, onResolve, onReject) {
  if (onResolve || onReject)
    return originalPush.call(this, location, onResolve, onReject);
  return originalPush.call(this, location).catch((err) => err);
};

export default new Router({
  scrollBehavior (to, from, savedPosition) {
    return { x: 0, y: 0 }
  },
  routes: [
    {
      path: "/",
      redirect: "/index",
    },
    {
      path: "/index",
      name: "index",
      component: () => import("@/pages/index"),
      redirect: "/services_shop",
      children: [
        {
          path: "/fwzc", // 服务注册
          name: "fwzc",
          redirect: "/fwzc/fwcs",
          component: () => import("@/pages/workbench/fwzc_fwcs"),
          children: [
            {
              path: "/fwzc/fwcs", // 服务注册/服务测试
              name: "fwcs",
              component: () => import("@/pages/workbench/fwzc_fwcs"),
            },
          ],
        }, // 工作台 - 服务注册模块
        {
          path: "/fwgl/:level", // 服务管理 level：用户等级
          name: "fwgl",
          redirect: "/fwgl/:level/0",
          component: () => import("@/pages/workbench/fwgl/fwgl"),
          children: [
            {
              path: "/fwgl/:level/:type", // 服务管理列表页
              name: "fwglList",
              component: () => import("@/pages/workbench/fwgl/fwglList"),
            },
            {
              path: "/fwgl/:level/:type/servicedetail/:id",
              name: "servicedetail",
              component: () => import("@/pages/workbench/fwgl/serviceDetail"),
            }, // 注册发布的服务 - 详情
            {
              path: "/fwgl/:level/:type/serviceedit/:id",
              name: "serviceedit",
              component: () => import("@/pages/workbench/fwgl/serviceEdit"),
            }, // 注册发布的服务 - 编辑
            {
              path: "/fwgl/:level/:type/applyserviceedit/:id",
              name: "applyserviceedit",
              component: () =>
                import("@/pages/workbench/fwgl/apply_service_detail"),
            }, // 申请的服务 - 详情
            {
              path: "/fwgl/:level/:type/approvalserviceedit/:id",
              name: "approvalserviceedit",
              component: () =>
                import("@/pages/workbench/fwgl/approval_service_detail"),
            }, // 审批的服务 - 详情
            {
              path: "/fwgl/:level/:type/cloud_detail/:id",
              name: "cloud_detail",
              component: () => import("@/pages/workbench/fwgl/cloud-detail"),
            }, // 云资源 - 详情
            {
              path: "/fwgl/:level/:type/approveWorkspace",
              name: "approveWorkspace",
              component: () =>
                import("@/pages/workbench/fwgl/approveWorkspace"),
            }, // 云资源 - 工作区域审批
            {
              path: "/fwgl/:level/:type/organizationCloudResource/:id",
              name: "organizationCloudResource",
              component: () =>
                import("@/pages/workbench/fwgl/organizationCloudResource"),
            }, // 云资源 - 组织云资源详情
          ],
        }, // 工作台 - 服务管理模块
        {
          path: "/yygl/:level", // 应用管理 level：用户等级
          name: "yygl",
          redirect: "/yygl/:level/0",
          component: () => import("@/pages/workbench/yygl/yygl"),
          children: [
            {
              path: "/yygl/:level/:type", // 应用管理列表页
              name: "yyglList",
              component: () => import("@/pages/workbench/yygl/yyglList"),
            },
            {
              path: "/yygl/:level/:type/detail/:id", // 应用仓库详情
              name: "appdetail",
              component: () => import("@/pages/workbench/yygl/app_detail"),
            },
            {
              path: "/yygl/:level/:type/edit/:id", // 应用仓库编辑
              name: "appedit",
              component: () => import("@/pages/workbench/yygl/app_edit"),
            },
            {
              path: "/yygl/:level/:type/deploydetail/:deploy_id", // 我部署的应用详情
              name: "deploy_app_detail",
              component: () =>
                import("@/pages/workbench/yygl/deploy_app_detail"),
            },
            {
              path: "/yygl/:level/:type/appdebugger/:deploy_id", // 我部署的应用详情-应用调试
              name: "app_debugger",
              component: () => import("@/pages/workbench/yygl/app_debugger"),
            },
            {
              path: "/yygl/:level/:type/appdebuggerdetail/:deploy_id", // 我部署的应用详情-应用调试-详情
              name: "app_debugger_detail",
              component: () =>
                import("@/pages/workbench/yygl/app_debugger_detail"),
            },
            {
              path: "/yygl/:level/:type/applydetail/:id/:app_id", // 我申请的应用详情
              name: "apply_app_detail",
              component: () =>
                import("@/pages/workbench/yygl/apply_app_detail"),
            },
            {
              path: "/yygl/:level/:type/approvaldetail/:id/:app_id", // 我审批的应用详情
              name: "approval_app_detail",
              component: () =>
                import("@/pages/workbench/yygl/approval_app_detail"),
            },
            {
              path: "/yygl/:level/:type/deployment/:app_id", // 一键部署
              name: "appDeployment",
              component: () => import("@/pages/workbench/yygl/deployment"),
            },
          ],
        }, // 工作台 - 应用管理模块
        {
          path: "/technical_support",
          name: "technicalSupport",
          redirect: "/technical_support/doc",
          component: () => import("@/pages/technical-support/index"),
          children: [
            {
              path: "/technical_support/doc",
              name: "technicalSupportDoc",
              component: () => import("@/pages/technical-support/doc/index"),
              children: [
                {
                  path: "/technical_support/doc/:type/:id",
                  name: "technicalSupportDocDetail",
                  component: () =>
                    import("@/pages/technical-support/doc/detail"),
                }, // 开发文档详情
              ],
            }, // 开发文档
            {
              path: "/technical_support/doc_manage",
              name: "technicalSupportDocManage",
              redirect: "/technical_support/doc_manage/list",
              component: () =>
                import("@/pages/technical-support/doc-manage/index"),
              children: [
                {
                  path: "/technical_support/doc_manage/list",
                  name: "technicalSupportDocManageList",
                  component: () =>
                    import("@/pages/technical-support/doc-manage/list"),
                }, // 开发文档管理列表
                {
                  path: "/technical_support/doc_manage/edit/:id",
                  name: "technicalSupportDocManageDetail",
                  component: () =>
                    import("@/pages/technical-support/doc-manage/detail"),
                }, // 开发文档管理编辑
              ],
            }, // 开发文档管理
            {
              path: "/technical_support/demo_center",
              name: "technicalSupportDemo",
              // redirect: "/technical_support/demo_center/index",
              component: () =>
                import("@/pages/technical-support/demo-center/index"),
              // children: [
              //   {
              //     path: "/technical_support/doc_manage/list",
              //     name: "technicalSupportDocDetail",
              //     component: () =>
              //       import("@/pages/technical-support/doc-manage/list"),
              //   }, // 示例中心管理列表
              // ],
            }, // 示例中心
            {
              path: "/technical_support/answer_center/",
              name: "answerCenter",
              redirect: "/technical_support/answer_center/list",
              component: () =>
                import("@/pages/technical-support/answer-center/index"),
              children: [
                {
                  path: "/technical_support/answer_center/list",
                  name: "answerCenterList",
                  component: () =>
                    import("@/pages/technical-support/answer-center/list"),
                }, // 问答中心列表
                {
                  path: "/technical_support/answer_center/edit",
                  name: "answerCenterEdit",
                  component: () =>
                    import("@/pages/technical-support/answer-center/edit"),
                }, // 问答中心编辑
                {
                  path: "/technical_support/answer_center/detail/:id",
                  name: "answerCenterDetail",
                  component: () =>
                    import("@/pages/technical-support/answer-center/detail"),
                }, // 问答中心详情
              ],
            }, // 问答中心
            {
              path: "/technical_support/sdk",
              name: "technicalSupportSdk",
              component: () => import("@/pages/technical-support/sdk/index"),
              children: [
                {
                  path: "/technical_support/sdk/:type/:id",
                  name: "technicalSupportSdkDetail",
                  component: () =>
                    import("@/pages/technical-support/sdk/detail"),
                }, // 问答中心列表
              ],
            }, // SDK中心
            {
              path: "/technical_support/sdk_manage",
              name: "technicalSupportSDK",
              redirect: "/technical_support/sdk_manage/type",
              component: () =>
                import("@/pages/technical-support/sdk-manage/index"),
              children: [
                {
                  path: "/technical_support/sdk_manage/type",
                  name: "technicalSupportSdkType",
                  component: () =>
                    import("@/pages/technical-support/sdk-manage/type/index"),
                }, // SDK类型管理
                {
                  path: "/technical_support/sdk_manage/example",
                  name: "technicalSupportSdkExample",
                  component: () =>
                    import(
                      "@/pages/technical-support/sdk-manage/example/index"
                    ),
                }, // SDK示例管理
                {
                  path: "/technical_support/sdk_manage/example/:id",
                  name: "technicalSupportSdkExampleDetail",
                  component: () =>
                    import(
                      "@/pages/technical-support/sdk-manage/example/detail"
                    ),
                }, // SDK示例详情
              ],
            }, // SDK管理
          ],
        }, // 技术支持
        {
          path: "/shop", // 服务超市
          name: "shop",
          redirect: "/shop/data_service_list/5",
          component: () => import("@/pages/service_shop/shop"),
          children: [
            {
              path: "/shop/data_service_list/:id", // 数据服务列表页
              name: "shopDataList",
              component: () => import("@/pages/service_shop/shop_list-new"),
            },
            {
              path: "/shop/space_time_service_list/:id", // 时空服务列表页
              name: "shopSpaceTimeList",
              component: () => import("@/pages/service_shop/shop_list-new"),
            },
            {
              path: "/shop/video_service_list/:id", // 视频服务列表页
              name: "shopVideoList",
              component: () => import("@/pages/service_shop/shop_list-new"),
            },
            {
              path: "/shop/perception_service_list/:id", // 感知服务列表页
              name: "shopPerceptionList",
              component: () => import("@/pages/service_shop/shop_list-new"),
            },
            {
              path: "/shop/comprehensive_app_list/:id", // 综合应用列表页
              name: "shopComAppList",
              component: () => import("@/pages/service_shop/shop_list-new"),
            },
            {
              path: "/shop/cloud", // 云资源服务
              name: "shopCloud",
              component: () => import("@/pages/service_shop/shop_cloud-new"),
            },
            {
              path: "/shop/service_application_successfully", // 申请服务成功
              name: "shopSuccess",
              component: () =>
                import("@/pages/service_shop/service_application_successfully"),
            },
            {
              path: "/shop/app_store_list/:id", // 应用商店列表页
              name: "shopAppStoreList",
              component: () => import("@/pages/service_shop/shop_list-new"),
            },
            {
              path: "/shop/products_list/:id", // 应用商店列表页
              name: "shopAppStoreList",
              component: () => import("@/pages/service_shop/shop_list-new"),
            },
            {
              path: "/shop/shopping_cart", // 购物车页
              name: "shoppingCart",
              component: () => import("@/pages/service_shop/shopping_cart"),
            },
            {
              path: "/shop/shop_car_apply", // 购物车服务申请页
              name: "shopCarApply",
              component: () => import("@/pages/service_shop/shop_car_apply"),
            },
          ],
        }, // 服务超市 - 列表页
        {
          path: "/shop/sjfwDetail/:id",
          name: "sjfwDetail",
          component: () => import("@/pages/service_shop/sjfwDetail"),
        }, // 服务超市 - 数据服务详情
        {
          path: "/shop/skfwDetail/:id",
          name: "skfwDetail",
          component: () => import("@/pages/service_shop/skfwDetail"),
        }, // 服务超市 - 时空服务详情
        {
          path: "/shop/spfwDetail/:id",
          name: "spfwDetail",
          component: () => import("@/pages/service_shop/spfwDetail"),
        }, // 服务超市 - 视频服务详情
        {
          path: "/shop/gzfwDetail/:id",
          name: "sjfwDetail",
          component: () => import("@/pages/service_shop/gzfwDetail"),
        }, // 服务超市 - 感知服务详情
        {
          path: "/shop/zhfwDetail/:id",
          name: "zhfwDetail",
          component: () => import("@/pages/service_shop/zhfwDetail"),
        }, // 服务超市 - 综合应用详情
        {
          path: "/shop/yysdDetail/:id",
          name: "yysdDetail",
          component: () => import("@/pages/service_shop/yysdDetail"),
        }, // 服务超市 - 应用详情
        {
          path: "/shop/cpDetail/:id",
          name: "cpDetail",
          component: () => import("@/pages/service_shop/cpDetail"),
        }, // 服务超市 - 产品资源详情
        {
          path: "/workplace",
          name: "workPlace",
          component: () => import("@/pages/workbench/workPlace"),
        }, // 主页 - 工作台
        {
          path: "/services_shop",
          name: "services_shop",
          component: () => import("@/pages/service_shop/services_shop"),
        }, // 主页 - 服务超市
        {
          path: "/app_build",
          name: "app_build",
          component: () =>
            import("@/pages/workbench/component-center/app-build/index"),
        }, // 应用构建（镜像形式）
        {
          path: "/intelligent_drawing",
          name: "intelligent_drawing",
          component: () =>
            import(
              "@/pages/workbench/component-center/intelligent-drawing/intelligent_drawing"
            ),
        }, // 智能制图
        {
          path: "/intelligent_details",
          name: "intelligent_details",
          component: () =>
            import(
              "@/pages/workbench/component-center/intelligent-drawing/intelligent_details"
            ),
        }, // 智能制图--详情页面
        {
          path: "/intelligent_appbuilder",
          name: "intelligent_appbuilder",
          component: () =>
            import(
              "@/pages/workbench/component-center/intelligent-drawing/intelligent_appbuilder"
            ),
        }, // 智能制图--应用程序页面
        {
          path: "/intelligent_fwzc",
          name: "intelligent_fwzc",
          component: () =>
            import(
              "@/pages/workbench/component-center/intelligent-drawing/intelligent_fwzc"
            ),
        }, // 智能制图--服务注册测试页面
        {
          path: "/progress", // 流程设计
          name: "progress",
          redirect: "/progress/designer",
          component: () =>
            import(
              "@/pages/workbench/component-center/process-management/index"
            ),
          children: [
            {
              path: "/progress/designer",
              name: "process_designer",
              component: () =>
                import(
                  "@/pages/workbench/component-center/process-management/designer/index"
                ),
            }, // 流程设计--列表
            {
              path: "/progress/designer/detail/:id",
              name: "process_designer_detail/:id",
              component: () =>
                import(
                  "@/pages/workbench/component-center/process-management/designer/detail"
                ),
            }, // 流程设计--详情
            {
              path: "/progress/monitoring",
              name: "process_monitoring",
              component: () =>
                import(
                  "@/pages/workbench/component-center/process-management/monitoring/index"
                ),
            }, // 流程监控
            {
              path: "/progress/designer/design",
              name: "process_design",
              component: () =>
                import(
                  "@/pages/workbench/component-center/process-management/process-design/index"
                ),
            }, // 流程设计
            {
              path: "/progress/designer/design_edit/:id",
              name: "process_design_edit",
              component: () =>
                import(
                  "@/pages/workbench/component-center/process-management/process-design/edit"
                ),
            }, // 流程编辑
          ],
        }, // 流程设计
        {
          path: "/search_engine",
          name: "search_engine",
          component: () =>
            import("@/pages/workbench/component-center/search-engine/index"),
        }, // 搜索引擎
        {
          path: "/user", // 个人中心
          name: "user",
          redirect: "/user/user_info",
          component: () => import("@/pages/user/user"),
          children: [
            {
              path: "/user/user_info", // 个人信息页
              name: "userInfo",
              component: () => import("@/pages/user/user_info"),
            },
            {
              path: "/user/notice", // 消息通知
              name: "notice",
              component: () => import("@/pages/user/notice/notice"),
            },
            {
              path: "/user/order_list", // 订单管理页
              name: "orderList",
              component: () => import("@/pages/user/order/order_list"),
            },
            {
              path: "/user/order_list/detail/:id", // 订单管理页
              name: "orderDetail",
              component: () => import("@/pages/user/order/order_detail"),
            },
            {
              path: "/qa/my_qa", // 我的问答
              name: "myQA",
              component: () => import("@/pages/user/questions-answers/my-qa"),
            },
            {
              path: "/user/my_coin", // 我的金币
              name: "myCoin",
              component: () => import("@/pages/user/my-coin"),
            },
          ],
        }, // 个人中心
        {
          path: "/qa_management", // 问答中心管理
          name: "qaManagement",
          redirect: "/qa/questions",
          component: () => import("@/pages/user/questions-answers/qa"),
          children: [
            {
              path: "/qa/questions", // 提问列表
              name: "questions",
              component: () =>
                import("@/pages/user/questions-answers/community"),
            },
            {
              path: "/qa/answers", // 回答列表
              name: "answers",
              component: () =>
                import("@/pages/user/questions-answers/community"),
            },
          ],
        },
        {
          path: "/authority", // 权限管理
          name: "authority",
          redirect: "/authority/organization",
          component: () => import("@/pages/authority/authority"),
          children: [
            {
              path: "/authority/organization", // 组织管理页
              name: "organization",
              component: () =>
                import("@/pages/authority/organization/organization"),
            },
            {
              path: "/authority/organization/detail/:id", // 组织管理详情
              name: "organizationdetail",
              component: () =>
                import("@/pages/authority/organization/organizationdetail"),
            },
            {
              path: "/authority/organization/add", // 组织管理组织新增
              name: "organizationadd",
              component: () =>
                import("@/pages/authority/organization/organizationedit"),
            },
            {
              path: "/authority/organization/edit/:id", // 组织管理组织编辑
              name: "organizationedit",
              component: () =>
                import("@/pages/authority/organization/organizationedit"),
            },
            {
              path: "/authority/organization/user/:id", // 组织管理组织用户
              name: "organizationuser",
              component: () =>
                import("@/pages/authority/user/organizationuser"),
            },
            {
              path: "/authority/users", // 用户管理页
              name: "users",
              component: () => import("@/pages/authority/user/users"),
            },
            {
              path: "/authority/users/roles/:id", // 分配角色
              name: "userRoles",
              component: () => import("@/pages/authority/user/userRoles"),
            },
            {
              path: "/authority/users/add", // 用户管理-新增
              name: "usersadd",
              component: () =>
                import("@/pages/authority/user/organizationuser"),
            },
            {
              path: "/authority/users/detail/:id", // 用户管理-详情
              name: "usersdetail",
              component: () =>
                import("@/pages/authority/user/organizationuser"),
            },
            {
              path: "/authority/users/money/:id", // 用户管理-充值
              name: "usersmoney",
              component: () =>
                import("@/pages/authority/user/money"),
            },
            {
              path: "/authority/users/permission", // 用户管理页 - 权限审批
              name: "users",
              component: () => import("@/pages/authority/user/permission"),
            },
            {
              path: "/authority/menu", // 菜单管理页
              name: "menu",
              component: () => import("@/pages/authority/menu/menus"),
            },
            {
              path: "/authority/roles", // 角色管理页
              name: "roles",
              component: () => import("@/pages/authority/role/roles"),
            },
            {
              path: "/authority/roles/add", // 新建角色
              name: "addroles",
              component: () => import("@/pages/authority/role/addroles"),
            },
            {
              path: "/authority/roles/edit/:id", // 编辑角色
              name: "editroles",
              component: () => import("@/pages/authority/role/addroles"),
            },
            {
              path: "/authority/roles/allot/:id", // 分配角色
              name: "allotroles",
              component: () => import("@/pages/authority/role/addroles"),
            },
          ],
        }, // 权限管理
        {
          path: "/data_analysis", // 数据分析中心
          name: "dataAnalysis",
          redirect: "/data_analysis/my_service",
          component: () => import("@/pages/data-analysis/data-analysis"),
          children: [
            {
              path: "/data_analysis/my_service", // 数据分析中心-普通
              name: "myServiceDataAnalysis",
              component: () => import("@/pages/data-analysis/my-service"),
            },
            {
              path: "/data_analysis/my_application", // 数据分析中心-普通
              name: "myApplicationDataAnalysis",
              component: () => import("@/pages/data-analysis/my-application"),
            },
            {
              path: "/data_analysis/org_service", // 数据分析中心服务-组织
              name: "orgServiceDataAnalysis",
              component: () => import("@/pages/data-analysis/org-service"),
            },
            {
              path: "/data_analysis/org_application", // 数据分析中心应用-组织
              name: "orgApplicationDataAnalysis",
              component: () => import("@/pages/data-analysis/org-application"),
            },
            {
              path: "/data_analysis/org_overview", // 运行概况-组织
              name: "orgOverview",
              component: () => import("@/pages/data-analysis/org-overview"),
            },
            {
              path: "/data_analysis/org_control", // 服务管控-组织
              name: "orgControl",
              component: () => import("@/pages/data-analysis/org-control"),
            },
            {
              path: "/data_analysis/super_service", // 数据分析中心服务-超管
              name: "superServiceDataAnalysis",
              component: () => import("@/pages/data-analysis/super-service"),
            },
            {
              path: "/data_analysis/super_application", // 数据分析中心应用-超管
              name: "superApplicationDataAnalysis",
              component: () =>
                import("@/pages/data-analysis/super-application"),
            },
            {
              path: "/data_analysis/super_overview", // 运行概况-超管
              name: "superOverview",
              component: () => import("@/pages/data-analysis/super-overview"),
            },
            {
              path: "/data_analysis/super_control", // 服务管控-超管
              name: "superControl",
              component: () => import("@/pages/data-analysis/org-control"),
            },
          ],
        },
        {
          path: "/message", // 消息与推送管理
          name: "message",
          redirect: "/message/recommended",
          component: () => import("@/pages/message-management/message"),
          children: [
            {
              path: "/message/recommended", // 推荐位管理列表
              name: "recommended",
              component: () =>
                import(
                  "@/pages/message-management/recommended/recommended-list"
                ),
            },
            {
              path: "/message/recommended/edit", // 推荐位管理选择列表
              name: "recommend_edit",
              component: () =>
                import(
                  "@/pages/message-management/recommended/recommended-eidt"
                ),
            },
            {
              path: "/message/directed_push", // 定向推送列表
              name: "directed_push",
              component: () =>
                import(
                  "@/pages/message-management/directed-push/directed-push-list"
                ),
            },
            {
              path: "/message/directed_push/add", // 新建定向推送
              name: "directed_push_add",
              component: () =>
                import(
                  "@/pages/message-management/directed-push/directed-push-add"
                ),
            },
            {
              path: "/message/message_alert", // 消息提醒列表
              name: "message_alert",
              component: () =>
                import(
                  "@/pages/message-management/message-alert/message-alert-list"
                ),
            },
            {
              path: "/message/message_alert/add", // 新建消息提醒
              name: "message_alert_add",
              component: () =>
                import(
                  "@/pages/message-management/message-alert/message-alert-add"
                ),
            },
            {
              path: "/message/banner", // benner列表
              name: "banner",
              component: () =>
                import("@/pages/message-management/banner/banner-list"),
            },
            {
              path: "/message/banner_add", // benner新增
              name: "banner_add",
              component: () =>
                import("@/pages/message-management/banner/banner-detail"),
            },
            {
              path: "/message/banner_edit", // benner编辑
              name: "banner_edit",
              component: () =>
                import("@/pages/message-management/banner/banner-detail"),
            },
            {
              path: "/message/banner_detail", // benner详情
              name: "banner_detail",
              component: () =>
                import("@/pages/message-management/banner/banner-detail"),
            },
            {
              path: "/message/message_template", // 消息模板列表
              name: "message_template",
              component: () =>
                import(
                  "@/pages/message-management/message-template/message-template-list"
                ),
            },
            {
              path: "/message/message_template/add", // 新增消息模板
              name: "message_template_add",
              component: () =>
                import(
                  "@/pages/message-management/message-template/message-template-detail"
                ),
            },
            {
              path: "/message/message_template/edit/:id", // 编辑消息模板
              name: "message_template_edit",
              component: () =>
                import(
                  "@/pages/message-management/message-template/message-template-detail"
                ),
            },
            {
              path: "/message/message_template/detail/:id", // 查看消息模板详情
              name: "message_template_detail",
              component: () =>
                import(
                  "@/pages/message-management/message-template/message-template-detail"
                ),
            },
          ],
        }, // 消息与推送管理
      ],
    },
    {
      path: "/example_table", // 表格实例
      name: "example_table",
      component: () => import("@/pages/example/example_table"),
    },
    {
      path: "/example_upload", // 表格实例
      name: "example_upload",
      component: () => import("@/pages/example/example_upload"),
    },
    {
      path: "/example_code", // 编辑器实例
      name: "example_code",
      component: () => import("@/pages/example/example_code"),
    },
    {
      path: "/example_icon", // svg 实例
      name: "example_icon",
      component: () => import("@/pages/example/example_icon"),
    },
    {
      path: "/example_topology", // 拓扑图实例
      name: "example_topology",
      component: () => import("@/pages/example/example_topology"),
    },
    {
      path: "/example_commodity", // 商品详情实例
      name: "example_commodity",
      component: () => import("@/pages/example/example_commodity"),
    },
    {
      path: "/example_com_list", // 商品列表实例
      name: "example_com_list",
      component: () => import("@/pages/example/example_com_list"),
    },
    {
      path: "/example_com_flow", // 流程图实例
      name: "example_com_flow",
      component: () => import("@/pages/example/example_com_flow"),
    },
  ],
});
