
module.exports.GetProperty = function (obj, prop) {
  if (!obj) return null;
  let res = obj;
  if (prop) {
    let props = prop.split('.');
    for (let i = 0; i < props.length; i++) {
      res = res[props[i]];
      if (typeof res == "undefined" || res == null) {
        return null;
      }
    }
  }
  return res;
}

module.exports.dateFormat = function (fmt, timestamp) {
  let date = new Date(timestamp);
  let ret;
  const opt = {
    "Y+": date.getFullYear().toString(),        // 年
    "m+": (date.getMonth() + 1).toString(),     // 月
    "d+": date.getDate().toString(),            // 日
    "H+": date.getHours().toString(),           // 时
    "M+": date.getMinutes().toString(),         // 分
    "S+": date.getSeconds().toString()          // 秒
    // 有其他格式化字符需求可以继续添加，必须转化成字符串
  };
  for (let k in opt) {
    ret = new RegExp("(" + k + ")").exec(fmt);
    if (ret) {
      fmt = fmt.replace(ret[1], (ret[1].length == 1) ? (opt[k]) : (opt[k].padStart(ret[1].length, "0")))
    };
  };
  return fmt;
}

module.exports.dateStringTransform = function (date) {
  /* 
    input: 2020-06-12T16:38:11+08:00
    output: 2020-06-12 16:38:11
  */
  if (String(date).indexOf("T") != -1) {
    let arr = date.split("T");
    let t = arr[1];
    let tarr = t.split('.000');
    let marr = tarr[0].split(':');
    let h = parseInt(marr[0]) >= 10 ? parseInt(marr[0]) : "0" + parseInt(marr[0]);
    let m = parseInt(marr[1]) >= 10 ? parseInt(marr[1]) : "0" + parseInt(marr[1]);
    let s = parseInt(marr[2]) >= 10 ? parseInt(marr[2]) : "0" + parseInt(marr[2]);
    let dd = arr[0] + " " + h + ":" + m + ":" + s;
    return dd;
  } else {
    return date;
  }
}

module.exports.downloadFileFormat = function (fileUrl) {
  /* 
    input: /apaas/static/docs/image/images/1234.png
    output: 1234.png
  */
  if (fileUrl != "") {
    return fileUrl.substring(fileUrl.lastIndexOf("/") + 1);
  } else {
    return "";
  }
}

module.exports.numberFormat = function (num, decimals) {
  /* 
    input:  10000 1000
    output: 10    1000
  */
  if (num > 10000) {
    return Math.floor(num / 10000).toFixed(decimals);
  } else {
    return num;
  }
}

module.exports.CreationDateDesc = function (timestamp) {
  let date = new Date(timestamp);
  return date.toLocaleDateString("zh-CN", {
    timeZone: "Asia/Shanghai"
  });
}

module.exports.getQueryString = function (name, url) {
  let search = url.substr(url.indexOf("?"));
  let theRequest = new Object();
  if (search.indexOf("?") != -1) {
    let str = search.substr(1);
    strs = str.split("&");
    for (let i = 0; i < strs.length; i++) {
      theRequest[strs[i].split("=")[0]] = unescape(strs[i].split("=")[1]);
    }
  }
  return theRequest[name];
}

module.exports.getTwoTimesDiff = function (time) {//di作为一个变量传进来
  //如果时间格式是正确的，那下面这一步转化时间格式就可以不用了
  var dateEnd = new Date(time);//使用new Date
  var dateBegin = new Date();//获取当前时间
  var dateDiff = dateEnd.getTime() - dateBegin.getTime();//时间差的毫秒数
  var dayDiff = Math.floor(dateDiff / (24 * 3600 * 1000));//计算出相差天数
  // var leave1=dateDiff%(24*3600*1000)    //计算天数后剩余的毫秒数
  // var hours=Math.floor(leave1/(3600*1000))//计算出小时数
  // //计算相差分钟数
  // var leave2=leave1%(3600*1000)    //计算小时数后剩余的毫秒数
  // var minutes=Math.floor(leave2/(60*1000))//计算相差分钟数
  // //计算相差秒数
  // var leave3=leave2%(60*1000)      //计算分钟数后剩余的毫秒数
  // var seconds=Math.round(leave3/1000)
  // console.log(" 相差 "+dayDiff+"天 "+hours+"小时 "+minutes+" 分钟"+seconds+" 秒")
  // console.log(dateDiff+"时间差的毫秒数",dayDiff+"计算出相差天数",leave1+"计算天数后剩余的毫秒数"
  //     ,hours+"计算出小时数",minutes+"计算相差分钟数",seconds+"计算相差秒数");
  return dayDiff;
}