import Vuex from "vuex";
import Vue from "vue";
Vue.use(Vuex);

const store = new Vuex.Store({
  state: {
    role: 0, // 0：普通用户，1：组织管理员，2：超级管理员
    userInfo: null, // 用户信息
    serviceShopMenu: "/shop/data_service_list/5", // 服务超市侧边栏
    fwglNav: [
      ["注册发布的服务", "申请的服务", "云资源服务"], // 普通用户
      ["组织服务管理", "服务审批管理", "云资源管理"], // 组织管理员
      ["平台服务管理", "服务审批管理", "云资源管理"], // 超级管理员
    ], // 服务管理列表，onlyRead
    yyglNav: [
      ["应用仓库", "我部署的应用", "申请的应用"], // 普通用户
      ["应用仓库管理", "部署的应用", "应用审批管理"], // 组织管理员
      ["平台应用管理", "应用部署管理", "应用审批管理"], // 超级管理员
    ], // 应用管理列表，onlyRead
    shoppingCart: [], //购物车
    menuCartState: 0, //购物车操作都要修改这个值，menu监听这个值的变化实时获取购物车列表
    cartState: 0,
    znztParams: null, //智能制图传入过来的数据
    cesiumMapParams: null, //三维制图传入过来的数据
    appBuilderParams: null, //应用程序传入过来的数据
    znztIdParams: '', //智能制图服务id
    znztDetailsParams: {
      type: '',
      queryType: '',
      id: '',
    }, //智能制图服务详情id
    unreadMessageCount: 0
  },
  getters: {
    // 1：超管 2：组织管理员 3：普通用户 4：开发者
    is_admin: (state) =>
    {
      return (state.userInfo && state.userInfo.is_admin) || 3;
    },
    // 0：普通用户，1：组织管理员，2：超级管理员
    level: (state, getters) =>
    {
      if (getters.is_admin == 1) {
        return 2;
      } else if (getters.is_admin == 2) {
        return 1;
      } else {
        return 0;
      }
    },
  },
  mutations: {
    userInfofun (state, newValue)
    {
      state.userInfo = newValue;
    },
    rolefun (state, newValue)
    {
      state.role = newValue;
    },
    serviceShopMenuAct (state, newValue)
    {
      state.serviceShopMenu = newValue;
    },
    setShoppingCart (state, newValue)
    {
      state.shoppingCart = newValue;
    },
    setMenuCartState (state)
    {
      state.menuCartState++;
    },
    setCartState (state)
    {
      state.cartState++;
    },
    setZnztParams (state, newValue)
    {
      state.znztParams = newValue;
    },
    setCesiumMapParams (state, newValue)
    {
      state.cesiumMapParams = newValue;
    },
    setAppBuilderParams (state, newValue)
    {
      state.appBuilderParams = newValue;
    },
    setZnztIdParams (state, newValue)
    {
      state.znztIdParams = newValue;
    },
    setZnztDetailsParams (state, newValue)
    {
      state.znztDetailsParams = newValue;
    },
    setUnreadMessageCount (state, newValue)
    {
      state.unreadMessageCount = newValue;
    },
  },
});

export default store;
