# awecloud

> A Vue.js project

## Build Setup

``` bash
# install dependencies
yarn install

# serve with hot reload at localhost:8080
yarn run dev

# build for production with minification
yarn run build
```

# 使用

## 修改config/index.js
```javascript
build: {
  // Template for index.html
  index: path.resolve(__dirname, '../dist', 'awecloud', 'ui', 'index.html'),

  // Paths
  assetsRoot: path.resolve(__dirname, '../dist', 'awecloud', 'ui'),
  assetsSubDirectory: 'static',
  assetsPublicPath: '/awecloud/ui/',
}
```

## 修改build/dockerfile
```
ADD ./dist /www
ADD ./build/conf.yaml /etc/awecloud/conf.yaml
```

## 修改.drone.yml
```
略
```

## googlefonts本地化
```bash
# index.html
- <link href='https://fonts.googleapis.com/css?family=Roboto:300,400,500,700|Material+Icons' rel="stylesheet">

# src/assets/css
add googlefonts.css googlefonts

# src/main.js
+ import "@src/assets/css/googlefonts.css";
```

## add IE11 support
```bash
# src/main.js
+ import "babel-polyfill";

# package.json
yarn add babel-polyfill
```

## remove overflow-y
```bash
# index.html
+  <style>
+    html {
+      overflow-y: auto
+    }
+  </style>
```
