import Vuex from "vuex";
import Vue from "vue";
Vue.use(Vuex);

const store = new Vuex.Store({
  state: {
    role: 2, // 0：普通用户，1：组织管理员，2：超级管理员
    serviceShopMenu: "/shop/data_service_list", // 服务超市侧边栏
    fwglNav: [
      ["注册发布的服务", "申请的服务" /* , "云资源服务" */], // 普通用户
      ["组织服务管理", "服务审批管理" /* , "云资源管理" */], // 组织管理员
      ["平台服务管理", "服务审批管理" /* , "云资源管理" */], // 超级管理员
    ], // 服务管理列表，onlyRead
    yyglNav: [
      ["应用仓库", "我部署的应用", "申请的应用", "审批的应用"], // 普通用户
      ["应用仓库管理", "部署的应用", "应用审批管理"], // 组织管理员
      ["平台应用管理", "应用部署管理", "应用审批管理"], // 超级管理员
    ], // 应用管理列表，onlyRead
  },
  modules: {},
  mutations: {
    rolefun(state, newValue) {
      state.role = newValue;
    },
    serviceShopMenuAct(state, newValue) {
      state.serviceShopMenu = newValue;
    },
  },
});

export default store;
