import axios from '@/request/http'; // 导入http中创建的axios实例
import qs from 'qs'; // 根据需求是否导入qs模块

const user = {
    // order
    orderList(params) {
        return axios.get(`/apaas/serviceapp/v3/order/list?filter_by=${params.select}&order_status=${params.status}&service_types=${params.types.join(',')}
&service=${params.service}&app=${params.app}&resource=${params.resource}&page=${params.page}&size=${params.limit}`);
    },
    getOrderBtnTypes() {
        return axios.get(`/apaas/serviceapp/v3/order/domains`);
    },
    delOrder(params) {
        return axios.delete(`/order/del?order_id=${params.id}`);
    },
    addServiceEvaluation(params) {
        return axios.post(`/apaas/serviceapp/v3/order/estimate`, params);
    },
    getServiceEvaluation(params) {
        return axios.get(`/apaas/serviceapp/v3/order/estimate?apply_id=${params.apply_id}`);
    },
    addAppEvaluation(params) {
        return axios.post(`/apaas/serviceapp/v3/order/appEstimate`, params);
    },
    getAppEvaluation(params) {
        return axios.get(`/apaas/serviceapp/v3/order/appEstimate?applyId=${params.apply_id}`);
    },
    getOrderDetail(params) {
        return axios.get(`/apaas/serviceapp/v3/order/orderInfo?order_id=${params.order_id}`);
    },
    getOrderUser(params) {
        return axios.get(`/apaas/serviceapp/v3/order/applyInfo?order_id=${params.order_id}`);
    },
    getOrderApproval(params) {
        return axios.get(`/apaas/serviceapp/v3/order/approval?apply_id=${params.apply_id}&kind=${params.kind}`);
    },
    cancelOrder(params) {
        return axios.get(`/order/cancel?order_id=${params.order_id}`);
    },

    // user info
    getNowUser() {
        return axios.get(`/apaas/backmgt/user/getCurrentUser`);
    },
    getUserDetail(params) {
        return axios.get(`/apaas/backmgt/user/detail/${params.id}`);
    },
    editUserPassword(params) {
        return axios.post(`/apaas/backmgt/user/password/${params.id}`, qs.stringify(params.form));
    },
}

export default user;
