/*
 * Decompiled with CFR 0.152.
 */
package com.rtdb.api.impl;

import com.rtdb.api.common.RtdbErrorParse;
import com.rtdb.api.enums.RtdbArchiveState;
import com.rtdb.api.enums.RtdbError;
import com.rtdb.api.enums.RtdbGlobalEnum;
import com.rtdb.api.enums.RtdbMsgID;
import com.rtdb.api.enums.RtdbProcessName;
import com.rtdb.api.exception.NoAuthorityException;
import com.rtdb.api.exception.UnexpectedMethodException;
import com.rtdb.api.impl.Rtdb;
import com.rtdb.api.inter.IArchive;
import com.rtdb.api.inter.IServer;
import com.rtdb.api.inter.IServerable;
import com.rtdb.api.inter.msg.ArchiveMessage;
import com.rtdb.api.model.RtdbArchiveData;
import com.rtdb.api.model.RtdbArchivePerfData;
import com.rtdb.api.model.RtdbBigJob;
import com.rtdb.api.model.RtdbBigJobName;
import com.rtdb.api.model.RtdbField;
import com.rtdb.api.model.RtdbHeaderPage;
import com.rtdb.api.msg.ArchivesProtocol21;
import com.rtdb.api.msg.ArchivesProtocol30;
import com.rtdb.api.protocol.DatagramArchive;
import com.rtdb.api.util.DateUtil;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class RtdbArchivesImpl
extends Rtdb
implements IArchive {
    private IServerable rtdbServer;
    private String version = "3";
    private ArchiveMessage proto = ArchivesProtocol21.getInstance();

    public RtdbArchivesImpl(IServerable rtdbServer) {
        this.rtdbServer = rtdbServer;
        this.init();
    }

    private void init() {
        this.version = this.rtdbServer.getConnection().getApiVersion();
        this.proto = this.version.equals("3") ? ArchivesProtocol30.getInstance() : ArchivesProtocol21.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getArchivesCount() throws NoAuthorityException, Exception {
        IServerable iServerable = this.rtdbServer;
        synchronized (iServerable) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_ARCHIVES_COUNT, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgArchivesCountFields();
            this.rtdbServer.getConnection().sendPacket(fields, true);
            List<RtdbField> rFields = this.proto.msgArchivesCountRespFields(0, 0);
            this.rtdbServer.getConnection().receivePacket(rFields, true);
            long longRet = rFields.get(RtdbGlobalEnum.FIELD_RET.getNum()).getIvalue();
            RtdbError ret = RtdbErrorParse.getRtdbError(longRet);
            int count = 0;
            if (ret.equals(RtdbError.GoE_OK)) {
                count = (int)rFields.get(RtdbGlobalEnum.FIELD_CNT.getNum()).getIvalue();
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createArchive(String path, String file, int mb_size) throws NoAuthorityException, Exception {
        if (path == null || path == null || mb_size <= 0) {
            throw new InvalidParameterException();
        }
        IServerable iServerable = this.rtdbServer;
        synchronized (iServerable) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_CREATE_ARCHIVE, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgCreateArchiveFields(path, file, mb_size);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            List<RtdbField> rFields = this.proto.msgCreateArchiveRespFields(0);
            this.rtdbServer.getConnection().receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createRangedArchive(Date begin, Date end, String path, String file, int mb_size) throws UnexpectedMethodException, Exception {
        int datetime1 = 0;
        int datetime2 = 0;
        if (begin != null) {
            datetime1 = DateUtil.getSecond(begin);
        }
        if (end != null) {
            datetime2 = DateUtil.getSecond(end);
        }
        if (path == null || path == null || mb_size <= 0) {
            throw new InvalidParameterException();
        }
        IServerable iServerable = this.rtdbServer;
        synchronized (iServerable) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_CREATE_RANGED_ARCHIVE, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgCreateRangedArchiveFields(datetime1, datetime2, path, file, mb_size);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            List<RtdbField> rFields = this.proto.msgCreateRangedArchiveRespFields(0);
            this.rtdbServer.getConnection().receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendArchive(String path, String file, RtdbArchiveState state) throws NoAuthorityException, Exception {
        if (path == null || path == null || state.getNum() == 0) {
            throw new InvalidParameterException();
        }
        IServerable iServerable = this.rtdbServer;
        synchronized (iServerable) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_APPEND_ARCHIVE, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgAppendArchiveFields(path, file, state.getNum());
            this.rtdbServer.getConnection().sendPacket(fields, false);
            List<RtdbField> rFields = this.proto.msgAppendArchiveRespFields(0);
            this.rtdbServer.getConnection().receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeArchive(String path, String file) throws NoAuthorityException, Exception {
        if (path == null || path == null) {
            throw new InvalidParameterException();
        }
        IServerable iServerable = this.rtdbServer;
        synchronized (iServerable) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_REMOVE_ARCHIVE, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgRemoveArchiveFields(path, file);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            List<RtdbField> rFields = this.proto.msgRemoveArchiveRespFields(0);
            this.rtdbServer.getConnection().receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shiftActived() throws NoAuthorityException, Exception {
        IServerable iServerable = this.rtdbServer;
        synchronized (iServerable) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_SHIFT_ACTIVED, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgShiftActivedFields();
            this.rtdbServer.getConnection().sendPacket(fields, false);
            List<RtdbField> rFields = this.proto.msgShiftActivedRespFields(0);
            this.rtdbServer.getConnection().receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reactiveArchive(String path, String file) throws NoAuthorityException, Exception {
        if (this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876\u951b\ufffd");
        }
        if (path == null || path == null) {
            throw new InvalidParameterException();
        }
        IServerable iServerable = this.rtdbServer;
        synchronized (iServerable) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_REACTIVE_ARCHIVE, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgReactiveArchiveFields(path, file);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            List<RtdbField> rFields = this.proto.msgReactiveArchiveRespFields(0);
            this.rtdbServer.getConnection().receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbArchiveData getFirstArchive() throws NoAuthorityException, Exception {
        IServerable iServerable = this.rtdbServer;
        synchronized (iServerable) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_FIRST_ARCHIVE, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgGetFirstArchiveFields();
            this.rtdbServer.getConnection().sendPacket(fields, false);
            List<RtdbField> rFields = this.proto.msgGetFirstArchiveRespFields(0, "", "", 0);
            this.rtdbServer.getConnection().receivePacket(rFields, false);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            RtdbArchiveData archive = new RtdbArchiveData();
            if (this.version.equals("3")) {
                DatagramArchive.datagram_get_first_archive_resp.Builder build = DatagramArchive.datagram_get_first_archive_resp.newBuilder();
                RtdbField rfield = rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] bts = (byte[])rfield.getData();
                build.mergeFrom(bts, 4, bts.length - 8);
                archive.setFile(build.getFileName().toStringUtf8());
                archive.setPath(build.getPath().toStringUtf8());
                archive.setState(RtdbArchiveState.parse(build.getFileState()));
            } else {
                int FIELD_STATE = 16;
                int FIELD_PATH = FIELD_STATE + 2;
                int FIELD_FILE = FIELD_PATH + 2;
                int state = (int)rFields.get(FIELD_STATE).getIvalue();
                String path = rFields.get(FIELD_PATH).getData().toString();
                String file = rFields.get(FIELD_FILE).getData().toString();
                archive.setFile(file);
                archive.setPath(path);
                archive.setState(RtdbArchiveState.parse(state));
            }
            return archive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbArchiveData getNextArchive(String path, String file) throws NoAuthorityException, Exception {
        if (path == null || path == null) {
            throw new InvalidParameterException();
        }
        IServerable iServerable = this.rtdbServer;
        synchronized (iServerable) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_NEXT_ARCHIVE, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgGetNextArchiveFields(path, file);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            List<RtdbField> rFields = this.proto.msgGetNextArchiveRespFields(0, "", "", 0);
            this.rtdbServer.getConnection().receivePacket(rFields, false);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            RtdbArchiveData archive = new RtdbArchiveData();
            if (this.version.equals("3")) {
                DatagramArchive.datagram_get_next_archive_resp.Builder build = DatagramArchive.datagram_get_next_archive_resp.newBuilder();
                RtdbField rfield = rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] bts = (byte[])rfield.getData();
                build.mergeFrom(bts, 4, bts.length - 8);
                archive.setFile(build.getFileName().toStringUtf8());
                archive.setPath(build.getPath().toStringUtf8());
                archive.setState(RtdbArchiveState.parse(build.getFileState()));
            } else {
                int FIELD_STATE = 16;
                int FIELD_PATH = FIELD_STATE + 2;
                int FIELD_FILE = FIELD_PATH + 2;
                int state = (int)rFields.get(FIELD_STATE).getIvalue();
                path = rFields.get(FIELD_PATH).getData().toString();
                file = rFields.get(FIELD_FILE).getData().toString();
                archive.setFile(file);
                archive.setPath(path);
                archive.setState(RtdbArchiveState.parse(state));
            }
            return archive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbHeaderPage getArchiveInfo(String path, String file, int file_id) throws NoAuthorityException, Exception {
        if (path == null || path == null || file_id < 0) {
            throw new InvalidParameterException();
        }
        IServerable iServerable = this.rtdbServer;
        synchronized (iServerable) {
            RtdbHeaderPage headerPage;
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_ARCHIVE_INFO, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgGetArchiveInfoFields(path, file, file_id);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            RtdbHeaderPage rtdbHeaderPage = new RtdbHeaderPage();
            List<RtdbField> rFields = this.proto.msgGetArchiveInfoRespFields(file, rtdbHeaderPage.getIds());
            this.rtdbServer.getConnection().receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            if (this.version.equals("3")) {
                DatagramArchive.datagram_get_archive_info_resp.Builder build = DatagramArchive.datagram_get_archive_info_resp.newBuilder();
                RtdbField rfield = rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] bts = (byte[])rfield.getData();
                build.mergeFrom(bts, 4, bts.length - 8);
                byte[] myByte = build.getArchivedInfo().toByteArray();
                headerPage = RtdbHeaderPage.read30Fields(myByte, file);
            } else {
                headerPage = RtdbHeaderPage.read21Fields(rFields, file);
            }
            return headerPage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateArchive(String path, String file, int RatedCapacity, int ExCapacity, int AutoMerge, int AutoArrange) throws NoAuthorityException, Exception {
        if (path == null || path == null || RatedCapacity < 0 || ExCapacity < 0 || AutoMerge < 0 || AutoArrange < 0) {
            throw new InvalidParameterException();
        }
        IServerable iServerable = this.rtdbServer;
        synchronized (iServerable) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_UPDATE_ARCHIVE, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgUpdateArchiveFields(RatedCapacity, ExCapacity, (short)AutoMerge, (short)AutoArrange, path, file);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            List<RtdbField> rFields = this.proto.msgUpdateArchiveRespFields(0);
            this.rtdbServer.getConnection().receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeArchive(String path, String file) throws NoAuthorityException, Exception {
        if (this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876\u951b\ufffd");
        }
        if (path == null || path == null) {
            throw new InvalidParameterException();
        }
        IServerable iServerable = this.rtdbServer;
        synchronized (iServerable) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_MERGE_ARCHIVE, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgMergeArchiveFields(path, file);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            List<RtdbField> rFields = this.proto.msgMergeArchiveRespFields(0);
            this.rtdbServer.getConnection().receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void arrangeArchive(String path, String file) throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876!");
        }
        if (path == null || path == null) {
            throw new InvalidParameterException();
        }
        IServerable iServerable = this.rtdbServer;
        synchronized (iServerable) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_ARRANGE_ARCHIVE, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgArrangeArchiveFields(path, file);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            List<RtdbField> rFields = this.proto.msgArrangeArchiveRespFields(0);
            this.rtdbServer.getConnection().receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reindexArchive(String path, String file) throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876\u951b\ufffd");
        }
        if (path == null || path == null) {
            throw new InvalidParameterException();
        }
        IServerable iServerable = this.rtdbServer;
        synchronized (iServerable) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_REINDEX_ARCHIVE, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgReindexArchiveFields(path, file);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            List<RtdbField> rFields = this.proto.msgReindexArchiveRespFields(0);
            this.rtdbServer.getConnection().receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void backupArchive(String path, String file, String dest) throws NoAuthorityException, Exception {
        if (path == null || path == null) {
            throw new InvalidParameterException();
        }
        IServerable iServerable = this.rtdbServer;
        synchronized (iServerable) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_BACKUP_ARCHIVE, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgBackupArchiveFields(path, file, dest);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            List<RtdbField> rFields = this.proto.msgBackupArchiveRespFields(0);
            this.rtdbServer.getConnection().receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbBigJob queryBigJob(RtdbProcessName process) throws NoAuthorityException, Exception {
        if (process.getNum() < 0) {
            throw new InvalidParameterException();
        }
        IServerable iServerable = this.rtdbServer;
        synchronized (iServerable) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_QUERY_BIG_JOB, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgQueryBigJobFields(process.getNum());
            this.rtdbServer.getConnection().sendPacket(fields, false);
            List<RtdbField> rFields = this.proto.msgQueryBigJobRespFields(0, 0, 0, 0, 0.0f, "", "");
            this.rtdbServer.getConnection().receivePacket(rFields, false);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            RtdbBigJob bigJob = new RtdbBigJob();
            if (this.version.equals("3")) {
                DatagramArchive.datagram_query_big_job_resp.Builder build = DatagramArchive.datagram_query_big_job_resp.newBuilder();
                RtdbField rfield = rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] bts = (byte[])rfield.getData();
                build.mergeFrom(bts, 4, bts.length - 8);
                bigJob.setProcess(process);
                bigJob.setPath(build.getPath().toStringUtf8());
                bigJob.setFile(build.getFileName().toStringUtf8());
                bigJob.setJob(RtdbBigJobName.parse(build.getJobId()));
                bigJob.setState(build.getJobState());
                bigJob.setEnd_time(DateUtil.getDate(build.getJobFinishedTime(), 0));
                bigJob.setProgress(build.getJobProgress());
            } else {
                int FIELD_JOB = 16;
                int FIELD_STATE = 17;
                int FIELD_ENDT = 18;
                int FIELD_PROG = 19;
                int job = (int)rFields.get(FIELD_JOB).getIvalue();
                int state = (int)rFields.get(FIELD_STATE).getIvalue();
                int endTime = (int)rFields.get(FIELD_ENDT).getIvalue();
                float pro = (float)rFields.get(FIELD_PROG).getFvalue();
                String path = rFields.get(21).getData().toString();
                String file = rFields.get(23).getData().toString();
                bigJob.setProcess(process);
                bigJob.setPath(path);
                bigJob.setFile(file);
                bigJob.setJob(RtdbBigJobName.parse(job));
                bigJob.setState(state);
                bigJob.setEnd_time(DateUtil.getDate(endTime, 0));
                bigJob.setProgress(pro);
            }
            return bigJob;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbHeaderPage[] getArchivesInfo(String[] path, String[] file) throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876\u951b\ufffd");
        }
        if (path == null || file == null) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_ARCHIVES_INFO, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgGetArchivesInfoFields(path, file);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            List<RtdbField> respFields = this.proto.msgGetArchivesInfoRespFields();
            this.rtdbServer.getConnection().receivePacket(respFields, false);
            RtdbError ret = this.getRet(respFields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            RtdbHeaderPage[] headerPages = new RtdbHeaderPage[file.length];
            DatagramArchive.datagram_get_archives_info_resp.Builder build = DatagramArchive.datagram_get_archives_info_resp.newBuilder();
            RtdbField rfield = respFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] bts = (byte[])rfield.getData();
            build.mergeFrom(bts, 4, bts.length - 8);
            for (int i = 0; i < file.length; ++i) {
                byte[] myByte = build.getArchivedInfos(i).toByteArray();
                RtdbHeaderPage headerPage = RtdbHeaderPage.read30Fields(myByte, file[i]);
                int errors = build.getErrors(i);
                headerPage.setError(errors);
                headerPages[i] = headerPage;
            }
            return headerPages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancelBigJob(RtdbProcessName process) throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876\u951b\ufffd");
        }
        if (process.getNum() < 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_CANCEL_BIG_JOB, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgCanceBigJobFields(process.getNum());
            this.rtdbServer.getConnection().sendPacket(fields, false);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RtdbArchiveData> getArchives() throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876");
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            int count = this.getArchivesCount();
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_ARCHIVES, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgGetArchivesFields(count == 0 ? 1 : count);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            List<RtdbField> respFields = this.proto.msgGetArchivesRespFields(count);
            this.rtdbServer.getConnection().receivePacket(respFields, false);
            RtdbError ret = this.getRet(respFields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            DatagramArchive.datagram_get_archives_resp.Builder builder = DatagramArchive.datagram_get_archives_resp.newBuilder();
            RtdbField rfield = respFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] bts = (byte[])rfield.getData();
            builder.mergeFrom(bts, 4, bts.length - 8);
            ArrayList<RtdbArchiveData> list = new ArrayList<RtdbArchiveData>(count > 0 ? count : 10);
            for (int i = 0; i < count; ++i) {
                RtdbArchiveData archive = new RtdbArchiveData();
                archive.setFile(builder.getFiles(i).toStringUtf8());
                archive.setPath(builder.getPaths(i).toStringUtf8());
                archive.setState(RtdbArchiveState.parse(builder.getStates(i)));
                list.add(archive);
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean convertIndex(String path, String file) throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876\u951b\ufffd");
        }
        if (path == null || file == null || path == "" || file == "") {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_CONVERT_INDEX, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgConvertIndexFields(path, file);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            List<RtdbField> rFields = this.proto.msgConvertIndexRespFields(0);
            this.rtdbServer.getConnection().receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getArchivesStatus() throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876\u951b\ufffd");
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_ARCHIVES_STATUS, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgArchivesStatusFields();
            this.rtdbServer.getConnection().sendPacket(fields, true);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            long ivalue = fields.get(6).getIvalue();
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            return ivalue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RtdbArchivePerfData> getArchivesPerfData(String[] paths, String[] files) throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876\u951b\ufffd");
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_ARCHIVES_PERF_DATA, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgGetArchivesPerfDataFields(paths, files, paths.length);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int counts = (int)fields.get(RtdbGlobalEnum.FIELD_CNT.getNum()).getIvalue();
            List<RtdbField> respFields = this.proto.msgGetArchivesPerfDataRespFields(counts);
            this.rtdbServer.getConnection().receivePacket(respFields, false);
            RtdbError ret = this.getRet(respFields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            DatagramArchive.datagram_get_archives_perf_data_resp.Builder builder = DatagramArchive.datagram_get_archives_perf_data_resp.newBuilder();
            RtdbField rfield = respFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] buf = (byte[])rfield.getData();
            builder.mergeFrom(buf, 4, buf.length - 8);
            ArrayList<RtdbArchivePerfData> lists = new ArrayList<RtdbArchivePerfData>(counts > 0 ? counts : 10);
            for (int i = 0; i < counts; ++i) {
                byte[] totaldata = builder.getTotalDatas(i).toByteArray();
                RtdbArchivePerfData perdatatotaldata = RtdbArchivePerfData.bytesToRtdbArchivePerfData(totaldata);
                lists.add(perdatatotaldata);
            }
            return lists;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean moveArchive(String fileName, String path, String dest) throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876");
        }
        if (fileName == null && path == null && dest == null) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_ARCHIVES_PERF_DATA, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgMoveArchiveFields(fileName, path, dest);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgMoveArchiveRespFields();
            this.rtdbServer.getConnection().receivePacket(fields);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            return true;
        }
    }
}

