/*
 * Decompiled with CFR 0.152.
 */
package com.rtdb.api.impl;

import com.google.protobuf.ByteString;
import com.rtdb.api.callbackInter.RBTagsChange;
import com.rtdb.api.callbackInter.RBTagsChangeEx;
import com.rtdb.api.enums.Location;
import com.rtdb.api.enums.ModifyNamedTypeEntity;
import com.rtdb.api.enums.RTDBClass;
import com.rtdb.api.enums.RtdbError;
import com.rtdb.api.enums.RtdbGlobalEnum;
import com.rtdb.api.enums.RtdbMsgID;
import com.rtdb.api.enums.RtdbSearchSort;
import com.rtdb.api.enums.RtdbTagFieldIndex;
import com.rtdb.api.enums.RtdbType;
import com.rtdb.api.enums.SearchMask;
import com.rtdb.api.enums.TagLoadMemoryFlag;
import com.rtdb.api.enums.UserIntValue;
import com.rtdb.api.enums.UserRealValue;
import com.rtdb.api.exception.EncodePacketErrorException;
import com.rtdb.api.exception.NoAuthorityException;
import com.rtdb.api.exception.UnexpectedMethodException;
import com.rtdb.api.impl.Rtdb;
import com.rtdb.api.inter.IBase;
import com.rtdb.api.inter.IServer;
import com.rtdb.api.inter.IServerable;
import com.rtdb.api.inter.msg.BaseMessage;
import com.rtdb.api.model.NamedDataTypeField;
import com.rtdb.api.model.NamedType;
import com.rtdb.api.model.NamedTypeNameToFieldsCount;
import com.rtdb.api.model.NamedTypeNameToFieldsCountBase;
import com.rtdb.api.model.NamedTypePoint;
import com.rtdb.api.model.RtdbBasePoint;
import com.rtdb.api.model.RtdbCalcPoint;
import com.rtdb.api.model.RtdbField;
import com.rtdb.api.model.RtdbFullPoint;
import com.rtdb.api.model.RtdbMaxCalcPoint;
import com.rtdb.api.model.RtdbMinCalcPoint;
import com.rtdb.api.model.RtdbScanPoint;
import com.rtdb.api.model.RtdbTable;
import com.rtdb.api.msg.BaseProtocol21;
import com.rtdb.api.msg.BaseProtocol30;
import com.rtdb.api.protocol.DatagramBase;
import com.rtdb.api.protocol.DatagramBaseLoad;
import com.rtdb.api.util.BytesConvertUtil;
import com.rtdb.api.util.DateUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidParameterException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RtdbBaseImpl
extends Rtdb
implements IBase {
    private IServerable rtdbServer;
    private BaseMessage proto;
    private String version = "3";

    public RtdbBaseImpl(IServerable rtdbServer) {
        this.rtdbServer = rtdbServer;
        this.init();
    }

    private void init() {
        this.version = this.rtdbServer.getConnection().getApiVersion();
        this.proto = this.version.equals("3") ? BaseProtocol30.getInstance() : BaseProtocol21.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbTable appendTable(RtdbTable rtdbTable) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (rtdbTable == null) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_APPEND_TABLE, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            if (rtdbTable.getDesc() != null && rtdbTable.getDesc() != "") {
                rtdbTable.setDesc(this.subString(rtdbTable.getDesc(), 99));
            }
            if (rtdbTable.getName() != null) {
                rtdbTable.setName(this.subString(rtdbTable.getName(), 79));
            }
            List<RtdbField> fields = this.proto.msgAppendTableFields(rtdbTable.getName(), rtdbTable.getDesc(), rtdbTable.getType());
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgAppendTableRespFields(0, 0);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            if (this.version.equals("3")) {
                DatagramBase.datagram_append_table_resp.Builder builderresp = DatagramBase.datagram_append_table_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                rtdbTable.setId(builderresp.getTabid());
            } else {
                int field_id = 16;
                rtdbTable.setId((int)fields.get(field_id).getIvalue());
            }
            return rtdbTable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTablesCount() throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_TABLES_COUNT, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgTablesCountFields();
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int count = 0;
            fields = this.proto.msgTablesCountRespFields(0, count);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            count = this.getCount(fields);
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTables(int[] ids) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (ids == null || ids.length <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_TABLES, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            int count = ids.length;
            List<RtdbField> fields = this.proto.msgGetTablesFields(count);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetTablesRespFields(0, 0, ids);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            if (this.version.equals("3")) {
                DatagramBase.datagram_get_tables_resp.Builder builderresp = DatagramBase.datagram_get_tables_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                if (builderresp.getTabidsCount() > 0) {
                    List<Integer> idList = builderresp.getTabidsList();
                    for (int i = 0; i < idList.size(); ++i) {
                        ids[i] = idList.get(i);
                    }
                }
                count = builderresp.getTabidsCount();
            } else {
                count = this.getCount(fields);
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTableSizeById(int id) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (id <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_TABLE_SIZE_BY_ID, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgGetTableSizeByIdFields(id);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetTableSizeByIdRespFields(0, 0);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int count = 0;
            if (this.version.equals("3")) {
                DatagramBase.datagram_get_table_size_by_id_resp.Builder builderresp = DatagramBase.datagram_get_table_size_by_id_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                count = builderresp.getTabsize();
            } else {
                int FIELD_TABSIZE = 16;
                count = (int)fields.get(FIELD_TABSIZE).getIvalue();
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTableSizeByName(String name) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (name == null) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_TABLE_SIZE_BY_NAME, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgGetTableSizeByNameFields(name);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetTableSizeByNameRespFields(0, 0);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            int count = (int)fields.get(FIELD_CNT).getIvalue();
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbTable getTablePropertyById(int id) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (id <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_APPEND_TABLE, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgGetTablePropByIdFields(id);
            IServer iServer2 = this.rtdbServer.getConnection();
            synchronized (iServer2) {
                this.rtdbServer.getConnection().sendPacket(fields, false);
                fields = this.proto.msgGetTablePropByIdRespFields(0, "", "", 0);
                this.rtdbServer.getConnection().receivePacket(fields, true);
            }
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            RtdbTable table = null;
            if (this.version.equals("3")) {
                DatagramBase.datagram_get_table_property_by_id_resp.Builder builderresp = DatagramBase.datagram_get_table_property_by_id_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                String name = new String(builderresp.getName().toByteArray(), "GBK");
                String desc = new String(builderresp.getDesc().toByteArray(), "GBK");
                int type = builderresp.getType();
                table = new RtdbTable(id, type, name, desc);
            } else {
                int FIELD_NAME = 18;
                int FIELD_DESC = 20;
                String name = fields.get(FIELD_NAME).getData().toString();
                String desc = fields.get(FIELD_DESC).getData().toString();
                table = new RtdbTable(id, 0, name, desc);
            }
            return table;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbTable getTablePropertyByName(String name) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (name == null) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_APPEND_TABLE, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgGetTablePropByNameFields(name);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetTablePropByNameRespFields(0, 0, 0, "");
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            RtdbTable table = null;
            if (this.version.equals("3")) {
                DatagramBase.datagram_get_table_property_by_name_resp.Builder builderresp = DatagramBase.datagram_get_table_property_by_name_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                String desc = builderresp.getDesc().toString("GBK");
                int id = builderresp.getTabid();
                int type = builderresp.getType();
                table = new RtdbTable(id, type, name, desc);
            } else {
                int FIELD_ID = 16;
                int FIELD_DESC = 19;
                int id = (int)fields.get(FIELD_ID).getIvalue();
                String desc = fields.get(FIELD_DESC).getData().toString();
                table = new RtdbTable(id, 0, name, desc);
            }
            return table;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertPoint(RtdbBasePoint base, RtdbScanPoint scan, RtdbCalcPoint calc) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (base == null || base.getClassof() == RTDBClass.RTDB_SCAN && scan == null || base.getClassof() == RTDBClass.RTDB_CALC && calc == null) {
            throw new InvalidParameterException();
        }
        if (base.getDesc() != null && base.getDesc() != "") {
            base.setDesc(this.subString(base.getDesc(), 99));
        }
        if (base.getUnit() != null && base.getUnit() != "") {
            base.setUnit(this.subString(base.getUnit(), 19));
        }
        if (base.getChanger() != null && base.getChanger() != "") {
            base.setChanger(this.subString(base.getChanger(), 19));
        }
        if (base.getTag() != null && base.getTag() != "") {
            base.setTag(this.subString(base.getTag(), 79));
        }
        if (base.getCreator() != null && base.getCreator() != "") {
            base.setCreator(this.subString(base.getCreator(), 19));
        }
        if (base.getTable_dot_tag() != null && base.getTable_dot_tag() != "") {
            base.setTable_dot_tag(this.subString(base.getTable_dot_tag(), 158));
        }
        if (scan != null) {
            if (scan.getSource() != null && scan.getSource() != "") {
                scan.setSource(this.subString(scan.getSource(), 255));
            }
            if (scan.getInstrument() != null && scan.getInstrument() != "") {
                scan.setInstrument(this.subString(scan.getInstrument(), 50));
            }
        }
        if (calc != null && calc.getEquation() != null && calc.getEquation() != "") {
            calc.setEquation(this.subString(calc.getEquation(), 2036));
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_INSERT_POINT, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            RtdbBasePoint[] basePtr = new RtdbBasePoint[1];
            RtdbScanPoint[] scanPtr = new RtdbScanPoint[1];
            RtdbCalcPoint[] calcPtr = new RtdbCalcPoint[1];
            basePtr[0] = base;
            scanPtr[0] = base.getClassof() == RTDBClass.RTDB_SCAN ? scan : null;
            calcPtr[0] = base.getClassof() == RTDBClass.RTDB_CALC ? calc : null;
            List<RtdbField> fields = this.proto.msgInsertPointFields(true, basePtr, scanPtr, calcPtr);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgInsertPointRespFields(0, 0);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            if (this.version.equals("3")) {
                DatagramBase.datagram_insert_point_resp.Builder builder = DatagramBase.datagram_insert_point_resp.newBuilder();
                RtdbField rfield = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])rfield.getData();
                builder.mergeFrom(buf, 4, buf.length - 8);
                int rid = builder.getId();
                base.setId(rid);
            } else {
                int field_id = 16;
                int id = (int)fields.get(field_id).getIvalue();
                base.setId(id);
                if (scan != null) {
                    scan.setId(id);
                }
                if (calc != null) {
                    calc.setId(id);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int insertBasePoint(String tag, RtdbType rtdbType, int tableId, boolean useMs) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (tag == null || rtdbType == null || tableId <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_INSERT_BASE_POINT, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgInsertBasePointFields(tag, rtdbType, tableId, useMs);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgInsertBasePointRespFields(0, 0);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int id = 0;
            if (this.version.equals("3")) {
                DatagramBase.datagram_insert_base_point_resp.Builder builderresp = DatagramBase.datagram_insert_base_point_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                id = builderresp.getId();
            } else {
                int FIELD_ID = RtdbGlobalEnum.FIELD_NEXT.getNum();
                id = (int)fields.get(FIELD_ID).getIvalue();
            }
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePointById(int id) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (id <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_REMOVE_POINT_BY_ID, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgRemovePointByIdFields(id);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgRemovePointByIdRespFields(0);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePointByName(String tableDotTag) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (tableDotTag == null) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_REMOVE_POINT_BY_NAME, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgRemovePointByNameFields(tableDotTag);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgRemovePointByNameRespFields(0);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPointsProperty(int count, RtdbBasePoint[] bases, RtdbScanPoint[] scans, RtdbCalcPoint[] calcs, int[] errors) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (count <= 0 || bases == null || errors == null) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_POINTS_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            int flag = 0;
            if (scans != null) {
                flag |= RTDBClass.RTDB_SCAN.getNum();
            }
            if (calcs != null) {
                flag |= RTDBClass.RTDB_CALC.getNum();
            }
            int[] ids = new int[bases.length];
            for (int i = 0; i < bases.length; ++i) {
                ids[i] = bases[i].getId();
            }
            List<RtdbField> fields = this.proto.msgGetPointsPropFields(count, ids);
            int field_int4 = 11;
            fields.get(field_int4).setIvalue(flag);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetPointsPropRespFields(true, 0, 0, 0, bases, scans, calcs, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK && ret != RtdbError.GoE_FALSE) {
                throw new Exception(ret.getErrmsg());
            }
            if (this.version.equals("3")) {
                DatagramBase.datagram_get_points_property_resp.Builder builderresp = DatagramBase.datagram_get_points_property_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<ByteString> listbase = builderresp.getBaseList();
                List<ByteString> listcalc = builderresp.getCalcList();
                List<ByteString> listscan = builderresp.getScanList();
                for (int i = 0; i < count; ++i) {
                    byte[] baseBytes = listbase.get(i).toByteArray();
                    bases[i] = RtdbBasePoint.bytesToBasePoint(baseBytes);
                    byte[] scanBytes = listscan.get(i).toByteArray();
                    scans[i] = RtdbScanPoint.bytesToScanPoint(scanBytes);
                    byte[] calcBytes = listcalc.get(i).toByteArray();
                    calcs[i] = RtdbCalcPoint.bytesToCalcPoint(calcBytes);
                }
                List<Integer> listerror = builderresp.getErrorsList();
                for (int i = 0; i < listerror.size(); ++i) {
                    errors[i] = listerror.get(i);
                }
                count = this.getCount(fields);
            } else {
                count = this.getCount(fields);
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int search(String tagmask, String tablemask, String source, String unit, String desc, String instrument, RtdbSearchSort mode, int[] ids, int count) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (mode == null || ids == null || count <= 0) {
            throw new InvalidParameterException();
        }
        if (tagmask == null) {
            tagmask = "";
        } else if (tagmask.length() >= 79) {
            tagmask = tagmask.substring(0, 78);
        }
        if (tablemask == null) {
            tablemask = "";
        } else if (tablemask.length() >= 79) {
            tablemask = tablemask.substring(0, 78);
        }
        if (source == null) {
            source = "";
        } else if (source.length() >= 255) {
            source = source.substring(0, 254);
        }
        if (unit == null) {
            unit = "";
        } else if (unit.length() >= 19) {
            unit = unit.substring(0, 18);
        }
        if (desc == null) {
            desc = "";
        } else if (desc.length() >= 99) {
            desc = desc.substring(0, 98);
        }
        if (instrument == null) {
            instrument = "";
        } else if (instrument.length() >= 50) {
            instrument = instrument.substring(0, 49);
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_SEARCH, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgSearchFields(tagmask, tablemask, desc, unit, source, instrument, mode, count);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgSearchRespFields(0, 0, ids);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int result = 0;
            if (this.version.equals("3")) {
                DatagramBase.datagram_search_resp.Builder builderresp = DatagramBase.datagram_search_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<Integer> idslist = builderresp.getIdsList();
                for (int i = 0; i < idslist.size(); ++i) {
                    ids[i] = idslist.get(i);
                }
                result = idslist.size();
            } else {
                int FIELD_CNT = 6;
                result = (int)fields.get(FIELD_CNT).getIvalue();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int searchInBatches(int start, String tagmask, String tablemask, String source, String unit, String desc, String instrument, RtdbSearchSort mode, int[] ids, int count) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (start < 0 || mode == null || ids == null || count <= 0) {
            throw new InvalidParameterException();
        }
        if (tagmask == null) {
            tagmask = "";
        } else if (tagmask.length() >= 79) {
            tagmask = tagmask.substring(0, 78);
        }
        if (tablemask == null) {
            tablemask = "";
        } else if (tablemask.length() >= 79) {
            tablemask = tablemask.substring(0, 78);
        }
        if (source == null) {
            source = "";
        } else if (source.length() >= 255) {
            source = source.substring(0, 254);
        }
        if (unit == null) {
            unit = "";
        } else if (unit.length() >= 19) {
            unit = unit.substring(0, 18);
        }
        if (desc == null) {
            desc = "";
        } else if (desc.length() >= 99) {
            desc = desc.substring(0, 98);
        }
        if (instrument == null) {
            instrument = "";
        } else if (instrument.length() >= 50) {
            instrument = instrument.substring(0, 49);
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_SEARCH, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgSearchInBatchesFields(start, tagmask, tablemask, desc, unit, source, instrument, mode, count);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgSearchInBatchesRespFields(0, 0, ids);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int result = 0;
            if (this.version.equals("3")) {
                DatagramBase.datagram_search_in_batches_resp.Builder builderresp = DatagramBase.datagram_search_in_batches_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                result = builderresp.getIdsCount();
                List<Integer> idsList = builderresp.getIdsList();
                for (int i = 0; i < idsList.size(); ++i) {
                    ids[i] = idsList.get(i);
                }
            } else {
                int FIELD_CNT = 6;
                result = (int)fields.get(FIELD_CNT).getIvalue();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTableById(int id) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (id <= 0) {
            throw new InvalidParameterException();
        }
        RtdbError ret = null;
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_REMOVE_TABLE_BY_ID, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgRemoveTableByIdFields(id);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgRemoveTableByIdRespFields(0);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            ret = this.getRet(fields);
        }
        if (ret != null && ret != RtdbError.GoE_OK) {
            throw new Exception(ret.getErrmsg());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTableByName(String name) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (name == null) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_REMOVE_TABLE_BY_NAME, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgRemoveTableByNameFields(name);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgRemoveTableByNameRespFields(0);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePointProperty(RtdbBasePoint base, RtdbScanPoint scan, RtdbCalcPoint calc) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (base == null || base.getId() <= 0) {
            throw new InvalidParameterException();
        }
        if (base.getDesc() != null && base.getDesc() != "") {
            base.setDesc(this.subString(base.getDesc(), 99));
        }
        if (base.getUnit() != null && base.getUnit() != "") {
            base.setUnit(this.subString(base.getUnit(), 19));
        }
        if (base.getChanger() != null && base.getChanger() != "") {
            base.setChanger(this.subString(base.getChanger(), 19));
        }
        if (base.getTag() != null && base.getTag() != "") {
            base.setTag(this.subString(base.getTag(), 79));
        }
        if (base.getCreator() != null && base.getCreator() != "") {
            base.setCreator(this.subString(base.getCreator(), 19));
        }
        if (base.getTable_dot_tag() != null && base.getTable_dot_tag() != "") {
            base.setTable_dot_tag(this.subString(base.getTable_dot_tag(), 158));
        }
        if (scan != null) {
            if (scan.getSource() != null && scan.getSource() != "") {
                scan.setSource(this.subString(scan.getSource(), 255));
            }
            if (scan.getInstrument() != null && scan.getInstrument() != "") {
                scan.setInstrument(this.subString(scan.getInstrument(), 50));
            }
        }
        if (calc != null && calc.getEquation() != null && calc.getEquation() != "") {
            calc.setEquation(this.subString(calc.getEquation(), 2036));
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_UPDATE_POINT_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            RtdbBasePoint[] basePtr = new RtdbBasePoint[1];
            RtdbScanPoint[] scanPtr = new RtdbScanPoint[1];
            RtdbCalcPoint[] calcPtr = new RtdbCalcPoint[1];
            basePtr[0] = base;
            scanPtr[0] = base.getClassof() == RTDBClass.RTDB_SCAN ? scan : null;
            calcPtr[0] = base.getClassof() == RTDBClass.RTDB_CALC ? calc : null;
            List<RtdbField> fields = this.proto.msgUpdatePointPropFields(true, basePtr, scanPtr, calcPtr);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgUpdatePointPropRespFields(0);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int findPoints(int count, String[] tableDotTags, int[] ids, RtdbType[] types, RTDBClass[] classof, boolean[] useMs) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (count <= 0 || tableDotTags == null || ids == null || types == null || classof == null || useMs == null) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_FIND_POINTS, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgFindPointsFields(count, tableDotTags);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int[] typesVal = new int[count];
            int[] classofVal = new int[count];
            short[] useMsVal = new short[count];
            fields = this.proto.msgFindPointsRespFields(0, 0, 0, ids, typesVal, classofVal, useMsVal);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            count = (int)fields.get(FIELD_CNT).getIvalue();
            if (count > 0) {
                if (this.version.equals("3")) {
                    DatagramBase.datagram_find_points_resp.Builder builderresp = DatagramBase.datagram_find_points_resp.newBuilder();
                    RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                    byte[] buf = (byte[])p.getData();
                    builderresp.mergeFrom(buf, 4, buf.length - 8);
                    if (count > 0) {
                        List<Integer> typeList = builderresp.getTypesList();
                        List<Integer> classofList = builderresp.getClassofList();
                        List<Integer> useList = builderresp.getMsList();
                        List<Integer> idsList = builderresp.getIdsList();
                        for (int i = 0; i < idsList.size(); ++i) {
                            types[i] = RtdbType.parse(typeList.get(i));
                            classof[i] = RTDBClass.parse(classofList.get(i));
                            useMs[i] = useList.get(i) == 1;
                            ids[i] = idsList.get(i);
                        }
                    }
                } else {
                    for (int i = 0; i < typesVal.length; ++i) {
                        types[i] = RtdbType.parse(typesVal[i]);
                        classof[i] = RTDBClass.parse(classofVal[i]);
                        useMs[i] = useMsVal[i] == 1;
                    }
                }
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sortPoints(int count, int[] ids, RtdbTagFieldIndex index, int flag) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (count <= 0 || ids == null || index == null || flag <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_SORT_POINTS, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgSortPointsFields(count, ids, index, flag);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgSortPointsRespFields(0, 0, ids);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            if (this.version.equals("3")) {
                DatagramBase.datagram_sort_points_resp.Builder builderresp = DatagramBase.datagram_sort_points_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<Integer> idslist = builderresp.getIdsList();
                for (int i = 0; i < idslist.size(); ++i) {
                    ids[i] = idslist.get(i);
                }
                count = builderresp.getIdsCount();
            } else {
                count = this.getCount(fields);
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTableName(int tabId, String name) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (tabId <= 0 || name == null) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_UPDATE_TABLE_NAME, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgUpdateTableNameFields(tabId, name);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgUpdateTableNameRespFields(0);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTableDescById(int tabId, String desc) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (tabId <= 0 || desc == null) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_UPDATE_TABLE_DESC_BY_ID, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgUpdateTableDescByIdFields(tabId, desc);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgUpdateTableDescByIdRespFields(0);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTableDescByName(String name, String desc) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (name == null || desc == null) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_UPDATE_TABLE_DESC_BY_NAME, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgUpdateTableDescByNameFields(name, desc);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgUpdateTableDescByNameRespFields(0);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recoverPoint(int tableId, int pointId) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (tableId <= 0 || pointId <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_RECOVER_POINT, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgRecoverPointFields(tableId, pointId);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgRecoverPointRespFields(0);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgePoint(int id) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (id <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_PURGE_POINT, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgPurgePointFields(id);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgPurgePointRespFields(0);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRecycledPointsCount() throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_RECYCLED_POINTS_COUNT, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgGetRecycledPointsCountFields();
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetRecycledPointsCountRespFields(0, 0);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            int count = (int)fields.get(FIELD_CNT).getIvalue();
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRecycledPoints(int[] ids, int count) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (ids == null || count <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_RECYCLED_POINTS, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgGetRecycledPointsFields(count);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetRecycledPointsRespFields(0, 0, ids);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            if (this.version.equals("3")) {
                DatagramBase.datagram_get_recycled_points_resp.Builder builderresp = DatagramBase.datagram_get_recycled_points_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<Integer> idslist = builderresp.getIdsList();
                for (int i = 0; i < idslist.size(); ++i) {
                    ids[i] = idslist.get(i);
                }
                count = builderresp.getIdsCount();
            } else {
                count = this.getCount(fields);
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int searchRecycledPoints(String tagmask, String tablemask, String source, String unit, String desc, String instrument, RtdbSearchSort mode, int[] ids, int count) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (mode == null || ids == null || count <= 0) {
            throw new InvalidParameterException();
        }
        if (tagmask == null) {
            tagmask = "";
        } else if (tagmask.length() >= 79) {
            tagmask = tagmask.substring(0, 78);
        }
        if (tablemask == null) {
            tablemask = "";
        } else if (tablemask.length() >= 79) {
            tablemask = tablemask.substring(0, 78);
        }
        if (source == null) {
            source = "";
        } else if (source.length() >= 255) {
            source = source.substring(0, 254);
        }
        if (unit == null) {
            unit = "";
        } else if (unit.length() >= 19) {
            unit = unit.substring(0, 18);
        }
        if (desc == null) {
            desc = "";
        } else if (desc.length() >= 99) {
            desc = desc.substring(0, 98);
        }
        if (instrument == null) {
            instrument = "";
        } else if (instrument.length() >= 50) {
            instrument = instrument.substring(0, 49);
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_SEARCH_RECYCLED, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgSearchRecycledFields(tagmask, tablemask, desc, unit, source, instrument, mode, count);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgSearchRecycledRespFields(0, 0, ids);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int result = 0;
            if (this.version.equals("3")) {
                DatagramBase.datagram_search_recycled_points_resp.Builder builderresp = DatagramBase.datagram_search_recycled_points_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<Integer> idslist = builderresp.getIdsList();
                for (int i = 0; i < idslist.size(); ++i) {
                    ids[i] = idslist.get(i);
                }
                result = builderresp.getIdsCount();
            } else {
                int FIELD_CNT = 6;
                result = (int)fields.get(FIELD_CNT).getIvalue();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int searchRecycledPointsInBatches(int start, String tagmask, String tablemask, String source, String unit, String desc, String instrument, RtdbSearchSort mode, int[] ids, int count) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (start < 0 || mode == null || ids == null || count <= 0) {
            throw new InvalidParameterException();
        }
        if (tagmask == null) {
            tagmask = "";
        } else if (tagmask.length() >= 79) {
            tagmask = tagmask.substring(0, 78);
        }
        if (tablemask == null) {
            tablemask = "";
        } else if (tablemask.length() >= 79) {
            tablemask = tablemask.substring(0, 78);
        }
        if (source == null) {
            source = "";
        } else if (source.length() >= 255) {
            source = source.substring(0, 254);
        }
        if (unit == null) {
            unit = "";
        } else if (unit.length() >= 19) {
            unit = unit.substring(0, 18);
        }
        if (desc == null) {
            desc = "";
        } else if (desc.length() >= 99) {
            desc = desc.substring(0, 98);
        }
        if (instrument == null) {
            instrument = "";
        } else if (instrument.length() >= 50) {
            instrument = instrument.substring(0, 49);
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_SEARCH_RECYCLED_IN_BATCHES, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgSearchRecycledInBatchesFields(start, tagmask, tablemask, desc, unit, source, instrument, mode, count);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgSearchRecycledInBatchesRespFields(0, 0, ids);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int result = 0;
            if (this.version.equals("3")) {
                DatagramBase.datagram_search_recycled_in_batches_resp.Builder builderresp = DatagramBase.datagram_search_recycled_in_batches_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<Integer> idslist = builderresp.getIdsList();
                for (int i = 0; i < idslist.size(); ++i) {
                    ids[i] = idslist.get(i);
                }
                result = builderresp.getIdsCount();
            } else {
                int FIELD_CNT = 6;
                result = (int)fields.get(FIELD_CNT).getIvalue();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbFullPoint getRecycledPointProperty(RtdbBasePoint base, RtdbScanPoint scan, RtdbCalcPoint calc) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (base == null || base.getId() <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_RECYCLED_POINT_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            int flag = 0;
            if (scan != null) {
                flag |= RTDBClass.RTDB_SCAN.getNum();
            }
            if (calc != null) {
                flag |= RTDBClass.RTDB_CALC.getNum();
            }
            List<RtdbField> fields = this.proto.msgGetRecycledPointPropFields(base.getId());
            int field_int4 = 11;
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetRecycledPointPropRespFields(false, 0, base, scan, calc);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            fields.get(field_int4).setIvalue(flag);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            RtdbFullPoint fr = null;
            if (this.version.equals("3")) {
                DatagramBase.datagram_get_recycled_point_property_resp.Builder builderresp = DatagramBase.datagram_get_recycled_point_property_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                RtdbBasePoint bytesToBasePoint = RtdbBasePoint.bytesToBasePoint(builderresp.getBase().toByteArray());
                RtdbScanPoint bytesToScanPoint = RtdbScanPoint.bytesToScanPoint(builderresp.getScan().toByteArray());
                RtdbCalcPoint bytesToCalcPoint = RtdbCalcPoint.bytesToCalcPoint(builderresp.getCalc().toByteArray());
                fr = new RtdbFullPoint();
                fr.setBasePoint(bytesToBasePoint);
                fr.setCalcPoint(bytesToCalcPoint);
                fr.setScanPoint(bytesToScanPoint);
                return fr;
            }
            RtdbFullPoint frs = new RtdbFullPoint();
            frs.setBasePoint(base);
            frs.setCalcPoint(calc);
            frs.setScanPoint(scan);
            return frs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearRecycler() throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_CLEAR_RECYCLER, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgClearRecyclerFields();
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgClearRecyclerRespFields(0);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribeTags(RBTagsChange callback) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (callback == null) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_SUBSCRIBE_TAGS, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            this.rtdbServer.getConnection().lock();
            List<RtdbField> fields = this.proto.msgSubscribeTagsFields();
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgSubscribeTagsRespFields(0);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            this.rtdbServer.getConnection().subscribeTags(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribeTagsEx(Object param, RBTagsChangeEx callback) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (callback == null) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_SUBSCRIBE_TAGS, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            this.rtdbServer.getConnection().lock();
            List<RtdbField> fields = this.proto.msgSubscribeTagsFields();
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgSubscribeTagsRespFields(0);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            this.rtdbServer.getConnection().subscribeTagsEx(param, callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelSubscribeTags() throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, InterruptedException, Exception {
        if (this.rtdbServer.getConnection().getThread() == null) {
            return;
        }
        this.rtdbServer.getConnection().cancelSubscribe();
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_CANCEL_SUBSCRIBE_TAGS, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            List<RtdbField> fields = this.proto.msgCancelSubscribeTagsFields();
            this.rtdbServer.getConnection().sendPacket(fields, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float[] getUserReal1sProperties(int[] ids) throws Exception {
        if (ids == null || ids.length <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_USERREAL1S_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            int count = ids.length;
            List<RtdbField> fields = this.proto.msgGetUserReal1sPropFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            float[] userReal1s = new float[count];
            int[] errors = new int[count];
            fields = this.proto.msgGetUserReal1sPropRespFields(0, 0, 0, userReal1s, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_userreal1s_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_userreal1s_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<Float> userReal1slist = builderresp.getUserreal1SList();
                for (int i = 0; i < userReal1s.length; ++i) {
                    userReal1s[i] = userReal1slist.get(i).floatValue();
                }
            }
            return userReal1s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float[] getUserReal2sProperties(int[] ids) throws Exception {
        if (ids == null || ids.length <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_USERREAL2S_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            int count = ids.length;
            List<RtdbField> fields = this.proto.msgGetUserReal2sPropFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            float[] userReal2s = new float[count];
            int[] errors = new int[count];
            fields = this.proto.msgGetUserReal2sPropRespFields(0, 0, 0, userReal2s, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_userreal2s_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_userreal2s_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<Float> userReal2slist = builderresp.getUserreal2SList();
                for (int i = 0; i < userReal2s.length; ++i) {
                    userReal2s[i] = userReal2slist.get(i).floatValue();
                }
            }
            return userReal2s;
        }
    }

    @Override
    public float[] getUserRealProperties(int[] ids, UserRealValue userRealValues) throws Exception {
        if (ids == null || ids.length <= 0) {
            throw new InvalidParameterException();
        }
        float[] userRealsValue = new float[ids.length];
        switch (userRealValues) {
            case UserRealFirst: {
                userRealsValue = this.getUserReal1sProperties(ids);
                break;
            }
            case UserRealSecond: {
                userRealsValue = this.getUserReal2sProperties(ids);
                break;
            }
        }
        return userRealsValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getUserInt1s(int[] ids) throws Exception {
        if (ids == null || ids.length <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_USERINT1S_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            int count = ids.length;
            List<RtdbField> fields = this.proto.msgGetUserInt1sPropFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int[] userInt1s = new int[count];
            int[] errors = new int[count];
            fields = this.proto.msgGetUserInt1sPropRespFields(0, 0, 0, userInt1s, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_userint1s_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_userint1s_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<Integer> userInt1slist = builderresp.getUserint1SList();
                for (int i = 0; i < userInt1s.length; ++i) {
                    userInt1s[i] = userInt1slist.get(i);
                }
            }
            return userInt1s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getUserInt2s(int[] ids) throws Exception {
        if (ids == null || ids.length <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_USERINT2S_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            int count = ids.length;
            List<RtdbField> fields = this.proto.msgGetUserInt2sFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int[] userInt2s = new int[count];
            int[] errors = new int[count];
            fields = this.proto.msgGetUserInt2sPropRespFields(0, 0, 0, userInt2s, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_userint2s_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_userint2s_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<Integer> userInt2slist = builderresp.getUserint2SList();
                for (int i = 0; i < userInt2s.length; ++i) {
                    userInt2s[i] = userInt2slist.get(i);
                }
            }
            return userInt2s;
        }
    }

    @Override
    public int[] getUserInts(int[] ids, UserIntValue userIntValue) throws Exception {
        if (ids == null || ids.length <= 0) {
            throw new InvalidParameterException();
        }
        int[] userIntValues = new int[ids.length];
        switch (userIntValue) {
            case UserIntFirst: {
                userIntValues = this.getUserInt1s(ids);
                break;
            }
            case UserIntSecond: {
                userIntValues = this.getUserInt2s(ids);
                break;
            }
        }
        return userIntValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getPeriodsProperties(int[] ids) throws Exception {
        if (ids == null || ids.length <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_PERIODS_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            int count = ids.length;
            List<RtdbField> fields = this.proto.msgGetPeriodsPropFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int[] periods = new int[count];
            int[] errors = new int[count];
            fields = this.proto.msgGetPeriodsPropRespFields(periods, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_periods_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_periods_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<Integer> periodsList = builderresp.getPeriodsList();
                for (int i = 0; i < builderresp.getPeriodsCount(); ++i) {
                    periods[i] = periodsList.get(i);
                }
            }
            return periods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getTimecopysProperties(int[] ids) throws Exception {
        if (ids == null || ids.length <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_TIMECOPYS_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            int count = ids.length;
            List<RtdbField> fields = this.proto.msgGetTimecopysPropFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            byte[] timeCopys = new byte[count];
            int[] errors = new int[count];
            fields = this.proto.msgGetTimecopysPropRespFields(0, count, 0, timeCopys, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_timecopys_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_timecopys_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<Integer> timeCopyslist = builderresp.getTimecopysList();
                for (int i = 0; i < timeCopys.length; ++i) {
                    timeCopys[i] = timeCopyslist.get(i).byteValue();
                }
            }
            return timeCopys;
        }
    }

    @Override
    public int[] getLocation1sProperties(int[] ids) throws Exception {
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_LOCATION1S_PROP, this.rtdbServer.getConnection().getLogin())) {
            throw new InvalidParameterException();
        }
        int count = ids.length;
        List<RtdbField> fields = this.proto.msgGetLocation1sPropFields(count, ids);
        this.rtdbServer.getConnection().sendPacket(fields, false);
        int[] location1s = new int[count];
        int[] errors = new int[count];
        fields = this.proto.msgGetLocation1sPropRespFields(0, count, 0, location1s, errors);
        this.rtdbServer.getConnection().receivePacket(fields, true);
        RtdbError ret = this.getRet(fields);
        if (ret != RtdbError.GoE_OK) {
            throw new Exception(ret.getErrmsg());
        }
        if (this.version.equals("3")) {
            DatagramBaseLoad.datagram_get_location1s_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_location1s_prpperty_resp.newBuilder();
            RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] buf = (byte[])p.getData();
            builderresp.mergeFrom(buf, 4, buf.length - 8);
            List<Integer> location1slist = builderresp.getLocation1SList();
            for (int i = 0; i < location1s.length; ++i) {
                location1s[i] = location1slist.get(i);
            }
        }
        return location1s;
    }

    @Override
    public int[] getLocation2sProperties(int[] ids) throws Exception {
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_LOCATION2S_PROP, this.rtdbServer.getConnection().getLogin())) {
            throw new InvalidParameterException();
        }
        int count = ids.length;
        List<RtdbField> fields = this.proto.msgGetLocation2sPropFields(count, ids);
        this.rtdbServer.getConnection().sendPacket(fields, false);
        int[] location2s = new int[count];
        int[] errors = new int[count];
        fields = this.proto.msgGetLocation2sPropRespFields(0, count, 0, location2s, errors);
        this.rtdbServer.getConnection().receivePacket(fields, true);
        RtdbError ret = this.getRet(fields);
        if (ret != RtdbError.GoE_OK) {
            throw new Exception(ret.getErrmsg());
        }
        if (this.version.equals("3")) {
            DatagramBaseLoad.datagram_get_location2s_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_location2s_prpperty_resp.newBuilder();
            RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] buf = (byte[])p.getData();
            builderresp.mergeFrom(buf, 4, buf.length - 8);
            List<Integer> location2slist = builderresp.getLocation2SList();
            for (int i = 0; i < location2s.length; ++i) {
                location2s[i] = location2slist.get(i);
            }
        }
        return location2s;
    }

    @Override
    public int[] getLocation3sProperties(int[] ids) throws Exception {
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_LOCATION3S_PROP, this.rtdbServer.getConnection().getLogin())) {
            throw new InvalidParameterException();
        }
        int count = ids.length;
        List<RtdbField> fields = this.proto.msgGetLocation3sPropFields(count, ids);
        this.rtdbServer.getConnection().sendPacket(fields, false);
        int[] location3s = new int[count];
        int[] errors = new int[count];
        fields = this.proto.msgGetLocation3sPropRespFields(0, count, 0, location3s, errors);
        this.rtdbServer.getConnection().receivePacket(fields, true);
        RtdbError ret = this.getRet(fields);
        if (ret != RtdbError.GoE_OK) {
            throw new Exception(ret.getErrmsg());
        }
        if (this.version.equals("3")) {
            DatagramBaseLoad.datagram_get_location3s_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_location3s_prpperty_resp.newBuilder();
            RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] buf = (byte[])p.getData();
            builderresp.mergeFrom(buf, 4, buf.length - 8);
            List<Integer> location3slist = builderresp.getLocation3SList();
            for (int i = 0; i < location3s.length; ++i) {
                location3s[i] = location3slist.get(i);
            }
        }
        return location3s;
    }

    @Override
    public int[] getLocation4sProperties(int[] ids) throws Exception {
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_LOCATION4S_PROP, this.rtdbServer.getConnection().getLogin())) {
            throw new InvalidParameterException();
        }
        int count = ids.length;
        List<RtdbField> fields = this.proto.msgGetLocation4sPropFields(count, ids);
        this.rtdbServer.getConnection().sendPacket(fields, false);
        int[] location4s = new int[count];
        int[] errors = new int[count];
        fields = this.proto.msgGetLocation4sPropRespFields(0, count, 0, location4s, errors);
        this.rtdbServer.getConnection().receivePacket(fields, true);
        RtdbError ret = this.getRet(fields);
        if (ret != RtdbError.GoE_OK) {
            throw new Exception(ret.getErrmsg());
        }
        if (this.version.equals("3")) {
            DatagramBaseLoad.datagram_get_location4s_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_location4s_prpperty_resp.newBuilder();
            RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] buf = (byte[])p.getData();
            builderresp.mergeFrom(buf, 4, buf.length - 8);
            List<Integer> location4slist = builderresp.getLocation4SList();
            for (int i = 0; i < location4s.length; ++i) {
                location4s[i] = location4slist.get(i);
            }
        }
        return location4s;
    }

    @Override
    public int[] getLocation5sProperties(int[] ids) throws Exception {
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_LOCATION5S_PROP, this.rtdbServer.getConnection().getLogin())) {
            throw new InvalidParameterException();
        }
        int count = ids.length;
        List<RtdbField> fields = this.proto.msgGetLocation5sPropFields(count, ids);
        this.rtdbServer.getConnection().sendPacket(fields, false);
        int[] location5s = new int[count];
        int[] errors = new int[count];
        fields = this.proto.msgGetLocation5sPropRespFields(0, count, 0, location5s, errors);
        this.rtdbServer.getConnection().receivePacket(fields, true);
        RtdbError ret = this.getRet(fields);
        if (ret != RtdbError.GoE_OK) {
            throw new Exception(ret.getErrmsg());
        }
        if (this.version.equals("3")) {
            DatagramBaseLoad.datagram_get_location5s_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_location5s_prpperty_resp.newBuilder();
            RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] buf = (byte[])p.getData();
            builderresp.mergeFrom(buf, 4, buf.length - 8);
            List<Integer> location5slist = builderresp.getLocation5SList();
            for (int i = 0; i < location5s.length; ++i) {
                location5s[i] = location5slist.get(i);
            }
        }
        return location5s;
    }

    @Override
    public int[] getLocationsProperties(int[] ids, Location location) throws Exception {
        if (ids == null || ids.length <= 0) {
            throw new InvalidParameterException();
        }
        int[] locations = new int[ids.length];
        switch (location) {
            case Location1: {
                locations = this.getLocation1sProperties(ids);
                break;
            }
            case Location2: {
                locations = this.getLocation2sProperties(ids);
                break;
            }
            case Location3: {
                locations = this.getLocation3sProperties(ids);
                break;
            }
            case Location4: {
                locations = this.getLocation4sProperties(ids);
                break;
            }
            case Location5: {
                locations = this.getLocation5sProperties(ids);
                break;
            }
        }
        return locations;
    }

    @Override
    public float[] getExcdevpercentsProperties(int[] ids) throws Exception {
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_EXCDEVPERCENTS_PROP, this.rtdbServer.getConnection().getLogin())) {
            throw new InvalidParameterException();
        }
        int count = ids.length;
        List<RtdbField> fields = this.proto.msgGetExcdevpercentsFields(count, ids);
        this.rtdbServer.getConnection().sendPacket(fields, false);
        float[] excdevPercents = new float[count];
        int[] errors = new int[count];
        fields = this.proto.msgGetExcdevpercentsRespFields(0, count, 0, excdevPercents, errors);
        this.rtdbServer.getConnection().receivePacket(fields, true);
        RtdbError ret = this.getRet(fields);
        if (ret != RtdbError.GoE_OK) {
            throw new Exception(ret.getErrmsg());
        }
        if (this.version.equals("3")) {
            DatagramBaseLoad.datagram_get_excdevpercents_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_excdevpercents_prpperty_resp.newBuilder();
            RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] buf = (byte[])p.getData();
            builderresp.mergeFrom(buf, 4, buf.length - 8);
            List<Float> excdevPercentslist = builderresp.getExcdevpercentsList();
            for (int i = 0; i < excdevPercents.length; ++i) {
                excdevPercents[i] = excdevPercentslist.get(i).floatValue();
            }
        }
        return excdevPercents;
    }

    @Override
    public String[] getEquationsProperties(int[] ids, int[] errors) throws Exception {
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_EQUATIONS_PROP, this.rtdbServer.getConnection().getLogin())) {
            throw new InvalidParameterException();
        }
        int count = ids.length;
        List<RtdbField> fields = this.proto.msgGetEquationsPropFields(count, ids);
        this.rtdbServer.getConnection().sendPacket(fields, false);
        String[] equations = new String[count];
        short[] lens = new short[count];
        fields = this.proto.msgGetEquationsPropRespFields(0, count, 0, lens, equations, errors);
        this.rtdbServer.getConnection().receivePacket(fields, true);
        RtdbError ret = this.getRet(fields);
        if (ret != RtdbError.GoE_OK) {
            throw new Exception(ret.getErrmsg());
        }
        if (this.version.equals("3")) {
            DatagramBaseLoad.datagram_get_equations_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_equations_prpperty_resp.newBuilder();
            RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] buf = (byte[])p.getData();
            builderresp.mergeFrom(buf, 4, buf.length - 8);
            List<ByteString> eqlist = builderresp.getEquationsList();
            List<Integer> erlist = builderresp.getErrorsList();
            for (int i = 0; i < ids.length; ++i) {
                equations[i] = eqlist.get(i).toStringUtf8();
                errors[i] = erlist.get(i);
            }
        }
        return equations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getTriggersProperties(int[] ids) throws Exception {
        if (ids == null || ids.length <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_TRIGGERS_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            int count = ids.length;
            List<RtdbField> fields = this.proto.msgGetTriggersPropFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            byte[] triggers = new byte[count];
            int[] errors = new int[count];
            fields = this.proto.msgGetTriggersPropRespFields(0, count, 0, triggers, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int field_id = 6;
            int successCount = (int)fields.get(field_id).getIvalue();
            if (successCount <= 0) {
                return null;
            }
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_triggers_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_triggers_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<Integer> triggerslist = builderresp.getTriggersList();
                for (int i = 0; i < triggers.length; ++i) {
                    triggers[i] = triggerslist.get(i).byteValue();
                }
            }
            return triggers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean[] getIsScans(int[] ids) throws Exception {
        if (ids == null || ids.length <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_SCANS_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            int count = ids.length;
            List<RtdbField> fields = this.proto.msgGetScansPropFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            byte[] scans = new byte[count];
            int[] errors = new int[count];
            fields = this.proto.msgGetScansPropRespFields(0, count, 0, scans, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            Boolean[] bools = new Boolean[count];
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_scans_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_scans_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<Integer> scanslist = builderresp.getScansList();
                for (int i = 0; i < scans.length; ++i) {
                    scans[i] = scanslist.get(i).byteValue();
                    errors[i] = builderresp.getErrors(i);
                }
            }
            BytesConvertUtil.bytesToBoolean(scans, bools);
            return bools;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getInstrumentsProperties(int[] ids) throws Exception {
        if (ids == null || ids.length <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_INSTRUMENTS_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            int count = ids.length;
            List<RtdbField> fields = this.proto.msgGetInstrumentsPropFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            String[] instruments = new String[count];
            int[] errors = new int[count];
            short[] lens = new short[count];
            fields = this.proto.msgGetInstrumentsPropRespFields(0, 0, 0, lens, instruments, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            int result = (int)fields.get(FIELD_CNT).getIvalue();
            if (result <= 0) {
                return null;
            }
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_instruments_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_instruments_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<ByteString> instrumentslist = builderresp.getInstrumentsList();
                for (int i = 0; i < instruments.length; ++i) {
                    instruments[i] = new String(instrumentslist.get(i).toByteArray(), "GBK").trim();
                }
            }
            return instruments;
        }
    }

    @Override
    public float[] getCompdevpercentsProperties(int[] ids) throws Exception {
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_COMPDEVPERCENTS_PROP, this.rtdbServer.getConnection().getLogin())) {
            throw new InvalidParameterException();
        }
        int count = ids.length;
        List<RtdbField> fields = this.proto.msgGetCompdevPercentsFields(count, ids);
        this.rtdbServer.getConnection().sendPacket(fields, false);
        float[] compdevPercents = new float[count];
        int[] errors = new int[count];
        fields = this.proto.msgGetCompdevPercentsPropRespFields(0, count, 0, compdevPercents, errors);
        this.rtdbServer.getConnection().receivePacket(fields, true);
        RtdbError ret = this.getRet(fields);
        if (ret != RtdbError.GoE_OK) {
            throw new Exception(ret.getErrmsg());
        }
        int FIELD_CNT = 6;
        int result = (int)fields.get(FIELD_CNT).getIvalue();
        if (result <= 0) {
            return null;
        }
        return compdevPercents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getSources(int[] ids) throws Exception {
        if (ids == null || ids.length <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_SOURCES_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            int count = ids.length;
            List<RtdbField> fields = this.proto.msgGetSourcesPropFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            String[] sources = new String[count];
            int[] errors = new int[count];
            short[] lens = new short[count];
            fields = this.proto.msgGetSourcesPropRespFields(0, count, 0, lens, sources, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            int result = (int)fields.get(FIELD_CNT).getIvalue();
            if (result <= 0) {
                return null;
            }
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_sources_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_sources_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<ByteString> sourceslist = builderresp.getSourcesList();
                for (int i = 0; i < sources.length; ++i) {
                    sources[i] = new String(sourceslist.get(i).toByteArray(), "GBK").trim();
                }
            }
            return sources;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float[] getTypicals(int[] ids) throws UnexpectedMethodException, Exception {
        if (ids == null || ids.length <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_TYPICALS_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            int count = ids.length;
            List<RtdbField> fields = this.proto.msgGetTypicalsPropFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            float[] typicals = new float[count];
            int[] errors = new int[count];
            fields = this.proto.msgGetTypicalsPropRespFields(0, count, 0, typicals, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            int result = (int)fields.get(FIELD_CNT).getIvalue();
            if (result <= 0) {
                return null;
            }
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_typicals_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_typicals_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<Float> typicalslist = builderresp.getTypicalsList();
                for (int i = 0; i < typicals.length; ++i) {
                    typicals[i] = typicalslist.get(i).floatValue();
                }
            }
            return typicals;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getChangeDates(int[] ids) throws Exception {
        if (ids == null || ids.length <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_CHANGEDATES_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            int count = ids.length;
            List<RtdbField> fields = this.proto.msgGetChangeDatesPropFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int[] dateTimes = new int[count];
            int[] errors = new int[count];
            fields = this.proto.msgGetChangeDatesPropRespFields(0, count, 0, dateTimes, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            int result = (int)fields.get(FIELD_CNT).getIvalue();
            if (result <= 0) {
                return null;
            }
            String[] dates = new String[result];
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_changedates_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_changedates_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<Integer> dateslist = builderresp.getChangedatesList();
                for (int i = 0; i < dateTimes.length; ++i) {
                    dateTimes[i] = dateslist.get(i);
                }
            }
            DateUtil.getDate(dates, dateTimes);
            return dates;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getCreateDates(int[] ids) throws Exception {
        if (ids == null || ids.length <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_CREATEDATES_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            int count = ids.length;
            List<RtdbField> fields = this.proto.msgGetCreatedatesPropFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int[] dateTimes = new int[count];
            int[] errors = new int[count];
            fields = this.proto.msgGetCreateDatesPropRespFields(0, count, 0, dateTimes, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            int result = (int)fields.get(FIELD_CNT).getIvalue();
            if (result <= 0) {
                return null;
            }
            String[] dates = new String[result];
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_createdates_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_createdates_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<Integer> dateslist = builderresp.getCreatedatesList();
                for (int i = 0; i < dateTimes.length; ++i) {
                    dateTimes[i] = dateslist.get(i);
                }
            }
            DateUtil.getDate(dates, dateTimes);
            return dates;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short[] getDigits(int[] ids) throws Exception {
        if (ids == null || ids.length <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_DIGITS_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            int count = ids.length;
            List<RtdbField> fields = this.proto.msgGetDigitsPropFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            short[] digits = new short[count];
            int[] errors = new int[count];
            fields = this.proto.msgGetDigitsPropRespFields(0, count, 0, digits, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            int result = (int)fields.get(FIELD_CNT).getIvalue();
            if (result <= 0) {
                return null;
            }
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_digits_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_digits_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<Integer> digitslist = builderresp.getDigitsList();
                for (int i = 0; i < digits.length; ++i) {
                    digits[i] = digitslist.get(i).shortValue();
                }
            }
            return digits;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getTableTagNames(int[] ids) throws Exception {
        if (ids == null || ids.length <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_TABLE_DOT_TAGS_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            int count = ids.length;
            List<RtdbField> fields = this.proto.msgGetTableDotTagsPropFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            String[] tableTagNames = new String[count];
            int[] errors = new int[count];
            short[] lens = new short[count];
            fields = this.proto.msgGetTableDotTagsPropRespFields(0, count, 0, lens, tableTagNames, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            int result = (int)fields.get(FIELD_CNT).getIvalue();
            if (result <= 0) {
                return null;
            }
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_dot_tags_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_dot_tags_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<ByteString> tableTagNameslist = builderresp.getDotTagsList();
                for (int i = 0; i < tableTagNames.length; ++i) {
                    tableTagNames[i] = tableTagNameslist.get(i).toString("GBK").trim();
                }
            }
            return tableTagNames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getDescs(int[] ids) throws Exception {
        if (ids == null || ids.length <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_DESCS_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            int count = ids.length;
            List<RtdbField> fields = this.proto.msgGetDescsPropFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            String[] descs = new String[count];
            int[] errors = new int[count];
            short[] lens = new short[count];
            fields = this.proto.msgGetDescsPropRespFields(0, count, 0, lens, descs, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            int result = (int)fields.get(FIELD_CNT).getIvalue();
            if (result <= 0) {
                return null;
            }
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_descs_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_descs_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<ByteString> descslist = builderresp.getDescsList();
                for (int i = 0; i < descs.length; ++i) {
                    descs[i] = descslist.get(i).toString("GBK").trim();
                }
            }
            return descs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getUnits(int[] ids) throws Exception {
        if (ids == null || ids.length <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_UNITS_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            int count = ids.length;
            List<RtdbField> fields = this.proto.msgGetUnitsPropFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            String[] units = new String[count];
            int[] errors = new int[count];
            short[] lens = new short[count];
            fields = this.proto.msgGetUnitsPropRespFields(0, count, 0, lens, units, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            int result = (int)fields.get(FIELD_CNT).getIvalue();
            if (result <= 0) {
                return null;
            }
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_units_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_units_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<ByteString> unitslist = builderresp.getUnitsList();
                for (int i = 0; i < units.length; ++i) {
                    units[i] = new String(unitslist.get(i).toByteArray(), "GBK").trim();
                    if (units[i] != null) continue;
                    return null;
                }
            }
            return units;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getChangers(int[] ids) throws Exception {
        if (ids == null || ids.length <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_CHANGERS_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            int count = ids.length;
            List<RtdbField> fields = this.proto.msgGetChangersPropFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            String[] changers = new String[count];
            int[] errors = new int[count];
            short[] lens = new short[count];
            fields = this.proto.msgGetChangersPropRespFields(0, count, 0, lens, changers, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            int result = (int)fields.get(FIELD_CNT).getIvalue();
            if (result <= 0) {
                return null;
            }
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_changers_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_changers_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<ByteString> changerslist = builderresp.getChangersList();
                for (int i = 0; i < changers.length; ++i) {
                    changers[i] = new String(changerslist.get(i).toByteArray(), "GBK").trim();
                }
            }
            return changers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getCreators(int[] ids) throws Exception {
        if (ids == null || ids.length <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_CREATORS_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            int count = ids.length;
            List<RtdbField> fields = this.proto.msgGetCreatorsPropFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            String[] creators = new String[count];
            int[] errors = new int[count];
            short[] lens = new short[count];
            fields = this.proto.msgGetCreatorsPropRespFields(0, count, 0, lens, creators, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            int result = (int)fields.get(FIELD_CNT).getIvalue();
            if (result <= 0) {
                return null;
            }
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_creators_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_creators_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<ByteString> creatorslist = builderresp.getCreatorsList();
                for (int i = 0; i < creators.length; ++i) {
                    creators[i] = new String(creatorslist.get(i).toByteArray(), "GBK").trim();
                }
            }
            return creators;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getTags(int[] ids) throws Exception {
        if (ids == null || ids.length == 0) {
            throw new InvalidParameterException();
        }
        int count = ids.length;
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_TAGS_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            List<RtdbField> fields = this.proto.msgGetTagsPropFields(ids, count);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            short[] lens = new short[count];
            String[] tags = new String[count];
            int[] errors = new int[count];
            fields = this.proto.msgGetTagsPropRespFields(count, lens, tags, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            int result = (int)fields.get(FIELD_CNT).getIvalue();
            if (result <= 0) {
                return null;
            }
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_tags_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_tags_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<ByteString> taglist = builderresp.getTagsList();
                for (int i = 0; i < builderresp.getTagsCount(); ++i) {
                    tags[i] = taglist.get(i).toString("GBK").trim();
                }
            }
            return tags;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getMs(int[] ids) throws Exception {
        if (ids == null || ids.length == 0) {
            throw new InvalidParameterException();
        }
        int count = ids.length;
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_MS_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            List<RtdbField> fields = this.proto.msgGetMsPropFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            byte[] ms = new byte[count];
            int[] errors = new int[count];
            fields = this.proto.msgGetMsPropRespFields(count, ms, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            int result = (int)fields.get(FIELD_CNT).getIvalue();
            if (result <= 0) {
                return null;
            }
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_ms_prpperty_resp.Builder builderresp1 = DatagramBaseLoad.datagram_get_ms_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp1.mergeFrom(buf, 4, buf.length - 8);
                List<Integer> mslist1 = builderresp1.getMiilisecondsList();
                for (int i = 0; i < ms.length; ++i) {
                    ms[i] = mslist1.get(i).byteValue();
                }
            }
            return ms;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getTypes(int[] ids, int[] errors) throws Exception {
        if (ids == null || ids.length == 0) {
            throw new InvalidParameterException();
        }
        int count = ids.length;
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_TYPES_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            List<RtdbField> fields = this.proto.msgGetTypesPropFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int[] types = new int[count];
            fields = this.proto.msgGetTypesPropRespFields(count, types, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            int result = (int)fields.get(FIELD_CNT).getIvalue();
            if (result <= 0) {
                return null;
            }
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_types_prpperty_resp.Builder builderresps = DatagramBaseLoad.datagram_get_types_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresps.mergeFrom(buf, 4, buf.length - 8);
                List<Integer> typeslist1 = builderresps.getTypesList();
                for (int i = 0; i < types.length; ++i) {
                    types[i] = builderresps.getErrors(i) == 0 ? typeslist1.get(i).intValue() : RtdbType.RTDB_UNKNOWTYPE.getNum();
                    errors[i] = builderresps.getErrors(i);
                }
            }
            return types;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float[] getCompdevs(int[] ids) throws Exception {
        if (ids == null || ids.length == 0) {
            throw new InvalidParameterException();
        }
        int count = ids.length;
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_COMPDEVS_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            List<RtdbField> fields = this.proto.msgGetCompdevsPropFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            float[] compdevs = new float[count];
            int[] errors = new int[count];
            fields = this.proto.msgGetCompdevsPropRespFields(count, compdevs, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            int result = (int)fields.get(FIELD_CNT).getIvalue();
            if (result <= 0) {
                return null;
            }
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_compdevs_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_compdevs_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<Float> compdevslists = builderresp.getCompdevsList();
                for (int i = 0; i < compdevs.length; ++i) {
                    compdevs[i] = compdevslists.get(i).floatValue();
                }
            }
            return compdevs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getCompmaxs(int[] ids, int[] errors) throws Exception {
        if (ids == null || ids.length == 0) {
            throw new InvalidParameterException();
        }
        int count = ids.length;
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_COMPMAXS_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            List<RtdbField> fields = this.proto.msgGetCompmaxsPropFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int[] compmaxs = new int[count];
            fields = this.proto.msgGetCompmaxsPropRespFields(count, compmaxs, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            int result = (int)fields.get(FIELD_CNT).getIvalue();
            if (result <= 0) {
                return null;
            }
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_compmaxs_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_compmaxs_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<Integer> compmaxslist1 = builderresp.getCompmaxsList();
                for (int i = 0; i < compmaxs.length; ++i) {
                    compmaxs[i] = compmaxslist1.get(i);
                    errors[i] = builderresp.getErrors(i);
                }
            }
            return compmaxs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getCompmins(int[] ids) throws Exception {
        if (ids == null || ids.length == 0) {
            throw new InvalidParameterException();
        }
        int count = ids.length;
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_COMPMINS_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            List<RtdbField> fields = this.proto.msgGetCompminsPropFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int[] compmins = new int[count];
            int[] errors = new int[count];
            fields = this.proto.msgGetCompminsPropRespFields(count, compmins, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            int result = (int)fields.get(FIELD_CNT).getIvalue();
            if (result <= 0) {
                return null;
            }
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_compmins_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_compmins_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<Integer> compminslist1 = builderresp.getCompminsList();
                for (int i = 0; i < compmins.length; ++i) {
                    compmins[i] = compminslist1.get(i);
                }
            }
            return compmins;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float[] getExcdevs(int[] ids) throws Exception {
        if (ids == null || ids.length == 0) {
            throw new InvalidParameterException();
        }
        int count = ids.length;
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_EXCDEVS_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            List<RtdbField> fields = this.proto.msgGetExcdevsPropFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            float[] excdevs = new float[count];
            int[] errors = new int[count];
            fields = this.proto.msgGetExcdevsPropRespFields(count, excdevs, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            int result = (int)fields.get(FIELD_CNT).getIvalue();
            if (result <= 0) {
                return null;
            }
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_excdevs_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_excdevs_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<Float> excdevslist = builderresp.getExcdevsList();
                for (int i = 0; i < excdevslist.size(); ++i) {
                    excdevs[i] = excdevslist.get(i).floatValue();
                }
            }
            return excdevs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getExcmaxs(int[] ids) throws Exception {
        if (ids == null || ids.length == 0) {
            throw new InvalidParameterException();
        }
        int count = ids.length;
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_EXCMAXS_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            List<RtdbField> fields = this.proto.msgGetExcmaxsPropFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int[] excmaxs = new int[count];
            int[] errors = new int[count];
            fields = this.proto.msgGetExcmaxsPropRespFields(count, excmaxs, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            int result = (int)fields.get(FIELD_CNT).getIvalue();
            if (result <= 0) {
                return null;
            }
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_excmaxs_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_excmaxs_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<Integer> excmaxslist = builderresp.getExcmaxsList();
                for (int i = 0; i < excmaxslist.size(); ++i) {
                    excmaxs[i] = excmaxslist.get(i);
                }
            }
            return excmaxs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getExcMins(int[] ids) throws UnsupportedEncodingException, IOException, ParseException, UnexpectedMethodException, Exception {
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_EXCMINS_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            int count = ids.length;
            List<RtdbField> fields = this.proto.msgGetExcminsPropFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int[] excmins = new int[count];
            int[] errors = new int[count];
            fields = this.proto.msgGetExcminsPropRespFields(0, count, 0, excmins, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            int result = (int)fields.get(FIELD_CNT).getIvalue();
            if (result <= 0) {
                return null;
            }
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_excmins_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_excmins_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<Integer> excminslist = builderresp.getExcminsList();
                for (int i = 0; i < excmins.length; ++i) {
                    excmins[i] = excminslist.get(i);
                }
            }
            return excmins;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getClassofs(int[] ids, int[] errors) throws UnsupportedEncodingException, IOException, ParseException, UnexpectedMethodException, Exception {
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_CLASSOFS_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            int count = ids.length;
            List<RtdbField> fields = this.proto.msgGetClassofsPropFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            byte[] classofs = new byte[count];
            fields = this.proto.msgGetClassofsPropRespFields(0, count, 0, classofs, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            int result = (int)fields.get(FIELD_CNT).getIvalue();
            if (result <= 0) {
                return null;
            }
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_classofs_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_classofs_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<Integer> classofslist = builderresp.getClassofsList();
                for (int i = 0; i < classofs.length; ++i) {
                    classofs[i] = classofslist.get(i).byteValue();
                    errors[i] = builderresp.getErrors(i);
                }
            }
            return classofs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short[] getTablesIds(int[] ids) throws UnsupportedEncodingException, IOException, ParseException, UnexpectedMethodException, Exception {
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_TABLES_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            int count = ids.length;
            List<RtdbField> fields = this.proto.msgGetTablesPropFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            short[] tablesIds = new short[count];
            int[] errors = new int[count];
            fields = this.proto.msgGetTablesPropRespFields(0, count, 0, tablesIds, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            int result = (int)fields.get(FIELD_CNT).getIvalue();
            if (result <= 0) {
                return null;
            }
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_tables_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_tables_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<Integer> tablesIdslist = builderresp.getTablesList();
                for (int i = 0; i < tablesIds.length; ++i) {
                    tablesIds[i] = tablesIdslist.get(i).shortValue();
                }
            }
            return tablesIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean[] getSummarys(int[] ids) throws UnsupportedEncodingException, IOException, ParseException, UnexpectedMethodException, Exception {
        if (ids == null || ids.length <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_SUMMARYS_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            int count = ids.length;
            List<RtdbField> fields = this.proto.msgGetSummarysPropFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            byte[] summarys = new byte[count];
            int[] errors = new int[count];
            fields = this.proto.msgGetSummaysPropRespFields(0, count, 0, summarys, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            int result = (int)fields.get(FIELD_CNT).getIvalue();
            if (result <= 0) {
                return null;
            }
            Boolean[] bools = new Boolean[result];
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_summarys_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_summarys_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<Integer> summaryslist = builderresp.getSummarysList();
                for (int i = 0; i < summarys.length; ++i) {
                    summarys[i] = summaryslist.get(i).byteValue();
                }
            }
            BytesConvertUtil.bytesToBoolean(summarys, bools);
            return bools;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean[] getMirrors(int[] ids) throws UnsupportedEncodingException, IOException, ParseException, UnexpectedMethodException, Exception {
        if (ids == null || ids.length <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_STEPS_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            int count = ids.length;
            List<RtdbField> fields = this.proto.msgGetMirrorsPropFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            byte[] mirrors = new byte[count];
            int[] errors = new int[count];
            fields = this.proto.msgGetMirrorsPropRespFields(0, count, 0, mirrors, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            int result = (int)fields.get(FIELD_CNT).getIvalue();
            if (result <= 0) {
                return null;
            }
            Boolean[] bools = new Boolean[result];
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_mirrors_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_mirrors_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<Integer> mirrorslist = builderresp.getMirrorsList();
                for (int i = 0; i < mirrors.length; ++i) {
                    mirrors[i] = mirrorslist.get(i).byteValue();
                }
            }
            BytesConvertUtil.bytesToBoolean(mirrors, bools);
            return bools;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean[] getSteps(int[] ids) throws UnsupportedEncodingException, IOException, ParseException, UnexpectedMethodException, Exception {
        if (ids == null || ids.length <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_STEPS_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            int count = ids.length;
            List<RtdbField> fields = this.proto.msgGetStepsPropFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            byte[] steps = new byte[count];
            int[] errors = new int[count];
            fields = this.proto.msgGetStepsPropRespFields(0, count, 0, steps, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            int result = (int)fields.get(FIELD_CNT).getIvalue();
            if (result <= 0) {
                return null;
            }
            Boolean[] bools = new Boolean[result];
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_steps_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_steps_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<Integer> stepslist = builderresp.getStepsList();
                for (int i = 0; i < steps.length; ++i) {
                    steps[i] = stepslist.get(i).byteValue();
                }
            }
            BytesConvertUtil.bytesToBoolean(steps, bools);
            return bools;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean[] getShutDowns(int[] ids) throws IOException, UnexpectedMethodException, Exception {
        if (ids == null || ids.length <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_SHUTDOWNS_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            int count = ids.length;
            List<RtdbField> fields = this.proto.msgGetShutDownsPropFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            byte[] shutdowns = new byte[count];
            int[] errors = new int[count];
            fields = this.proto.msgGetShutDownsPropRespFields(0, count, 0, shutdowns, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            int result = (int)fields.get(FIELD_CNT).getIvalue();
            if (result <= 0) {
                return null;
            }
            Boolean[] bools = new Boolean[result];
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_shutdowns_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_shutdowns_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<Integer> shutdownslist = builderresp.getShutdownsList();
                for (int i = 0; i < shutdowns.length; ++i) {
                    shutdowns[i] = shutdownslist.get(i).byteValue();
                }
            }
            BytesConvertUtil.bytesToBoolean(shutdowns, bools);
            return bools;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean[] getArchives(int[] ids) throws Exception {
        if (ids == null || ids.length <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_ARCHIVES_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            int count = ids.length;
            List<RtdbField> fields = this.proto.msgGetArchivesPropFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            byte[] archives = new byte[count];
            int[] errors = new int[count];
            fields = this.proto.msgGetArchivesPropRespFields(0, count, 0, archives, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            int result = (int)fields.get(FIELD_CNT).getIvalue();
            if (result <= 0) {
                return null;
            }
            Boolean[] bools = new Boolean[result];
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_archives_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_archives_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<Integer> archiveslist = builderresp.getArchivesList();
                for (int i = 0; i < archives.length; ++i) {
                    archives[i] = archiveslist.get(i).byteValue();
                }
            }
            BytesConvertUtil.bytesToBoolean(archives, bools);
            return bools;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float[] getLowLimits(int[] ids) throws Exception {
        if (ids == null || ids.length <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_LOWLIMITS_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            int count = ids.length;
            List<RtdbField> fields = this.proto.msgGetLowLimitsPropFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            float[] lowlimits = new float[count];
            int[] errors = new int[count];
            fields = this.proto.msgGetLowLimitsPropRespFields(0, count, 0, lowlimits, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            int result = (int)fields.get(FIELD_CNT).getIvalue();
            if (result <= 0) {
                return null;
            }
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_lowlimits_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_lowlimits_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<Float> lowlimitslist = builderresp.getLowlimitsList();
                for (int i = 0; i < lowlimits.length; ++i) {
                    lowlimits[i] = lowlimitslist.get(i).floatValue();
                }
            }
            return lowlimits;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float[] getHighLimits(int[] ids) throws Exception {
        if (ids == null || ids.length <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_HIGHLIMITS_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            int count = ids.length;
            List<RtdbField> fields = this.proto.msgGetHighlimitsPropLimits(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            float[] highlimits = new float[count];
            int[] errors = new int[count];
            fields = this.proto.msgGetHighLimitsRespFields(0, count, 0, highlimits, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            int result = (int)fields.get(FIELD_CNT).getIvalue();
            if (result <= 0) {
                return null;
            }
            if (this.version.equals("3")) {
                DatagramBaseLoad.datagram_get_highlimits_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_highlimits_prpperty_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<Float> highlimitslist = builderresp.getHighlimitsList();
                for (int i = 0; i < highlimits.length; ++i) {
                    highlimits[i] = highlimitslist.get(i).floatValue();
                }
            }
            return highlimits;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] search(String tagmask, String tablemask, String source, String unit, String desc, String instrument, String typeMaskString, int classOfMask, int timeUnitMask, int otherMaskNum, String otherTypeMaskValue, RtdbSearchSort mode, int count) throws Exception {
        if (mode == null || count <= 0) {
            throw new InvalidParameterException();
        }
        if (!(otherMaskNum >= SearchMask.SEARCH_NULL.ordinal() && otherMaskNum < SearchMask.SEARCH_SCAN_BEGIN.ordinal() || otherMaskNum > SearchMask.SEARCH_SCAN_BEGIN.ordinal() && otherMaskNum < SearchMask.SEARCH_SCAN_END.ordinal() || otherMaskNum > SearchMask.SEARCH_CALC_BEGIN.ordinal() && otherMaskNum < SearchMask.SEARCH_CALC_END.ordinal())) {
            throw new Exception(RtdbError.GoE_INVALID_SEARCH_MASK.getErrmsg());
        }
        if (tagmask == null) {
            tagmask = "";
        } else if (tagmask.length() >= 79) {
            tagmask = tagmask.substring(0, 78);
        }
        if (tablemask == null) {
            tablemask = "";
        } else if (tablemask.length() >= 79) {
            tablemask = tablemask.substring(0, 78);
        }
        if (source == null) {
            source = "";
        } else if (source.length() >= 255) {
            source = source.substring(0, 254);
        }
        if (unit == null) {
            unit = "";
        } else if (unit.length() >= 19) {
            unit = unit.substring(0, 18);
        }
        if (desc == null) {
            desc = "";
        } else if (desc.length() >= 99) {
            desc = desc.substring(0, 98);
        }
        if (instrument == null) {
            instrument = "";
        } else if (instrument.length() >= 50) {
            instrument = instrument.substring(0, 49);
        }
        if (typeMaskString == null) {
            typeMaskString = "";
        } else if (typeMaskString.length() >= 20) {
            typeMaskString = typeMaskString.substring(0, 19);
        }
        if (otherTypeMaskValue == null) {
            otherTypeMaskValue = "";
        } else if (otherTypeMaskValue.length() >= 79) {
            otherTypeMaskValue = otherTypeMaskValue.substring(0, 78);
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_SEARCH, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fieldsSend = this.proto.msgSearchExFields(tagmask, tablemask, desc, unit, source, instrument, typeMaskString, classOfMask, timeUnitMask, otherMaskNum, otherTypeMaskValue, mode, count);
            this.rtdbServer.getConnection().sendPacket(fieldsSend, false);
            int[] ids = new int[count];
            List<RtdbField> fieldsResive = this.proto.msgSearchExRespFields(0, 0, ids);
            this.rtdbServer.getConnection().receivePacket(fieldsResive, true);
            RtdbError ret = this.getRet(fieldsResive);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            count = (int)fieldsResive.get(RtdbGlobalEnum.FIELD_CNT.getNum()).getIvalue();
            ids = new int[count];
            if (count <= 0) {
                return null;
            }
            if (this.version.equals("3")) {
                DatagramBase.datagram_search_ex_resp.Builder builderresp = DatagramBase.datagram_search_ex_resp.newBuilder();
                RtdbField p = fieldsResive.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                List<Integer> idslist = builderresp.getIdsList();
                for (int i = 0; i < idslist.size(); ++i) {
                    ids[i] = idslist.get(i);
                }
            } else {
                int[] ss = (int[])fieldsResive.get(RtdbGlobalEnum.FIELD_NEXT.getNum()).getData();
                System.arraycopy(ss, 0, ids, 0, count);
            }
            return ids;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int searchPointCount(String tagmask, String tablemask, String source, String unit, String desc, String instrument, String typeMaskString, int classOfMask, int timeUnitMask, int otherMaskNum, String otherTypeMaskValue, RtdbSearchSort mode) throws Exception {
        if (mode == null) {
            throw new InvalidParameterException();
        }
        if (!(otherMaskNum >= SearchMask.SEARCH_NULL.ordinal() && otherMaskNum < SearchMask.SEARCH_SCAN_BEGIN.ordinal() || otherMaskNum > SearchMask.SEARCH_SCAN_BEGIN.ordinal() && otherMaskNum < SearchMask.SEARCH_SCAN_END.ordinal() || otherMaskNum > SearchMask.SEARCH_CALC_BEGIN.ordinal() && otherMaskNum < SearchMask.SEARCH_CALC_END.ordinal())) {
            throw new Exception(RtdbError.GoE_INVALID_SEARCH_MASK.getErrmsg());
        }
        if (tagmask == null) {
            tagmask = "";
        } else if (tagmask.length() >= 79) {
            tagmask = tagmask.substring(0, 78);
        }
        if (tablemask == null) {
            tablemask = "";
        } else if (tablemask.length() >= 79) {
            tablemask = tablemask.substring(0, 78);
        }
        if (source == null) {
            source = "";
        } else if (source.length() >= 255) {
            source = source.substring(0, 254);
        }
        if (unit == null) {
            unit = "";
        } else if (unit.length() >= 19) {
            unit = unit.substring(0, 18);
        }
        if (desc == null) {
            desc = "";
        } else if (desc.length() >= 99) {
            desc = desc.substring(0, 98);
        }
        if (instrument == null) {
            instrument = "";
        } else if (instrument.length() >= 50) {
            instrument = instrument.substring(0, 49);
        }
        if (typeMaskString == null) {
            typeMaskString = "";
        } else if (typeMaskString.length() >= 20) {
            typeMaskString = typeMaskString.substring(0, 19);
        }
        if (otherTypeMaskValue == null) {
            otherTypeMaskValue = "";
        } else if (otherTypeMaskValue.length() >= 79) {
            otherTypeMaskValue = otherTypeMaskValue.substring(0, 78);
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_SEARCH_POINTS_COUNT, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fieldsSend = this.proto.msgSearchPointCountFields(tagmask, tablemask, desc, unit, source, instrument, typeMaskString, classOfMask, timeUnitMask, otherMaskNum, otherTypeMaskValue);
            this.rtdbServer.getConnection().sendPacket(fieldsSend, false);
            List<RtdbField> fieldsResive = this.proto.msgSearchPointCountRespFields();
            this.rtdbServer.getConnection().receivePacket(fieldsResive, true);
            RtdbError ret = this.getRet(fieldsResive);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            int result = (int)fieldsResive.get(FIELD_CNT).getIvalue();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagLoadMemoryFlag[] queryLoadMemory() throws NoAuthorityException, Exception {
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_QUERY_LOAD_MEMORY, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fieldsSend = this.proto.msgQueryLoadMemoryFields();
            this.rtdbServer.getConnection().sendPacket(fieldsSend, false);
            RtdbError ret = this.getRet(fieldsSend);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            List<RtdbField> fieldsResive = this.proto.msgQueryLoadMemoryRespFields();
            this.rtdbServer.getConnection().receivePacket(fieldsResive, true);
            ret = this.getRet(fieldsSend);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            ArrayList<TagLoadMemoryFlag> result = new ArrayList<TagLoadMemoryFlag>(120);
            if (this.version.equals("3")) {
                DatagramBase.datagram_query_load_memory_resp.Builder builderresp = DatagramBase.datagram_query_load_memory_resp.newBuilder();
                RtdbField p = fieldsResive.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                int flag = builderresp.getFlag();
                for (TagLoadMemoryFlag item : TagLoadMemoryFlag.values()) {
                    if ((item.ordinal() & flag) != item.ordinal()) continue;
                    result.add(item);
                }
            } else {
                int FIELD_FLAG = 16;
                int flag = (int)fieldsResive.get(FIELD_FLAG).getIvalue();
                for (TagLoadMemoryFlag item : TagLoadMemoryFlag.values()) {
                    if ((item.getNum() & flag) != item.getNum()) continue;
                    result.add(item);
                }
            }
            return result.toArray(new TagLoadMemoryFlag[result.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setLoadMemory(TagLoadMemoryFlag[] loadMemoryFlag) throws NoAuthorityException, Exception {
        if (loadMemoryFlag == null || loadMemoryFlag.length <= 0) {
            return 0;
        }
        int flag = 0;
        for (int i = 0; i < loadMemoryFlag.length; ++i) {
            flag |= loadMemoryFlag[i].getNum();
        }
        if (flag == 0) {
            return 0;
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_SET_LOAD_MEMORY, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fieldsSend = this.proto.msgSetLoadMemoryFields(flag);
            this.rtdbServer.getConnection().sendPacket(fieldsSend, false);
            RtdbError ret = this.getRet(fieldsSend);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            List<RtdbField> fieldsResive = this.proto.msgSetLoadMemoryRespFields(flag);
            this.rtdbServer.getConnection().receivePacket(fieldsResive, true);
            ret = this.getRet(fieldsSend);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int count = 0;
            if (this.version.equals("3")) {
                DatagramBase.datagram_set_load_memory_resp.Builder builderresp = DatagramBase.datagram_set_load_memory_resp.newBuilder();
                RtdbField p = fieldsResive.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                flag = builderresp.getFlag();
                for (TagLoadMemoryFlag item : loadMemoryFlag) {
                    if (item == TagLoadMemoryFlag.LOAD_EMPTY_POINT || (item.getNum() & flag) != item.getNum()) continue;
                    ++count;
                }
            } else {
                flag = (int)fieldsResive.get(RtdbGlobalEnum.FIELD_NEXT.getNum()).getIvalue();
                for (TagLoadMemoryFlag item : loadMemoryFlag) {
                    if (item == TagLoadMemoryFlag.LOAD_EMPTY_POINT || (item.getNum() & flag) != item.getNum()) continue;
                    ++count;
                }
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long queryNeedMemorySize(TagLoadMemoryFlag[] loadMemoryFlag) throws NoAuthorityException, Exception {
        if (loadMemoryFlag == null || loadMemoryFlag.length <= 0) {
            return 0L;
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_QUERY_NEED_MEMORY_SIZE, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            int flag = 0;
            for (int i = 0; i < loadMemoryFlag.length; ++i) {
                flag |= loadMemoryFlag[i].getNum();
            }
            List<RtdbField> fieldsSend = this.proto.msgQueryNeedMemorySizeFields(flag);
            this.rtdbServer.getConnection().sendPacket(fieldsSend, false);
            RtdbError ret = this.getRet(fieldsSend);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            List<RtdbField> fieldsResive = this.proto.msgQueryNeedMemorySizeRespFields(0);
            this.rtdbServer.getConnection().receivePacket(fieldsResive, true);
            ret = this.getRet(fieldsSend);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            long size = 0L;
            if (this.version.equals("3")) {
                DatagramBase.datagram_query_need_memory_size_resp.Builder builderresp = DatagramBase.datagram_query_need_memory_size_resp.newBuilder();
                RtdbField p = fieldsResive.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                size = builderresp.getSize();
            } else {
                size = fieldsResive.get(RtdbGlobalEnum.FIELD_NEXT.getNum()).getIvalue();
            }
            return size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBaseTypePointsCount(RtdbType dateType) throws NoAuthorityException, Exception {
        if (dateType == null) {
            return 0;
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_BASE_TYPE_POINTS_COUNT, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fieldsSend = this.proto.msgGetBaseTypePointsCountFields((short)dateType.getNum());
            this.rtdbServer.getConnection().sendPacket(fieldsSend, false);
            RtdbError ret = this.getRet(fieldsSend);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            List<RtdbField> fieldsResive = this.proto.msgGetBaseTypePointsCountRespFields();
            this.rtdbServer.getConnection().receivePacket(fieldsResive, true);
            ret = this.getRet(fieldsSend);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_RET = 6;
            int count = (int)fieldsResive.get(FIELD_RET).getIvalue();
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTableRealSizeById(int id) throws IOException, EncodePacketErrorException, ParseException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876");
        }
        if (id <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_TABLE_REAL_SIZE_BY_ID, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgGetTableRealSizeByIdFields(id);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetTableRealSizeByIdRespFields(0, 0);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            DatagramBase.datagram_get_table_real_size_by_id_resp.Builder builderresp = DatagramBase.datagram_get_table_real_size_by_id_resp.newBuilder();
            RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] buf = (byte[])p.getData();
            builderresp.mergeFrom(buf, 4, buf.length - 8);
            int count = builderresp.getTabsize();
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertMaxPoint(RtdbBasePoint base, RtdbScanPoint scan, RtdbMaxCalcPoint calc) throws IOException, UnexpectedMethodException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876");
        }
        if (base == null || base.getClassof() == RTDBClass.RTDB_SCAN && scan == null || base.getClassof() == RTDBClass.RTDB_CALC && calc == null) {
            throw new InvalidParameterException();
        }
        if (base.getDesc() != null && base.getDesc() != "") {
            base.setDesc(this.subString(base.getDesc(), 99));
        }
        if (base.getUnit() != null && base.getUnit() != "") {
            base.setUnit(this.subString(base.getUnit(), 19));
        }
        if (base.getChanger() != null && base.getChanger() != "") {
            base.setChanger(this.subString(base.getChanger(), 19));
        }
        if (base.getTag() != null && base.getTag() != "") {
            base.setTag(this.subString(base.getTag(), 79));
        }
        if (base.getCreator() != null && base.getCreator() != "") {
            base.setCreator(this.subString(base.getCreator(), 19));
        }
        if (base.getTable_dot_tag() != null && base.getTable_dot_tag() != "") {
            base.setTable_dot_tag(this.subString(base.getTable_dot_tag(), 158));
        }
        if (scan != null) {
            if (scan.getSource() != null && scan.getSource() != "") {
                scan.setSource(this.subString(scan.getSource(), 255));
            }
            if (scan.getInstrument() != null && scan.getInstrument() != "") {
                scan.setInstrument(this.subString(scan.getInstrument(), 50));
            }
        }
        if (calc != null && calc.getEquation() != null && calc.getEquation() != "") {
            calc.setEquation(this.subString(calc.getEquation(), 2036));
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_INSERT_MAX_POINT, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            RtdbBasePoint[] basePtr = new RtdbBasePoint[1];
            RtdbScanPoint[] scanPtr = new RtdbScanPoint[1];
            RtdbMaxCalcPoint[] calcPtr = new RtdbMaxCalcPoint[1];
            basePtr[0] = base;
            scanPtr[0] = base.getClassof() == RTDBClass.RTDB_SCAN ? scan : null;
            calcPtr[0] = base.getClassof() == RTDBClass.RTDB_CALC ? calc : null;
            List<RtdbField> fields = this.proto.msgInsertMaxPointFields(true, basePtr, scanPtr, calcPtr);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgInsetMaxPointRespFields(0, 0);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            DatagramBase.datagram_insert_max_point_resp.Builder builder = DatagramBase.datagram_insert_max_point_resp.newBuilder();
            RtdbField rfield = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] buf = (byte[])rfield.getData();
            builder.mergeFrom(buf, 4, buf.length - 8);
            int rid = builder.getId();
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            base.setId(rid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxPointProperty(int count, RtdbBasePoint[] bases, RtdbScanPoint[] scans, RtdbMaxCalcPoint[] calcs, int[] errors) throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876");
        }
        if (count <= 0 || bases == null || errors == null) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_MAX_POINTS_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            int[] ids = new int[bases.length];
            for (int i = 0; i < bases.length; ++i) {
                ids[i] = bases[i].getId();
            }
            List<RtdbField> fields = this.proto.msgGetMaxPointsPropField(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetMaxPointsPropRespField(true, 0, 0, 0, bases, scans, calcs, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK && ret != RtdbError.GoE_FALSE) {
                throw new Exception(ret.getErrmsg());
            }
            DatagramBase.datagram_get_max_points_property_resp.Builder builderresp = DatagramBase.datagram_get_max_points_property_resp.newBuilder();
            RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] buf = (byte[])p.getData();
            builderresp.mergeFrom(buf, 4, buf.length - 8);
            List<ByteString> listbase = builderresp.getBaseList();
            List<ByteString> listcalc = builderresp.getCalcList();
            List<ByteString> listscan = builderresp.getScanList();
            for (int i = 0; i < count; ++i) {
                byte[] baseBytes = listbase.get(i).toByteArray();
                bases[i] = RtdbBasePoint.bytesToBasePoint(baseBytes);
                byte[] scanBytes = listscan.get(i).toByteArray();
                scans[i] = RtdbScanPoint.bytesToScanPoint(scanBytes);
                byte[] calcBytes = listcalc.get(i).toByteArray();
                calcs[i] = RtdbMaxCalcPoint.bytesToMaxCalcPoint(calcBytes);
            }
            List<Integer> listerror = builderresp.getErrorsList();
            for (int i = 0; i < listerror.size(); ++i) {
                errors[i] = listerror.get(i);
            }
            count = this.getCount(fields);
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbFullPoint getRecycledMaxPointProperty(int id, RtdbFullPoint point) throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876");
        }
        if (id <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_MAX_POINTS_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgGetRecycledMaxPointPropFields(id);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetRecycledMaxPointPropRespFields(false, 0, point.getBasePoint(), point.getScanPoint(), point.getMaxCalcPoint());
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbField fil = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] buf = (byte[])fil.getData();
            DatagramBase.datagram_get_recycled_max_point_property_resp.Builder builderresp = DatagramBase.datagram_get_recycled_max_point_property_resp.newBuilder();
            builderresp.mergeFrom(buf, 4, buf.length - 8);
            ByteString base2 = builderresp.getBase();
            ByteString b = builderresp.getCalc();
            ByteString scan2 = builderresp.getScan();
            point.setBasePoint(RtdbBasePoint.bytesToBasePoint(base2.toByteArray()));
            point.setMaxCalcPoint(RtdbMaxCalcPoint.bytesToMaxCalcPoint(b.toByteArray()));
            point.setScanPoint(RtdbScanPoint.bytesToScanPoint(scan2.toByteArray()));
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            return point;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNamedTypesCount() throws Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u9417\u581f\u6e70\u6d93\u5d86\u656e\u93b8\u4f7d\ue1da\u93c2\u89c4\u7876");
        }
        int count = 0;
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_NAMED_TYPES_COUNT, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            List<RtdbField> fields = this.proto.msgGetNamedTypesCountFields();
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetNamedTypesCountRespFields();
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            count = (int)fields.get(FIELD_CNT).getIvalue();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int insertNamedTypePoint(NamedTypePoint point) throws NoAuthorityException, Exception {
        if (point == null || point.getNamedTypeName() == null || point.getNamedTypeName().length() <= 0) {
            throw new InvalidParameterException();
        }
        if (point.getNamedTypeName().length() >= 20) {
            point.setNamedTypeName(point.getNamedTypeName().substring(0, 19));
        }
        this.JudgeBaseFields(point.getBasePoint());
        this.JudgeScanFields(point.getScanPoint());
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_INSERT_NAMED_TYPE_POINT, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            RtdbBasePoint[] basePtr = new RtdbBasePoint[1];
            RtdbScanPoint[] scanPtr = new RtdbScanPoint[1];
            basePtr[0] = point.getBasePoint();
            scanPtr[0] = point.getBasePoint().getClassof() == RTDBClass.RTDB_SCAN ? point.getScanPoint() : null;
            List<RtdbField> fieldsSend = this.proto.msginsertNamedTypePointFields(true, basePtr, scanPtr, point.getNamedTypeName());
            this.rtdbServer.getConnection().sendPacket(fieldsSend, false);
            RtdbError ret = this.getRet(fieldsSend);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            List<RtdbField> fieldsResive = this.proto.msginsertNamedTypePointRespFields(0, 0);
            this.rtdbServer.getConnection().receivePacket(fieldsResive, false);
            ret = this.getRet(fieldsResive);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            DatagramBase.datagram_insert_named_type_point_resp.Builder builderresp = DatagramBase.datagram_insert_named_type_point_resp.newBuilder();
            RtdbField p = fieldsResive.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] buf = (byte[])p.getData();
            builderresp.mergeFrom(buf, 4, buf.length - 8);
            int id = builderresp.getId();
            point.getBasePoint().setId(id);
            point.getScanPoint().setId(id);
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getAllNamedTypes() throws IOException, UnexpectedMethodException, Exception {
        int count = this.getNamedTypesCount();
        if (count <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_ALL_NAMED_TYPES, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            int[] fieldsCounts = new int[count];
            String[] names = new String[count];
            List<RtdbField> fields = this.proto.msgGetAllNamedTypesFields(count);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            fields = this.proto.msgGetAllNamedTypesRespFields(0, fieldsCounts, names, 0);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            DatagramBase.datagram_get_all_named_types_resp.Builder builderresp = DatagramBase.datagram_get_all_named_types_resp.newBuilder();
            RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] buf = (byte[])p.getData();
            builderresp.mergeFrom(buf, 4, buf.length - 8);
            String[] resultName = new String[count];
            for (int i = 0; i < count; ++i) {
                byte[] byt = builderresp.getNamesList().get(i).toByteArray();
                String str = new String(byt, "GBK");
                resultName[i] = str.trim();
            }
            return resultName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NamedTypeNameToFieldsCountBase> getAllNamedTypesAndFieldsCount() throws NoAuthorityException, Exception {
        int count = this.getNamedTypesCount();
        if (count <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_ALL_NAMED_TYPES, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            int[] fieldsCounts = new int[count];
            String[] names = new String[count];
            List<RtdbField> fields = this.proto.msgGetAllNamedTypesFields(count);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetAllNamedTypesRespFields(0, fieldsCounts, names, count);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int field_id = 6;
            int successCount = (int)fields.get(field_id).getIvalue();
            if (successCount <= 0) {
                return null;
            }
            DatagramBase.datagram_get_all_named_types_resp.Builder builderresp = DatagramBase.datagram_get_all_named_types_resp.newBuilder();
            RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] buf = (byte[])p.getData();
            builderresp.mergeFrom(buf, 4, buf.length - 8);
            ArrayList<NamedTypeNameToFieldsCountBase> list = new ArrayList<NamedTypeNameToFieldsCountBase>(successCount);
            NamedTypeNameToFieldsCountBase model = null;
            for (int i = 0; i < successCount; ++i) {
                model = new NamedTypeNameToFieldsCountBase();
                model.setCount(builderresp.getFieldcounts(i));
                model.setName(builderresp.getNames(i).toStringUtf8().trim());
                list.add(model);
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamedType getNamedType(String name) throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u9417\u581f\u6e70\u6d93\u5d86\u656e\u93b8\u4f7d\ue1da\u93c2\u89c4\u7876");
        }
        if (name == null || name.length() <= 0) {
            return null;
        }
        List<NamedTypeNameToFieldsCountBase> nameFieldsCount = this.getAllNamedTypesAndFieldsCount();
        if (nameFieldsCount == null || nameFieldsCount.size() <= 0) {
            return null;
        }
        int count = 0;
        for (int i = 0; i < nameFieldsCount.size(); ++i) {
            NamedTypeNameToFieldsCountBase item = nameFieldsCount.get(i);
            if (!name.trim().equals(item.getName().trim())) continue;
            count = item.getCount();
        }
        if (count <= 0) {
            return null;
        }
        if (name.length() >= 20) {
            name = name.substring(0, 254);
        }
        int tmpCount = count;
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_NAMED_TYPE, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fieldsSend = this.proto.msgGetNamedTypeFields(count, name);
            this.rtdbServer.getConnection().sendPacket(fieldsSend, false);
            RtdbError ret = this.getRet(fieldsSend);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            String desc = "";
            NamedDataTypeField[] namedFields = new NamedDataTypeField[count];
            for (int i = 0; i < count; ++i) {
                namedFields[i] = new NamedDataTypeField();
            }
            List<RtdbField> fieldsResive = this.proto.msgGetNamedTypeRespFields(count, desc, namedFields);
            this.rtdbServer.getConnection().receivePacket(fieldsResive, false);
            ret = this.getRet(fieldsResive);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            DatagramBase.datagram_get_named_type_resp.Builder builderresp = DatagramBase.datagram_get_named_type_resp.newBuilder();
            RtdbField p = fieldsResive.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] buf = (byte[])p.getData();
            builderresp.mergeFrom(buf, 4, buf.length - 8);
            String desc_result = builderresp.getDesc().toString("GBK");
            List<ByteString> list = builderresp.getFieldsList();
            ArrayList<NamedDataTypeField> nameList = new ArrayList<NamedDataTypeField>(tmpCount);
            for (int i = 0; i < count; ++i) {
                byte[] baseBytes = list.get(i).toByteArray();
                nameList.add(NamedDataTypeField.bytesToNamedDataTypeField(baseBytes));
            }
            NamedType result = new NamedType();
            result.setName(name.trim());
            result.setTypeFields(nameList);
            result.setDesc(desc_result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeNamedType(String name) throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u9417\u581f\u6e70\u6d93\u5d86\u656e\u93b8\u4f7d\ue1da\u93c2\u89c4\u7876");
        }
        if (name == null || name.length() <= 0) {
            return false;
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_REMOVE_NAMED_TYPE, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            if (name.length() >= 20) {
                name = name.substring(0, 254);
            }
            List<RtdbField> fieldsSend = this.proto.msgRemoveNamedTypeFields(name);
            this.rtdbServer.getConnection().sendPacket(fieldsSend, false);
            RtdbError ret = this.getRet(fieldsSend);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            List<RtdbField> fieldsResive = this.proto.msgRemoveNamedTypeRespFields();
            this.rtdbServer.getConnection().receivePacket(fieldsResive, false);
            ret = this.getRet(fieldsResive);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NamedTypeNameToFieldsCount> getNamedTypeNamesProperty(int[] ids) throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u9417\u581f\u6e70\u6d93\u5d86\u656e\u93b8\u4f7d\ue1da\u93c2\u89c4\u7876");
        }
        if (ids == null || ids.length <= 0) {
            return null;
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_NAMED_TYPE_NAMES_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fieldsSend = this.proto.msgGetNamedTypeNamesPropertyFields(ids);
            this.rtdbServer.getConnection().sendPacket(fieldsSend, false);
            RtdbError ret = this.getRet(fieldsSend);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int count = ids.length;
            List<RtdbField> fieldsResive = this.proto.msgGetNamedTypeNamesPropertyRespFields(count);
            this.rtdbServer.getConnection().receivePacket(fieldsResive, false);
            ret = this.getRet(fieldsSend);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            int successCount = (int)fieldsResive.get(FIELD_CNT).getIvalue();
            if (successCount <= 0) {
                return null;
            }
            DatagramBase.datagram_get_named_type_names_property_resp.Builder builderresp = DatagramBase.datagram_get_named_type_names_property_resp.newBuilder();
            RtdbField p = fieldsResive.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] buf = (byte[])p.getData();
            builderresp.mergeFrom(buf, 4, buf.length - 8);
            builderresp.getErrorsList();
            builderresp.getFieldcountsList();
            builderresp.getLensList();
            builderresp.getNamesList();
            ArrayList<NamedTypeNameToFieldsCount> result = new ArrayList<NamedTypeNameToFieldsCount>(ids.length);
            for (int i = 0; i < ids.length; ++i) {
                if (builderresp.getErrorsList().get(i) != 0) continue;
                NamedTypeNameToFieldsCount model = new NamedTypeNameToFieldsCount();
                model.setID(ids[i]);
                model.setName(builderresp.getNamesList().get(i).toStringUtf8().trim());
                model.setCount(builderresp.getFieldcountsList().get(i));
                model.setLen(builderresp.getLensList().get(i));
                result.add(model);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NamedTypeNameToFieldsCount> getRecycledNamedTypeNamesProperty(int[] ids) throws NoAuthorityException, Exception {
        if (ids == null || ids.length <= 0) {
            return null;
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_RECYCLED_NAMED_TYPE_NAMES_PROP, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fieldsSend = this.proto.msgGetRecycledNamedTypeNamesPropertyFields(ids);
            this.rtdbServer.getConnection().sendPacket(fieldsSend, false);
            int count = ids.length;
            List<RtdbField> fieldsResive = this.proto.msgGetRecycledNamedTypeNamesPropertyRespFields(count);
            this.rtdbServer.getConnection().receivePacket(fieldsResive, false);
            RtdbError ret = this.getRet(fieldsSend);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            int successCount = (int)fieldsResive.get(FIELD_CNT).getIvalue();
            if (successCount <= 0) {
                return null;
            }
            String[] resultNames = new String[count];
            int[] resultFieldCount = new int[count];
            int[] error = new int[count];
            int[] lens = new int[count];
            DatagramBase.datagram_get_recycled_named_type_names_property_resp.Builder builderresp = DatagramBase.datagram_get_recycled_named_type_names_property_resp.newBuilder();
            RtdbField p = fieldsResive.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] buf = (byte[])p.getData();
            builderresp.mergeFrom(buf, 4, buf.length - 8);
            List<Integer> lensList = builderresp.getLensList();
            for (int i = 0; i < count; ++i) {
                lens[i] = lensList.get(i);
                resultNames[i] = builderresp.getNamesList().get(i).toStringUtf8();
                error[i] = builderresp.getErrorsList().get(i);
                resultFieldCount[i] = builderresp.getFieldcountsList().get(i);
            }
            ArrayList<NamedTypeNameToFieldsCount> result = new ArrayList<NamedTypeNameToFieldsCount>(ids.length);
            for (int i = 0; i < ids.length; ++i) {
                if (error[i] != 0) continue;
                NamedTypeNameToFieldsCount model = new NamedTypeNameToFieldsCount();
                model.setID(ids[i]);
                model.setLen(lens[i]);
                model.setName(resultNames[i]);
                model.setCount(resultFieldCount[i]);
                result.add(model);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNamedTypePointsCount(String name) throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u9417\u581f\u6e70\u6d93\u5d86\u656e\u93b8\u4f7d\ue1da\u93c2\u89c4\u7876");
        }
        if (name == null || name.length() <= 0) {
            return 0;
        }
        if (name.length() >= 20) {
            name = name.substring(0, 254);
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_NAMED_TYPES_POINTS_COUNT, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fieldsSend = this.proto.msgGetNamedTypePointsCountFields(name);
            this.rtdbServer.getConnection().sendPacket(fieldsSend, false);
            RtdbError ret = this.getRet(fieldsSend);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            List<RtdbField> fieldsResive = this.proto.msgGetNamedTypePointsCountRespFields();
            this.rtdbServer.getConnection().receivePacket(fieldsResive, false);
            ret = this.getRet(fieldsSend);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_RET = 6;
            int count = (int)fieldsResive.get(FIELD_RET).getIvalue();
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean modifyNamedType(String name, String modifyName, String modifyDesc, String[] modifyFieldName, String[] modifyFieldDesc) throws IOException, UnexpectedMethodException, Exception {
        int length;
        int i;
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u9417\u581f\u6e70\u6d93\u5d86\u656e\u93b8\u4f7d\ue1da\u93c2\u89c4\u7876");
        }
        if (name == null || name.length() <= 0 || name.length() > 20) {
            throw new InvalidParameterException();
        }
        if (!(modifyName != null && modifyName.length() > 0 || modifyDesc != null && modifyDesc.length() > 0 || modifyFieldName != null && modifyFieldName.length > 0 || modifyFieldDesc != null && modifyFieldDesc.length > 0)) {
            throw new InvalidParameterException();
        }
        List<NamedTypeNameToFieldsCountBase> nameFieldsCount = this.getAllNamedTypesAndFieldsCount();
        if (nameFieldsCount == null || nameFieldsCount.size() <= 0) {
            return false;
        }
        int count = 0;
        for (int i2 = 0; i2 < nameFieldsCount.size(); ++i2) {
            NamedTypeNameToFieldsCountBase item = nameFieldsCount.get(i2);
            if (item.getName().toLowerCase().compareTo(name.toLowerCase()) != 0) continue;
            count = item.getCount();
        }
        int flag = 0;
        if (this.checkName(modifyName)) {
            flag |= 1;
        }
        if (modifyDesc != null && modifyDesc.length() > 0) {
            flag |= 2;
        }
        char[] mf_names = null;
        char[] mf_descs = null;
        if (count > 0 && modifyFieldName.length > 0) {
            int name_size = 21;
            flag |= 4;
            mf_names = new char[count * name_size];
            for (i = 0; i < count; ++i) {
                if (!this.checkName(modifyFieldName[i].trim())) {
                    return false;
                }
                length = modifyFieldName[i].length() < 20 ? modifyFieldName[i].length() : 20;
                System.arraycopy(modifyFieldName[i].toCharArray(), 0, mf_names, i * name_size, length);
            }
        }
        if (count > 0 && modifyFieldDesc != null && modifyFieldDesc.length > 0) {
            int desc_size = 100;
            flag |= 8;
            mf_descs = new char[count * desc_size];
            for (i = 0; i < count; ++i) {
                length = modifyFieldDesc[i].length() < 99 ? modifyFieldDesc[i].length() : 99;
                System.arraycopy(modifyFieldDesc[i].toCharArray(), 0, mf_descs, i * desc_size, length);
            }
        }
        String mfNames = "";
        String mfDesc = "";
        if (mf_names != null) {
            mfNames = new String(mf_names, 0, mf_names.length - 1);
        }
        if (mf_descs != null) {
            mfDesc = new String(mf_descs, 0, mf_descs.length - 1);
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_MODIFY_NAMED_TYPE, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            List<RtdbField> fields = this.proto.msgModifyNamedTypeFields(name, modifyName, modifyDesc, mfNames, mfDesc, count);
            int FIELD_INT1 = 8;
            fields.get(FIELD_INT1).setIvalue(flag);
            if ((flag & ModifyNamedTypeEntity.MODIFY_NAMED_TYPE_NAME.getNum()) == 0) {
                int Field_MODIFYNAME = 18;
                fields.get(Field_MODIFYNAME).setData(null);
                fields.get(Field_MODIFYNAME).setCount(0);
            }
            if ((flag & ModifyNamedTypeEntity.MODIFY_NAMED_TYPE_DESC.getNum()) == 0) {
                int FIELD_MODIFYDESC = 19;
                fields.get(FIELD_MODIFYDESC).setData(null);
                fields.get(FIELD_MODIFYDESC).setCount(0);
            }
            if ((flag & ModifyNamedTypeEntity.MODIFY_NAMED_TYPE_FIELD_NAME.getNum()) == 0) {
                int FIELD_MODIFYFIELDNAME = 20;
                fields.get(FIELD_MODIFYFIELDNAME).setData(null);
                fields.get(FIELD_MODIFYFIELDNAME).setCount(0);
            }
            if ((flag & ModifyNamedTypeEntity.MODIFY_NAMED_TYPE_FIELD_DESC.getNum()) == 0) {
                int FIELD_MODIFYFIELDESC = 21;
                fields.get(FIELD_MODIFYFIELDESC).setData(null);
                fields.get(FIELD_MODIFYFIELDESC).setCount(0);
            }
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgModifyNamedTypeRespFields(0);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createNamedType(String createName, String createDesc, NamedDataTypeField[] fds) throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u9417\u581f\u6e70\u6d93\u5d86\u656e\u93b8\u4f7d\ue1da\u93c2\u89c4\u7876");
        }
        int count = fds.length;
        if (createName == null || createName.length() <= 0 || fds.length <= 0 || fds == null) {
            return false;
        }
        if (createName.length() >= 20) {
            createName = this.subString(createName, 20);
        }
        if (createDesc.length() >= 99) {
            createDesc = this.subString(createDesc, 99);
        }
        for (int i = 0; i < fds.length; ++i) {
            String fieldName = fds[i].getFieldName();
            if (fieldName.length() <= 0) {
                return false;
            }
            if (fieldName.length() < 20) continue;
            fds[i].setFieldName(this.subString(fieldName, 20));
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_CREATE_NAMED_TYPE, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> field = this.proto.msgCreateNamedTypeFields(createName, createDesc, count, fds);
            this.rtdbServer.getConnection().sendPacket(field, false);
            RtdbError ret = this.getRet(field);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            List<RtdbField> fieldsResive = this.proto.msgCreateNamedTypeRespFields(0, count);
            this.rtdbServer.getConnection().receivePacket(fieldsResive, false);
            ret = this.getRet(field);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getEquationById(int id) throws Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876");
        }
        if (id <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_EQUATION_BY_ID, this.rtdbServer.getConnection().getLogin())) {
                throw new InvalidParameterException();
            }
            List<RtdbField> fields = this.proto.msgGetEquationById(id);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetEquationByIdResp(id);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_CNT = 6;
            int result = (int)fields.get(FIELD_CNT).getIvalue();
            if (result <= 0) {
                return null;
            }
            DatagramBase.datagram_get_equation_by_id_resp.Builder builderresp = DatagramBase.datagram_get_equation_by_id_resp.newBuilder();
            RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] buf = (byte[])p.getData();
            builderresp.mergeFrom(buf, 4, buf.length - 8);
            String str = builderresp.getEquation().toStringUtf8();
            return str;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getEquationsByFileName(String filename) throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876");
        }
        if (filename == null) {
            return null;
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_EQUATION_BY_FILE_NAME, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fieldsSend = this.proto.msgGetEquationByFileName(filename);
            this.rtdbServer.getConnection().sendPacket(fieldsSend, false);
            RtdbError ret = this.getRet(fieldsSend);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            List<RtdbField> fieldsResive = this.proto.msgGetEquationByFileNameResp(filename);
            this.rtdbServer.getConnection().receivePacket(fieldsResive, false);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int FIELD_RET = 6;
            int successCount = (int)fieldsResive.get(FIELD_RET).getIvalue();
            if (successCount <= 0) {
                return null;
            }
            DatagramBase.datagram_get_equation_by_file_name_resp.Builder builderresp = DatagramBase.datagram_get_equation_by_file_name_resp.newBuilder();
            RtdbField p = fieldsResive.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] buf = (byte[])p.getData();
            builderresp.mergeFrom(buf, 4, buf.length - 8);
            String str = builderresp.getEquation().toStringUtf8();
            return str;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertMinPoint(RtdbBasePoint base, RtdbScanPoint scan, RtdbMinCalcPoint calc) throws IOException, UnexpectedMethodException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bb\u7b09\u93c0\ue21b\u5bd4\u59dd\u3086\u67df\u5a09\ufffd");
        }
        if (base == null || base.getClassof() == RTDBClass.RTDB_SCAN && scan == null || base.getClassof() == RTDBClass.RTDB_CALC && calc == null) {
            throw new InvalidParameterException();
        }
        if (base.getDesc() != null && base.getDesc() != "") {
            base.setDesc(this.subString(base.getDesc(), 99));
        }
        if (base.getUnit() != null && base.getUnit() != "") {
            base.setUnit(this.subString(base.getUnit(), 19));
        }
        if (base.getChanger() != null && base.getChanger() != "") {
            base.setChanger(this.subString(base.getChanger(), 19));
        }
        if (base.getTag() != null && base.getTag() != "") {
            base.setTag(this.subString(base.getTag(), 79));
        }
        if (base.getCreator() != null && base.getCreator() != "") {
            base.setCreator(this.subString(base.getCreator(), 19));
        }
        if (base.getTable_dot_tag() != null && base.getTable_dot_tag() != "") {
            base.setTable_dot_tag(this.subString(base.getTable_dot_tag(), 158));
        }
        if (scan != null) {
            if (scan.getSource() != null && scan.getSource() != "") {
                scan.setSource(this.subString(scan.getSource(), 255));
            }
            if (scan.getInstrument() != null && scan.getInstrument() != "") {
                scan.setInstrument(this.subString(scan.getInstrument(), 50));
            }
        }
        if (calc != null && calc.getEquation() != null && calc.getEquation() != "") {
            calc.setEquation(this.subString(calc.getEquation(), 2036));
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_INSERT_MIN_POINT, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            RtdbBasePoint[] basePtr = new RtdbBasePoint[1];
            RtdbScanPoint[] scanPtr = new RtdbScanPoint[1];
            RtdbMinCalcPoint[] calcPtr = new RtdbMinCalcPoint[1];
            basePtr[0] = base;
            scanPtr[0] = base.getClassof() == RTDBClass.RTDB_SCAN ? scan : null;
            calcPtr[0] = base.getClassof() == RTDBClass.RTDB_CALC ? calc : null;
            List<RtdbField> fields = this.proto.msgInsertMinPointFields(true, basePtr, scanPtr, calcPtr);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            List<RtdbField> msgInsetMinPointRespFields = this.proto.msgInsetMinPointRespFields(0, 0);
            this.rtdbServer.getConnection().receivePacket(msgInsetMinPointRespFields, true);
            DatagramBase.datagram_insert_min_point_resp.Builder builder = DatagramBase.datagram_insert_min_point_resp.newBuilder();
            RtdbField rfield = msgInsetMinPointRespFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] buf = (byte[])rfield.getData();
            builder.mergeFrom(buf, 4, buf.length - 8);
            int rid = builder.getId();
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            base.setId(rid);
        }
    }

    @Override
    public void JudgeBaseFields(RtdbBasePoint base) throws UnsupportedEncodingException {
        if (base.getDesc() != null && base.getDesc() != "") {
            base.setDesc(this.subString(base.getDesc(), 99));
        }
        if (base.getUnit() != null && base.getUnit() != "") {
            base.setUnit(this.subString(base.getUnit(), 19));
        }
        if (base.getChanger() != null && base.getChanger() != "") {
            base.setChanger(this.subString(base.getChanger(), 19));
        }
        if (base.getTag() != null && base.getTag() != "") {
            base.setTag(this.subString(base.getTag(), 79));
        }
        if (base.getCreator() != null && base.getCreator() != "") {
            base.setCreator(this.subString(base.getCreator(), 19));
        }
        if (base.getTable_dot_tag() != null && base.getTable_dot_tag() != "") {
            base.setTable_dot_tag(this.subString(base.getTable_dot_tag(), 158));
        }
    }

    @Override
    public void JudgeScanFields(RtdbScanPoint scan) throws UnsupportedEncodingException {
        if (scan != null) {
            if (scan.getSource() != null && scan.getSource() != "") {
                scan.setSource(this.subString(scan.getSource(), 255));
            }
            if (scan.getInstrument() != null && scan.getInstrument() != "") {
                scan.setInstrument(this.subString(scan.getInstrument(), 50));
            }
        }
    }

    @Override
    public void JudgeCalcFields(RtdbCalcPoint calc) throws UnsupportedEncodingException {
        if (calc != null && calc.getEquation() != null && calc.getEquation() != "") {
            calc.setEquation(this.subString(calc.getEquation(), 2036));
        }
    }

    @Override
    public boolean checkName(String checkName) {
        Pattern pattern = Pattern.compile("^[a-zA-Z]\\w+$");
        Matcher m = pattern.matcher(checkName);
        return m.matches();
    }
}

