/*
 * Decompiled with CFR 0.152.
 */
package com.rtdb.api.impl;

import com.google.protobuf.ByteString;
import com.rtdb.api.enums.RtdbError;
import com.rtdb.api.enums.RtdbGlobalEnum;
import com.rtdb.api.enums.RtdbGraphFlag;
import com.rtdb.api.enums.RtdbMsgID;
import com.rtdb.api.exception.InvalidParameterException;
import com.rtdb.api.exception.NoAuthorityException;
import com.rtdb.api.impl.Rtdb;
import com.rtdb.api.inter.IEquation;
import com.rtdb.api.inter.IServer;
import com.rtdb.api.inter.IServerable;
import com.rtdb.api.inter.msg.EquationMessage;
import com.rtdb.api.model.MemoryStream;
import com.rtdb.api.model.RtdbField;
import com.rtdb.api.model.RtdbGraphData;
import com.rtdb.api.msg.EquationProtocol21;
import com.rtdb.api.msg.EquationProtocol30;
import com.rtdb.api.protocol.DatagramEquation;
import com.rtdb.api.util.DateUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class RtdbEquationImpl
extends Rtdb
implements IEquation {
    private IServerable rtdbServer;
    private String version = "3";
    private EquationMessage proto;

    public RtdbEquationImpl(IServerable rtdbServer) {
        this.rtdbServer = rtdbServer;
        this.init();
    }

    private void init() {
        this.version = this.rtdbServer.getConnection().getApiVersion();
        this.proto = this.version.equals("3") ? EquationProtocol30.getInstance() : EquationProtocol21.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int ComputeHistory(int count, short flag, Date beginTime, Date endTime, int[] ids, int[] errors) throws Exception {
        if (count == 0 || ids.length != count || errors.length != count) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_COMPUTE_HISTORY, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            int datetime1 = 0;
            short ms1 = 0;
            int datetime2 = 0;
            short ms2 = 0;
            datetime1 = DateUtil.getSecond(beginTime);
            ms1 = DateUtil.getMilSecond(beginTime);
            if (endTime != null) {
                datetime2 = DateUtil.getSecond(endTime);
                ms2 = DateUtil.getMilSecond(endTime);
            }
            List<RtdbField> fields = this.proto.msgComputeHistoryFields(flag, datetime1, ms1, datetime2, ms2, ids, count);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgComputeHistoryRespFields(errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            int retCount = this.getCount(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            if (this.version.equals("3")) {
                DatagramEquation.datagram_compute_history_resp.Builder builderresp = DatagramEquation.datagram_compute_history_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                builderresp.getErrorsList();
                if (builderresp.getErrorsCount() > 0) {
                    for (int i = 0; i < builderresp.getErrorsCount(); ++i) {
                        errors[i] = builderresp.getErrorsList().get(i);
                    }
                }
            }
            return retCount;
        }
    }

    @Override
    public int getEquationGraphCount(int id, RtdbGraphFlag flag) throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bb\u7b09\u93c0\ue21b\u5bd4\u59dd\u3086\u67df\u5a09\ufffd");
        }
        if (id == 0 || flag == null) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_EQUATION_GRAPH_COUNT, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgEquationGraphCountFields(id, flag);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            List<RtdbField> rfields = this.proto.msgEquationGraphCountRespFields();
            this.rtdbServer.getConnection().receivePacket(rfields, true);
            RtdbError ret = this.getRet(rfields);
            DatagramEquation.datagram_get_equation_graph_count_resp.Builder builderresp = DatagramEquation.datagram_get_equation_graph_count_resp.newBuilder();
            RtdbField p = rfields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] buf = (byte[])p.getData();
            builderresp.mergeFrom(buf, 4, buf.length - 8);
            int retCount = this.getCount(rfields);
            if (ret.equals(RtdbError.GoE_OK) || ret.equals(RtdbError.GoE_FALSE)) {
                return retCount;
            }
            throw new Exception(ret.toString());
        }
    }

    @Override
    public List<RtdbGraphData> getEquationGraphDatas(int id, RtdbGraphFlag RtdbGraphFlag2) throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876");
        }
        if (id == 0 || RtdbGraphFlag2 == null) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_EQUATION_GRAPH_COUNT, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgEquationGraphDatasFields(id, RtdbGraphFlag2);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            List<RtdbField> rfields = this.proto.msgEquationGraphDatasRespFields();
            this.rtdbServer.getConnection().receivePacket(rfields, true);
            RtdbError ret = this.getRet(rfields);
            DatagramEquation.datagram_get_equation_graph_datas_resp.Builder builderresp = DatagramEquation.datagram_get_equation_graph_datas_resp.newBuilder();
            RtdbField p = rfields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] buf = (byte[])p.getData();
            builderresp.mergeFrom(buf, 4, buf.length - 8);
            ByteString graphDatas = builderresp.getGraphDatas();
            byte[] byteArray = graphDatas.toByteArray();
            ArrayList<RtdbGraphData> list = new ArrayList<RtdbGraphData>();
            RtdbGraphData f = new RtdbGraphData();
            MemoryStream s = new MemoryStream(byteArray);
            f.setId(s.readInt());
            f.setParent_id(s.readInt());
            byte[] readBytes = s.readBytes(80);
            f.setTag(new String(readBytes, "GBK"));
            f.setError_msg(new String(s.readBytes(100), "GBK"));
            list.add(f);
            if (ret.equals(RtdbError.GoE_OK) || ret.equals(RtdbError.GoE_FALSE)) {
                return list;
            }
            throw new Exception(ret.toString());
        }
    }
}

