/*
 * Decompiled with CFR 0.152.
 */
package com.rtdb.api.model;

import com.rtdb.api.enums.RtdbType;
import com.rtdb.api.model.MemoryStream;
import com.rtdb.api.util.BytesConvertUtil;
import java.io.UnsupportedEncodingException;

public class NamedDataTypeField {
    private String FieldName = "";
    private RtdbType Type = RtdbType.RTDB_REAL32;
    private int Length;
    private String Desc = "";

    public String getFieldName() {
        return this.FieldName.trim();
    }

    public void setFieldName(String fieldName) {
        this.FieldName = fieldName;
    }

    public RtdbType getType() {
        return this.Type;
    }

    public void setType(RtdbType type) {
        this.Type = type;
    }

    public int getLength() {
        return this.Length;
    }

    public void setLength(int length) {
        this.Length = length;
    }

    public String getDesc() {
        return this.Desc;
    }

    public void setDesc(String desc) {
        this.Desc = desc;
    }

    public static NamedDataTypeField bytesToNamedDataTypeField(byte[] bytes) throws UnsupportedEncodingException {
        NamedDataTypeField ndtf = new NamedDataTypeField();
        MemoryStream stream = new MemoryStream(bytes);
        if (bytes.length <= 0) {
            return null;
        }
        ndtf.setFieldName(stream.readString(21));
        stream.readBytes(3);
        ndtf.setType(RtdbType.parse(stream.readInt()));
        ndtf.setLength(stream.readInt());
        ndtf.setDesc(stream.readString(100));
        return ndtf;
    }

    public static byte[] namedDataTypeFieldToByte(NamedDataTypeField ndtf) throws Exception {
        MemoryStream stream = new MemoryStream();
        byte[] name = ndtf.getFieldName().getBytes("GBK");
        byte[] nbname = new byte[21];
        System.arraycopy(name, 0, nbname, 0, name.length);
        stream.writeBytes(nbname);
        byte[] duiqiByte = new byte[3];
        stream.writeBytes(duiqiByte);
        stream.writeBytes(BytesConvertUtil.intToBytes(ndtf.Type.getNum()));
        stream.writeBytes(BytesConvertUtil.intToBytes(ndtf.Length));
        byte[] desc = ndtf.getFieldName().getBytes("GBK");
        byte[] nbdesc = new byte[100];
        System.arraycopy(desc, 0, nbdesc, 0, desc.length);
        stream.writeBytes(nbdesc);
        byte[] byteResult = stream.toByteArray();
        return byteResult;
    }
}

