/*
 * Decompiled with CFR 0.152.
 */
package com.rtdb.api.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class ConfigUtil {
    private static final String CONFIG_FILE = System.getProperty("user.dir") + File.separator + "conf" + File.separator + "rtdb-javasdk-config.properties";
    private static Properties properties = new Properties();

    public static String getString(String key, String defaultValue) {
        return properties.getProperty(key, defaultValue);
    }

    public static long getLong(String key, long defaultValue) {
        String str = properties.getProperty(key);
        if (null != str && !str.isEmpty()) {
            return Long.parseLong(str);
        }
        return defaultValue;
    }

    public static int getInt(String key, int defaultValue) {
        String str = properties.getProperty(key);
        if (null != str && !str.isEmpty()) {
            return Integer.parseInt(str);
        }
        return defaultValue;
    }

    static {
        BufferedInputStream bufferedInputStream = null;
        FileInputStream fileInputStream = null;
        try {
            System.out.println("config file path is:" + CONFIG_FILE);
            fileInputStream = new FileInputStream(CONFIG_FILE);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            properties.load(bufferedInputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != fileInputStream) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != bufferedInputStream) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

