/*
 * Decompiled with CFR 0.152.
 */
package com.rtdb.api.util;

import com.google.protobuf.ByteString;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class IPUtil {
    public static byte[] ipOrMaskToByte16(String strIPOrMask) throws UnknownHostException {
        byte[] bytes16 = new byte[16];
        InetAddress netAddress = InetAddress.getByName(strIPOrMask);
        byte[] tmpByte = netAddress.getAddress();
        if (strIPOrMask.indexOf(".") == -1 && (strIPOrMask.indexOf(":") == -1 || strIPOrMask.indexOf("::") == -1)) {
            bytes16[0] = tmpByte[3];
        } else {
            for (int i = 0; i < tmpByte.length; ++i) {
                bytes16[i] = tmpByte[i];
            }
        }
        return bytes16;
    }

    public static String[] getIpOrMaskFromByte16(ByteString strIP, ByteString strMask) throws UnknownHostException {
        String[] strResult = new String[2];
        byte[] byteMask = strMask.toByteArray();
        boolean isIpv4 = false;
        String heardMaskStr = String.valueOf(byteMask[0]);
        int heardMask = Integer.parseInt(heardMaskStr);
        for (int i = 1; i < byteMask.length; ++i) {
            if (byteMask[i] == 0) continue;
            isIpv4 = true;
            break;
        }
        if (!isIpv4) {
            boolean bl = isIpv4 = 0 > heardMask || heardMask > 128;
        }
        if (isIpv4) {
            int j;
            byte[] oldAddrByte = strIP.toByteArray();
            byte[] newAddrByte = new byte[4];
            byte[] newMaskByte = new byte[4];
            for (j = 0; j < 4; ++j) {
                newAddrByte[j] = oldAddrByte[j];
            }
            for (j = 0; j < 4; ++j) {
                newMaskByte[j] = byteMask[j];
            }
            InetAddress netAddr = Inet4Address.getByAddress(newAddrByte);
            strResult[0] = netAddr.getHostAddress();
            InetAddress netMask = Inet4Address.getByAddress(newMaskByte);
            strResult[1] = netMask.getHostAddress();
        } else {
            InetAddress netAddr = Inet6Address.getByAddress(strIP.toByteArray());
            strResult[0] = netAddr.getHostAddress();
            strResult[1] = heardMaskStr;
        }
        return strResult;
    }

    public static String getIpFromByte16(ByteString strIP) throws UnknownHostException {
        InetAddress netAddr = Inet6Address.getByAddress(strIP.toByteArray());
        return netAddr.getHostAddress();
    }

    public static int ipToInt(String strIp) {
        int[] ip = new int[4];
        int p1 = strIp.indexOf(".");
        int p2 = strIp.indexOf(".", p1 + 1);
        int p3 = strIp.indexOf(".", p2 + 1);
        ip[0] = Integer.parseInt(strIp.substring(0, p1));
        ip[1] = Integer.parseInt(strIp.substring(p1 + 1, p2));
        ip[2] = Integer.parseInt(strIp.substring(p2 + 1, p3));
        ip[3] = Integer.parseInt(strIp.substring(p3 + 1));
        return (ip[3] << 24) + (ip[2] << 16) + (ip[1] << 8) + ip[0];
    }

    public static String intToIp(int intIp) {
        StringBuffer sb = new StringBuffer("");
        sb.append(intIp >>> 24);
        sb.append(".");
        sb.append((intIp & 0xFFFFFF) >>> 16);
        sb.append(".");
        sb.append((intIp & 0xFFFF) >>> 8);
        sb.append(".");
        sb.append(intIp & 0xFF);
        return sb.toString();
    }

    public static String intToIp1(int intIp) {
        StringBuffer sb = new StringBuffer("");
        sb.append(String.valueOf(intIp & 0xFF));
        sb.append(".");
        sb.append(String.valueOf((intIp & 0xFFFF) >>> 8));
        sb.append(".");
        sb.append(String.valueOf((intIp & 0xFFFFFF) >>> 16));
        sb.append(".");
        sb.append(String.valueOf(intIp >>> 24));
        return sb.toString();
    }
}

