/*
 * Decompiled with CFR 0.152.
 */
package com.rtdb.service.impl;

import com.rtdb.api.impl.RtdbServerImpl;
import com.rtdb.api.inter.IServer;
import com.rtdb.api.model.Login;
import com.rtdb.api.model.SocketAddr;
import com.rtdb.service.impl.ServerImpl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServerImplPool {
    private int poolSize;
    private int maxSize;
    private Login login;
    private String ip;
    private int port;
    private long waitTimeMS = 60000L;
    private int idea_size = 0;
    private Log log = LogFactory.getLog(ServerImplPool.class);
    private Lock lockObject = new ReentrantLock(true);
    private Condition notEmpty = this.lockObject.newCondition();
    private HashMap<IServer, Boolean> serverMap = new HashMap();

    public long getWaitTimeMS() {
        return this.waitTimeMS;
    }

    public void setWaitTimeMS(long waitTimeMS) {
        this.waitTimeMS = waitTimeMS;
    }

    public ServerImplPool(String ip, int port, String user, String passWord, int poolSize, int maxSize) {
        this.initPool(ip, port, user, passWord, poolSize, maxSize);
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public int getRealSize() {
        return this.serverMap.size();
    }

    private void initPool(String ip, int port, String user, String passWord, int poolSize, int maxSize) {
        this.login = new Login(user, passWord);
        this.ip = ip;
        this.port = port;
        this.poolSize = poolSize;
        this.maxSize = maxSize;
        if (this.poolSize <= 0) {
            this.poolSize = 2;
        }
        if (this.maxSize < poolSize) {
            this.maxSize = poolSize * 2;
        }
    }

    public ServerImpl getServerImpl() throws Exception {
        this.lockObject.lock();
        try {
            for (Map.Entry<IServer, Boolean> tmpMap : this.serverMap.entrySet()) {
                if (tmpMap.getValue().booleanValue()) continue;
                tmpMap.setValue(true);
                IServer key = tmpMap.getKey();
                if (this.idea_size > 0) {
                    --this.idea_size;
                }
                ServerImpl serverImpl = new ServerImpl(key, this);
                return serverImpl;
            }
            if (this.serverMap.size() < this.maxSize) {
                SocketAddr socketAddr = new SocketAddr(this.ip, this.port);
                RtdbServerImpl impl = new RtdbServerImpl(socketAddr, this.login);
                ServerImpl currentServer = new ServerImpl(impl, this);
                currentServer.open();
                try {
                    currentServer.setTimeOut(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.serverMap.put(impl, true);
                ServerImpl serverImpl = currentServer;
                return serverImpl;
            }
            int count = 0;
            while (count < 3) {
                ++count;
                this.notEmpty.await(this.waitTimeMS, TimeUnit.MILLISECONDS);
                for (Map.Entry<IServer, Boolean> tmpMap : this.serverMap.entrySet()) {
                    if (tmpMap.getValue().booleanValue()) continue;
                    tmpMap.setValue(true);
                    IServer key = tmpMap.getKey();
                    if (this.idea_size > 0) {
                        --this.idea_size;
                    }
                    ServerImpl serverImpl = new ServerImpl(key, this);
                    return serverImpl;
                }
            }
            Iterator<Map.Entry<IServer, Boolean>> iterator = null;
            return iterator;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            this.lockObject.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseServerImpl(ServerImpl server) {
        if (server == null || server.isEmpty()) {
            return;
        }
        this.lockObject.lock();
        try {
            IServer curServer = server.getConnection();
            if (this.serverMap.containsKey(curServer)) {
                int curSize = this.serverMap.size();
                int ideaSize = 0;
                if (curSize > this.poolSize && (ideaSize = this.idea_size) >= this.poolSize / 2) {
                    this.destroyServer(curServer);
                    this.serverMap.remove(curServer);
                    return;
                }
                this.serverMap.put(curServer, false);
                server.setConnection(null);
                ++this.idea_size;
                this.notEmpty.signal();
            }
        }
        finally {
            this.lockObject.unlock();
        }
    }

    protected void removeServerImplFromPool(ServerImpl server) {
        if (server == null || server.isEmpty()) {
            return;
        }
        this.lockObject.lock();
        try {
            IServer curServer = server.getConnection();
            if (this.serverMap.containsKey(curServer)) {
                this.destroyServer(curServer);
                this.serverMap.remove(curServer);
                this.notEmpty.signal();
            }
        }
        finally {
            this.lockObject.unlock();
        }
    }

    public void closePool() {
        this.lockObject.lock();
        try {
            for (IServer impl : this.serverMap.keySet()) {
                this.destroyServer(impl);
            }
            this.serverMap.clear();
            this.idea_size = 0;
        }
        finally {
            this.lockObject.unlock();
        }
    }

    private void destroyServer(IServer impl) {
        block2: {
            try {
                impl.close();
            }
            catch (Exception ex) {
                if (!this.log.isDebugEnabled()) break block2;
                this.log.error(ex);
            }
        }
    }
}

