/*
 * Decompiled with CFR 0.152.
 */
package com.rtdb.until;

import com.rtdb.api.enums.RTDBClass;
import com.rtdb.api.enums.RtdbProcessName;
import com.rtdb.api.enums.RtdbType;
import com.rtdb.api.model.RtdbBasePoint;
import com.rtdb.api.model.RtdbBigJob;
import com.rtdb.api.model.RtdbBigJobName;
import com.rtdb.api.model.RtdbCalcPoint;
import com.rtdb.api.model.RtdbMaxCalcPoint;
import com.rtdb.api.model.RtdbMinCalcPoint;
import com.rtdb.api.model.RtdbScanPoint;
import com.rtdb.enums.ValueType;
import com.rtdb.model.BasePoint;
import com.rtdb.model.CalcPoint;
import com.rtdb.model.MaxCalcPoint;
import com.rtdb.model.MinCalcPoint;
import com.rtdb.model.ScanPoint;

public class RTDBConvert {
    public static RtdbBasePoint convertToRtBasePoint(BasePoint basePoint) {
        if (basePoint == null) {
            return null;
        }
        RtdbBasePoint point = new RtdbBasePoint();
        point.setTag(basePoint.getTag());
        point.setId(basePoint.getId());
        int num = basePoint.getType().getNum();
        RTDBClass classof = basePoint.getClassof();
        point.setType(RtdbType.parse(num));
        point.setTable(basePoint.getTable());
        point.setDesc(basePoint.getDesc());
        point.setUnit(basePoint.getUnit());
        point.setArchive(basePoint.getArchive());
        point.setDigits(basePoint.getDigits());
        point.setShutdown(basePoint.getShutdown());
        point.setLowlimit(basePoint.getLowlimit());
        point.setHighlimit(basePoint.getHighlimit());
        point.setStep(basePoint.getStep());
        point.setTypical(basePoint.getTypical());
        point.setCompress(basePoint.getCompress());
        point.setCompdev(basePoint.getCompdev());
        point.setCompdevpercent(basePoint.getCompdevpercent());
        point.setComptimemax(basePoint.getComptimemax());
        point.setComptimemin(basePoint.getComptimemin());
        point.setExcdev(basePoint.getExcdev());
        point.setExcdevpercent(basePoint.getExcdevpercent());
        point.setExctimemax(basePoint.getExctimemax());
        point.setExctimemin(basePoint.getExctimemin());
        point.setClassof(classof);
        point.setChangedate(basePoint.getChangedate());
        point.setChanger(basePoint.getChanger());
        point.setCreatedate(basePoint.getCreatedate());
        point.setCreator(basePoint.getCreator());
        point.setMirror(basePoint.getMirror());
        point.setMicrosecond(basePoint.getMicrosecond());
        point.setScanindex(basePoint.getScanindex());
        point.setCalcindex(basePoint.getCalcindex());
        point.setAlarmindex(basePoint.getAlarmindex());
        point.setTable_dot_tag(basePoint.getTable_dot_tag());
        point.setPadding(basePoint.getPadding());
        return point;
    }

    public static BasePoint convertToBasePoint(RtdbBasePoint basePoint) {
        if (basePoint == null) {
            return null;
        }
        BasePoint point = new BasePoint();
        point.setTag(basePoint.getTag());
        point.setId(basePoint.getId());
        point.setType(ValueType.parse(basePoint.getType().getNum()));
        point.setTable(basePoint.getTable());
        point.setDesc(basePoint.getDesc());
        point.setUnit(basePoint.getUnit());
        point.setArchive(basePoint.getArchive());
        point.setDigits(basePoint.getDigits());
        point.setShutdown(basePoint.getShutdown());
        point.setLowlimit(basePoint.getLowlimit());
        point.setHighlimit(basePoint.getHighlimit());
        point.setStep(basePoint.getStep());
        point.setTypical(basePoint.getTypical());
        point.setCompress(basePoint.getCompress());
        point.setCompdev(basePoint.getCompdev());
        point.setCompdevpercent(basePoint.getCompdevpercent());
        point.setComptimemax(basePoint.getComptimemax());
        point.setComptimemin(basePoint.getComptimemin());
        point.setExcdev(basePoint.getExcdev());
        point.setExcdevpercent(basePoint.getExcdevpercent());
        point.setExctimemax(basePoint.getExctimemax());
        point.setExctimemin(basePoint.getExctimemin());
        point.setClassof(basePoint.getClassof());
        point.setChangedate(basePoint.getChangedate());
        point.setChanger(basePoint.getChanger());
        point.setCreatedate(basePoint.getCreatedate());
        point.setCreator(basePoint.getCreator());
        point.setMirror(basePoint.getMirror());
        point.setMicrosecond(basePoint.getMicrosecond());
        point.setScanindex(basePoint.getScanindex());
        point.setCalcindex(basePoint.getCalcindex());
        point.setAlarmindex(basePoint.getAlarmindex());
        point.setTable_dot_tag(basePoint.getTable_dot_tag());
        point.setPadding(basePoint.getPadding());
        point.setClassof(basePoint.getClassof());
        return point;
    }

    public static RtdbScanPoint convertToRtScanPoint(ScanPoint scanPoint) {
        if (scanPoint == null) {
            return null;
        }
        RtdbScanPoint point = new RtdbScanPoint();
        point.setId(scanPoint.getId());
        point.setSource(scanPoint.getSource());
        point.setScan(scanPoint.getScan());
        point.setUserreals(scanPoint.getUserreals());
        point.setUserints(scanPoint.getUserints());
        point.setInstrument(scanPoint.getInstrument());
        point.setLocation(scanPoint.getLocation());
        return point;
    }

    public static RtdbMinCalcPoint convertToRtMinCalcPoint(MinCalcPoint minPoint) {
        if (minPoint == null) {
            return null;
        }
        RtdbMinCalcPoint point = new RtdbMinCalcPoint();
        point.setId(minPoint.getId());
        point.setEquation(minPoint.getEquation());
        point.setPeriod(minPoint.getPeriod());
        point.setTimecopy(minPoint.getTimecopy());
        point.setTrigger(minPoint.getTrigger());
        return point;
    }

    public static ScanPoint convertToScanPoint(RtdbScanPoint scanPoint) {
        if (scanPoint == null) {
            return null;
        }
        ScanPoint point = new ScanPoint();
        point.setId(scanPoint.getId());
        point.setSource(scanPoint.getSource());
        point.setScan(scanPoint.getScan());
        point.setUserreals(scanPoint.getUserreals());
        point.setUserints(scanPoint.getUserints());
        point.setInstrument(scanPoint.getInstrument());
        point.setLocation(scanPoint.getLocation());
        return point;
    }

    public static RtdbCalcPoint convertToRtCalcPoint(CalcPoint calPoint) {
        if (calPoint == null) {
            return null;
        }
        RtdbCalcPoint point = new RtdbCalcPoint();
        point.setId(calPoint.getId());
        point.setEquation(calPoint.getEquation());
        point.setPeriod(calPoint.getPeriod());
        point.setTimecopy(calPoint.getTimecopy());
        point.setTrigger(calPoint.getTrigger());
        return point;
    }

    public static MinCalcPoint convertToMinCalcPoint(MinCalcPoint minPoint) {
        if (minPoint == null) {
            return null;
        }
        MinCalcPoint point = new MinCalcPoint();
        point.setId(minPoint.getId());
        point.setEquation(minPoint.getEquation());
        point.setPadding(minPoint.getPadding());
        point.setPeriod(minPoint.getPeriod());
        point.setTimecopy(minPoint.getTimecopy());
        point.setTrigger(minPoint.getTrigger());
        return point;
    }

    public static CalcPoint convertToCalcPoint(RtdbCalcPoint calPoint) {
        if (calPoint == null) {
            return null;
        }
        CalcPoint point = new CalcPoint();
        point.setId(calPoint.getId());
        point.setEquation(calPoint.getEquation());
        point.setPeriod(calPoint.getPeriod());
        point.setTimecopy(calPoint.getTimecopy());
        point.setTrigger(calPoint.getTrigger());
        return point;
    }

    public static MaxCalcPoint convertToMaxCalcPoint(RtdbMaxCalcPoint calPoint) {
        if (calPoint == null) {
            return null;
        }
        MaxCalcPoint point = new MaxCalcPoint();
        point.setId(calPoint.getId());
        point.setEquation(calPoint.getEquation());
        point.setPeriod(calPoint.getPeriod());
        point.setTimecopy(calPoint.getTimecopy());
        point.setTrigger(calPoint.getTrigger());
        return point;
    }

    public static RtdbMaxCalcPoint convertToRtMaxCalcPoint(MaxCalcPoint calPoint) {
        if (calPoint == null) {
            return null;
        }
        RtdbMaxCalcPoint point = new RtdbMaxCalcPoint();
        point.setId(calPoint.getId());
        point.setEquation(calPoint.getEquation());
        point.setPeriod(calPoint.getPeriod());
        point.setTimecopy(calPoint.getTimecopy());
        point.setTrigger(calPoint.getTrigger());
        return point;
    }

    public static RtdbBigJob convertToRtdbBigJob(RtdbBigJob bigJob) {
        if (bigJob == null) {
            return null;
        }
        if (bigJob.getJob() == null) {
            return null;
        }
        RtdbBigJob pn = new RtdbBigJob();
        pn.setProcess(RtdbProcessName.parse(bigJob.getProcess().getNum()));
        pn.setPath(bigJob.getPath());
        pn.setFile(bigJob.getFile());
        pn.setJob(RtdbBigJobName.parse(bigJob.getJob().getNum()));
        pn.setState(bigJob.getState());
        pn.setEnd_time(bigJob.getEnd_time());
        pn.setProgress(bigJob.getProgress());
        return pn;
    }
}

