package com.beagle.base.bean.vo.resp;

import com.beagle.base.common.contant.CodeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;

/**
 * @author wuwanli
 */
@Data
@ToString
@ApiModel
public class ExtBaseResponse implements Serializable {
    /**
     * 返回码
     */
    @ApiModelProperty("返回码")
    private String code;
    /**
     * 返回描述
     */
    @ApiModelProperty("返回描述")
    private String msg;

    public static ExtBaseResponse success() {
        ExtBaseResponse baseResponse = new ExtBaseResponse();
        baseResponse.setCode(CodeEnum.SUCCESS.getCode());
        baseResponse.setMsg(CodeEnum.SUCCESS.getDesc());
        return baseResponse;
    }

    public static ExtBaseResponse fail() {
        ExtBaseResponse baseResponse = new ExtBaseResponse();
        baseResponse.setCode(CodeEnum.UNKNOWN.getCode());
        baseResponse.setMsg(CodeEnum.UNKNOWN.getDesc());
        return baseResponse;
    }

    public static ExtBaseResponse fail(CodeEnum codeEnum) {
        ExtBaseResponse baseResponse = new ExtBaseResponse();
        baseResponse.setCode(codeEnum.getCode());
        baseResponse.setMsg(codeEnum.getDesc());
        return baseResponse;
    }

    public static ExtBaseResponse fail(String code, String desc) {
        ExtBaseResponse baseResponse = new ExtBaseResponse();
        baseResponse.setCode(code);
        baseResponse.setMsg(desc);
        return baseResponse;
    }

    public static ExtBaseResponse fail(String desc) {
        ExtBaseResponse baseResponse = new ExtBaseResponse();
        baseResponse.setCode(CodeEnum.UNKNOWN.getCode());
        baseResponse.setMsg(desc);
        return baseResponse;
    }
}
