package com.beagle.base.common.config;

import com.beagle.base.common.filter.AuthenticationFilter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;

import com.beagle.base.common.filter.LogbackFilter;
/**
 * @author wuwanli
 */
@Configuration
public class FilterConfig {
    @Value("${server.servlet.context-path}")
    private String consoleUrl;
    @Bean
    public FilterRegistrationBean<LogbackFilter> getLogbackFilter() {
        FilterRegistrationBean<LogbackFilter> logbackFilter = new FilterRegistrationBean<>(new LogbackFilter());
        logbackFilter.addUrlPatterns("/*");
        logbackFilter.setOrder(Ordered.HIGHEST_PRECEDENCE);
        return logbackFilter;
    }
// 暂时去掉用户授权，验证主流程是否正确
//    @Bean
    public FilterRegistrationBean<AuthenticationFilter> authenticationFilterRegistration() {
        FilterRegistrationBean<AuthenticationFilter> registration =
            new FilterRegistrationBean<>(new AuthenticationFilter(consoleUrl));
        registration.addUrlPatterns("/*");
        registration.setName("authenticationFilter");
        registration.setOrder(1);
        return registration;
    }
}
